<?php
namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Question;
use App\Models\QuestionType;
use Illuminate\Support\Facades\DB;


class ApiController extends Controller
{
	protected $quest_cate = [];
	protected $quest_type = [];
	//protected $quest_no = 50;
	
    public function index(){
      
    }

    public function getQuestions(Request $request){

		//DB::enableQueryLog();
		 if(!empty($request->input('question_category')) && $request->input('question_category') != "all"){
			$this->quest_cate = explode(',',$request->input('question_category'));
		}
		if(!empty($request->input('question_type')) && $request->input('question_type') != "all"){
			$this->quest_type = explode(',',$request->input('question_type'));
			
		 }
		 if(!empty($request->input('question_number'))){
			$this->quest_no = $request->input('question_number');
		 }else{
			$this->quest_no = 50;
		 } 

		
	


		
		$optionArray = array(
			0 => 'a',
			1 => 'b',
			2 => 'c',
			3 => 'd',
            4 => 'e',
            5 => 'f',
            6 => 'g',
            7 => 'h',
            8 => 'i',
            9 => 'j',
            10 => 'k',
            11 => 'l',
            12 => 'm',
		);
		
		$finalQuestionArray = array();
		$query = Question::with('options')->where('question_is_active',1);
	

		$query->where(function ($query){
			
			$ctr = count($this->quest_cate);
			
			if($ctr == 1){
				$query->where('question_category', $this->quest_cate[0]);	
			}
			if($ctr > 1){
				foreach($this->quest_cate as $key=>$value){
					if($key==0){
						$query->where('question_category', $value);			
					}else{
						$query->orWhere('question_category', $value);			
					}
				}
			}
		});

		$query->where(function ($query){
			$ctr2 = count($this->quest_type);
			$question_typeArray = array(
				1 =>	"Definitely Definitions", 
				2=> 	"Fill in the Blank",
				3=>		"The Numbers Game",
				4 =>	"True or False",		
				5=> 	"Either Or",		
				6=> 	"Six of the Best",		
				7=> 	"Sequences", 		
				8 =>	"Matching Items", 		
				9 =>	"Multiple Choice", 	
				10=> 	"Flash Cards",
		
			);
			
			if($ctr2 == 1){
				
				$key = array_search ($this->quest_type[0], $question_typeArray);
				//print_r($key ); die;
				$query->where('type_id', $key);	
			}
			if($ctr2 > 1){
				foreach($this->quest_type as $key=>$value){
					if($key==0){
						$key1 = array_search ($value, $question_typeArray);
						$query->where('type_id', $key1);			
					}else{
						
						$key1 = array_search ($value, $question_typeArray);
						
						$query->orWhere('type_id', $key1);			
					}
				}
			}
		});
    
		//$query->orderBy('id', 'ASC');
		$query->limit($this->quest_no);
		$questionsArray = $query->inRandomOrder()->get();
		//$questionsArray = $query->get();
			//print_r($questionsArray); die;
		if(!empty($questionsArray)){
	
			foreach($questionsArray as $k => $v){
				if($v->type_id == 8){
    				$v->question_title = json_decode($v->question_title, true, JSON_UNESCAPED_SLASHES); 
					$finalQuestionArray[$k]['question'] = $v->question_title;
				}
				$finalQuestionArray[$k]['que_No'] = $v->id;
				$finalQuestionArray[$k]['que_type'] = isset($v->type_id)?$this->getTypename($v->type_id):"";
				$finalQuestionArray[$k]['question'] = $v->question_title;
				$finalQuestionArray[$k]['que_topic'] = $v->question_topic;
				$finalQuestionArray[$k]['ins'] = $v->question_instructions;
				$finalQuestionArray[$k]['que_category'] = isset($v->question_category)?$v->question_category:"";
				$questionOption = array();
				$optionAnswer = array();
				$optionCorrectAnswer = '';
				foreach($v->options as $key => $val){
                    
					$questionOption[$optionArray[$key]] = $val->option_value;
					if($v->type_id == 6){
							if($val->correct_answer == true){
								$optionAnswer[] = $optionArray[$key];
							}
						}else{
							$optionAnswer[] = $val->correct_answer;
						}
					
				}
				if($v->type_id == 6){
					$correctAnswer = $optionAnswer;
				}else{
					if(!empty($optionAnswer)){
				
						foreach($optionAnswer as $key => $vals){
							if($vals){
								$optionCorrectAnswer = $key;
							}
						}
					}
					
					$correctAnswer = isset($optionArray[$optionCorrectAnswer])?$optionArray[$optionCorrectAnswer]:'';
				}
				//print_r($optionAnswer) ; die;
				
				
				//$correctAnswer = print_r($v->correct_answer);
				$finalQuestionArray[$k]['options'] = $questionOption;
				$finalQuestionArray[$k]['ans'] = $correctAnswer;
			}
		}

		//echo "<pre>";print_r($finalQuestionArray);die;
		
		if(count($finalQuestionArray)>0){
		    return $this->sendResponse($finalQuestionArray, 'Questions fetched successfully.');
        }else{
            return $this->sendResponse($finalQuestionArray, 'Record not found');
        }
	}

    public function sendResponse($result, $message)
    {
    	$response = [
            'success' => true,
            'questions'    => $result,
            'message' => $message,
        ];
        return response()->json($response, 200);
    }

	private function getTypename($id){
		$db = QuestionType::where('id',$id)->first();
		return str_replace(" ","_",$db->type_title);
	}
    private function getCatname($id){
		$db = QuestionType::where('id',$id)->first();
		return str_replace(" ","_",$db->type_title);
	}
}
