<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\User;
#use App\Models\Slider;
#use App\Models\Order;
#use App\Models\Notification;
#use App\Models\Game;
#use App\Models\Coupon;
#use App\Models\ContactUS;
#use LaravelDaily\LaravelCharts\Classes\LaravelChart;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App;
use DB;

class DashboardController extends Controller
{
	/**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }
	
    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        
        
		$dashboardData = array();
		return view('layouts.backend.dashboard', compact('dashboardData'))->with('success','User added successfully.');;
    }
	
    public function uploadimage(Request $request) {
        if(isset($_FILES['file'])) {
            $img = $_FILES['file'];
            $new_name =  time() . $img["name"];
            $filePath = public_path ().'/uploads/';
            $path =  $filePath.$new_name;
            if (!file_exists($filePath)) {
                mkdir($filePath, 0777, true);
            }
            move_uploaded_file($img['tmp_name'], $path);
            $imgURL = URL::to('/').'/public/uploads/'.$new_name;
            $image = '<img src="'.$imgURL.'" />';
            echo $imgURL;
            exit();
        }
    }
	
    /**
     * @method used in upload the editor image
     *
     * @param  \Illuminate\Http\Request  $request
     * @return string
     */
    public function uploadEditorImage(Request $request) {
        if ($files = $request->file('file')) {
            $name = $files->getClientOriginalName();
            $new_name =  time().'_'.$name;
            $editorImagePath = public_path('uploads/editor_images');
            if (!file_exists($editorImagePath)) {
                @mkdir($editorImagePath, 0777, true);
            }
            $editorImg = Image::make($files->getRealPath());
            $editorImg->save($editorImagePath.'/'.$new_name, 100);
            $imgURL = '/public/uploads/editor_images/'.$new_name;
            $image = '<img src="'.$imgURL.'" />';
            echo $imgURL;
            exit();
        }
    }
    
    /**
     * used to set desired language
     *
     * @param string $locale
     * @return void
     * 
     */
    public function setLanguage($locale)
    {
        App::setLocale($locale);
        session()->put('locale', $locale);
        return redirect('/backend/dashboard');
    }
    
    /**
     * Show the form for editing the specified resource for password change.
     * 
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\User  $user
     * 
     * @return \Illuminate\Http\Response
     */
    public function changePassword(Request $request, User $user)
    {
        $oldPassword = $request->input('old_password');
        $newPassword = $request->input('new_password');
        $confirmPassword = $request->input('password_confirmation');
        if ($request->isMethod('post') && !empty($oldPassword) && !empty($newPassword) && !empty($confirmPassword)) {
            if (!(Hash::check($request->get('old_password'), Auth::user()->password))) {
                // The passwords not matches
                flash(__('messages.Your current password does not matches with the password you provided.'), 'error');
                return back()->withInput();
            }
            //uncomment this if you need to validate that the new password is same as old one
            if(strcmp($request->get('old_password'), $request->get('new_password')) == 0){
                //Current password and new password are same
                flash(__('messages.New Password cannot be same as your current password. Please choose a different password.'), 'error');
                return back()->withInput();
            }
            if(trim($request->get('password_confirmation')) != trim($request->get('new_password'))){
                //Current password and new password are same
                flash(__('messages.New Password and confirm password should be same.'), 'error');
                return back()->withInput();
            }
            $validatedData = $request->validate([
                'old_password' => 'required',
                'new_password' => 'required|string|min:8',
            ]);
            $user = Auth::user();
            $user->password = Hash::make($request->get('new_password'));
            if ($user->save()) {
                flash(__('messages.Password has been changed successfully.'), 'success');
                return redirect('/backend/dashboard');
            } else {
                return back()->withInput();
                flash(__('messages.Password could not be changed, please try again.'), 'error');
            }
        } elseif ($request->isMethod('post') && (empty($oldPassword) || empty($newPassword) || empty($confirmPassword))) {
            flash(__('messages.Please fill all required fields.'), 'error');
            return back()->withInput();
        }
        return view('backend.change_password');
    }
}
