<?php

namespace App\Http\Controllers\Backend;

use App\Imports\ImportQuestion;
use App\Imports\fitbImportQuestion;
use App\Imports\tngImportQuestion;
use App\Imports\TorFImportQuestion;
use App\Imports\EitherOrImportQuestion;
use App\Imports\SixofBestImportQuestion;
use App\Imports\SequenceImportQuestion;
use App\Imports\MatchingItemsImportQuestion;
use App\Imports\MultipleChoiceImportsQuestion;
use App\Imports\FlashCardsImportsQuestion;
use Illuminate\Support\Facades\Validator;
use App\Models\Question;
use App\Models\Questionoption;

use App\Models\Language;
use App\Models\QuestionType;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

use Image;
use Excel;
use Illuminate\Support\Collection;

use App\Exports\QuestionaExport;
use App\Exports\ExportQuestion;
use Illuminate\Support\Facades\Redirect;

class QuestionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('backend.questions.index');
    }
	
	
	public function importView(Request $request){
        $types = QuestionType::where('type_is_active',1)->get();

        return view('backend.questions.import',compact('types'));
    }

    public function import(Request $request){

        $types = QuestionType::where('type_is_active',1)->get();

        $validated = $request->validate([
            'question_type' => 'required',
            'file' => 'required'
        ]);

        
        

        if(isset($request->question_type) && !empty($request->question_type) && $request->question_type=='1'){

            $rows = Excel::toArray(new ImportQuestion, $request->file('file'));
            $ele = array_pop($rows);
            $col_count = count($ele[0]);
            if($col_count==16){ // set here the column number
                Excel::import(new ImportQuestion, $request->file('file')->store('files'));
                return Redirect::back()->with('success','File uploaded successfully.');
            }else{
                return Redirect::back()->withErrors(['error' => 'Invalid file format. Please check file']);
            }
           
        }elseif(isset($request->question_type) && !empty($request->question_type) && $request->question_type=='2'){
            
            $rows = Excel::toArray(new fitbImportQuestion, $request->file('file'));
            $ele = array_pop($rows);
            $col_count = count($ele[0]);
            if($col_count==16){ // set here the column number
                Excel::import(new fitbImportQuestion, $request->file('file')->store('files'));
                return Redirect::back()->with('success','File uploaded successfully.');
            }else{
                return Redirect::back()->withErrors(['error' => 'Invalid file format. Please check file']);
            }

        }elseif(isset($request->question_type) && !empty($request->question_type) && $request->question_type=='3'){
            
            $rows = Excel::toArray(new tngImportQuestion, $request->file('file'));
            $ele = array_pop($rows);
            $col_count = count($ele[0]);
            if($col_count==16){ // set here the column number
                Excel::import(new tngImportQuestion, $request->file('file')->store('files'));
                return Redirect::back()->with('success','File uploaded successfully.');
            }else{
                return Redirect::back()->withErrors(['error' => 'Invalid file format. Please check file']);
            }
            
        }elseif(isset($request->question_type) && !empty($request->question_type) && $request->question_type=='4'){
            
            $rows = Excel::toArray(new TorFImportQuestion, $request->file('file'));
            $ele = array_pop($rows);
            $col_count = count($ele[0]);
            if($col_count==8){ // set here the column number
                Excel::import(new TorFImportQuestion, $request->file('file')->store('files'));
                return Redirect::back()->with('success','File uploaded successfully.');
            }else{
                return Redirect::back()->withErrors(['error' => 'Invalid file format. Please check file']);
            }
            
        }elseif(isset($request->question_type) && !empty($request->question_type) && $request->question_type=='5'){
            
            $rows = Excel::toArray(new EitherOrImportQuestion, $request->file('file'));
            $ele = array_pop($rows);
            $col_count = count($ele[0]);
            if($col_count==8){ // set here the column number
                Excel::import(new EitherOrImportQuestion, $request->file('file')->store('files'));
                return Redirect::back()->with('success','File uploaded successfully.');
            }else{
                return Redirect::back()->withErrors(['error' => 'Invalid file format. Please check file']);
            }
            
        }elseif(isset($request->question_type) && !empty($request->question_type) && $request->question_type=='6'){
            
            $rows = Excel::toArray(new SixofBestImportQuestion, $request->file('file'));
            $ele = array_pop($rows);
            $col_count = count($ele[0]);
            if($col_count==23){ // set here the column number
                Excel::import(new SixofBestImportQuestion, $request->file('file')->store('files'));
                return Redirect::back()->with('success','File uploaded successfully.');
            }else{
                return Redirect::back()->withErrors(['error' => 'Invalid file format. Please check file']);
            }
            
        }elseif(isset($request->question_type) && !empty($request->question_type) && $request->question_type=='7'){
            
            $rows = Excel::toArray(new SequenceImportQuestion, $request->file('file'));
            $ele = array_pop($rows);
            $col_count = count($ele[0]);
            
            if(is_int($ele[0][4])){ // check fifth column of excel whether it is int or not.(ie number of steps)
                Excel::import(new SequenceImportQuestion, $request->file('file')->store('files'));
                return Redirect::back()->with('success','File uploaded successfully.');
            }else{
                return Redirect::back()->withErrors(['error' => 'Invalid file format. Please check file']);
            }
            
        }elseif(isset($request->question_type) && !empty($request->question_type) && $request->question_type=='8'){
            
            $rows = Excel::toArray(new MatchingItemsImportQuestion, $request->file('file'));
            $ele = array_pop($rows);
            $col_count = count($ele[0]);
            if($col_count==12){ // set here the column number
                Excel::import(new MatchingItemsImportQuestion, $request->file('file')->store('files'));
                return Redirect::back()->with('success','File uploaded successfully.');
            }else{
                return Redirect::back()->withErrors(['error' => 'Invalid file format. Please check file']);
            }
            
        }elseif(isset($request->question_type) && !empty($request->question_type) && $request->question_type=='9'){
            
            $rows = Excel::toArray(new MultipleChoiceImportsQuestion, $request->file('file'));
            $ele = array_pop($rows);
            $col_count = count($ele[0]);
            if($col_count==10){ // set here the column number
                Excel::import(new MultipleChoiceImportsQuestion, $request->file('file')->store('files'));
                return Redirect::back()->with('success','File uploaded successfully.');
            }else{
                return Redirect::back()->withErrors(['error' => 'Invalid file format. Please check file']);
            }

        }elseif(isset($request->question_type) && !empty($request->question_type) && $request->question_type=='10'){
            
            $rows = Excel::toArray(new FlashCardsImportsQuestion, $request->file('file'));
            $ele = array_pop($rows);
            $col_count = count($ele[0]);
            if($col_count==6){ // set here the column number
                Excel::import(new FlashCardsImportsQuestion, $request->file('file')->store('files'));
                return Redirect::back()->with('success','File uploaded successfully.');
            }else{
                return Redirect::back()->withErrors(['error' => 'Invalid file format. Please check file']);
            }

        }



        return view('backend.questions.import',compact('types'));
        
    }

    public function exportQuestions(Request $request){

        return Excel::download(new ExportQuestion, 'questions.xlsx');
        
    }
 
    public function allQuestion(Request $request){
        
        $question_data = Question::where('question_is_active',1)->get();

        return view('backend.questions.all',compact('question_data'));

    }

     /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function add(Request $request)
    {
        $question_type =  $request->route('id');
		$option_array = array();
		$questiontypes = Questiontype::pluck('type_title', 'id')->all();
		$questiontype_array = array();
        if (!empty($questiontypes)) {
            foreach ($questiontypes as $key => $value) {
                $questiontype_array[$key] = $value;
            }
        }
		$option_array = array(
			'optionOne' => 'Option A',
			'optionTwo' => 'Option B',
			'optionThree' => 'Option C',
			'optionFour' => 'Option D',
		);
        
        
        $questioncat_array  = array(
            'Assertiveness' => 'Assertiveness',
            'Change Management' => 'Change Management',
            'Communications' => 'Communications',
            'Counselling Skills' => 'Counselling Skills',
            'Customer Care' => 'Customer Care',
            'Delegation and Empowerment' => 'Delegation and Empowerment',
            'Effective Discipline' => 'Effective Discipline',
            'Enneagram PersonalityTypes' => 'Enneagram Personality Types',
            'Facilitation Skills' => 'Facilitation Skills',
            'Influencing and Negotiating Skills' => 'Influencing and Negotiating Skills',
            'Leadership Skills' => 'Leadership Skills',
            'Maximising Your Potential' => 'Maximising Your Potential',
            'Performance Management and Appraisal' => 'Performance Management and Appraisal',
            'Presentation Skills' => 'Presentation Skills',
            'Recruitment and Selection' => 'Recruitment and Selection',
            'Stress Management' => 'Stress Management',
            'Teambuilding' => 'Teambuilding',
            'Thinking Skills' => 'Thinking Skills',
            'Time Management' => 'Time Management',
            'Training Skills' => 'Training Skills',
            
        );
        //multi choice question topics
        $question_topics_multi_choice  = array( 
            'What is Assertiveness?' => 'What is Assertiveness?',
            'The Origins of Assertiveness' => 'The Origins of Assertiveness',
            'Facets of Assertiveness' => 'Facets of Assertiveness',
            'Applications of Assertiveness' => 'Applications of Assertiveness',
            'Techniques of Assertiveness'=>'Techniques of Assertiveness',
            'Managing Assertively'=>'Managing Assertively',
            'Social Assertiveness'=>'Social Assertiveness',
            'Assertive Roles at Work'=>'Assertive Roles at Work',
            'Managing Your Boss Assertively'=>'Managing Your Boss Assertively',
            'Assertiveness Training'=>'Assertiveness Training',
            'What is Change Management?'=>'What is Change Management?',
            'Responding to Change'=>'Responding to Change',
            'Managing the Change Cycle'=>'Managing the Change Cycle',
            'Cores and Peripheries'=>'Cores and Peripheries',
            'Managing Paradox'=>'Managing Paradox',
            'Managing Risk in Times of Change'=>'Managing Risk in Times of Change',
            'Managing Learning in Times of Change'=>'Managing Learning in Times of Change',
            'The Process of Change'=>'The Process of Change',
            'Managing Uncertainty'=>'Managing Uncertainty',
            'Organisational Change'=>'Organisational Change',
            'Communications'=>'Communications',
            'Communication Strategies'=>'Communication Strategies',
            'Communication Networks'=>'Communication Networks',
            'The Means of Communication'=>'The Means of Communication',
            'Communication Barriers'=>'Communication Barriers',
            'Communication Styles'=>'Communication Styles',
            'The ABC of Writing'=>'The ABC of Writing',
            'The Art of Conversation'=>'The Art of Conversation',
            'Interpersonal Skills'=>'Interpersonal Skills',
            'Non-Verbal Communication'=>'Non-Verbal Communication',
            'The Counselling Approach'=>'The Counselling Approach',
            'Awareness, Acceptance, and Change'=>'Awareness, Acceptance, and Change',
            'Personal Growth'=>'Personal Growth',
            'The Dispositions of Counselling'=>'The Dispositions of Counselling',
            'The Counselling Interview'=>'The Counselling Interview',
            'The Art of Listening'=>'The Art of Listening',
            'Asking Questions'=>'Asking Questions',
           'Challenging and Closing Down'=>'Challenging and Closing Down',
           'Moving On'=>'Moving On',
           'People Problems'=>'People Problems',
           'What is Customer Care?'=>'What is Customer Care?',
           'Ichiban to Kaizen' =>'Ichiban to Kaizen',
           'Customer Focus' =>'Customer Focus',
           'The Customer Promise'=>'The Customer Promise',
           'Customer Champions'=>'Customer Champions',
           'Customer Feedback'=>'Customer Feedback',
           'Moments of Truth'=>'Moments of Truth',
           'Customer Relations'=>'Customer Relations',
           'Customer Complaints' =>'Customer Complaints',
           'Service Style'=>'Service Style',
           'From Directing to Delegating'=>'From Directing to Delegating',
           'Models of Management'=>'Models of Management',
           'Types of Delegating'=>'Types of Delegating',
           'Delegate to Develop'=>'Delegate to Develop',
           'Delegating as a Manager'=>'Delegating as a Manager',
           'Power and Empowerment'=>'Power and Empowerment',
           'Empowered Organisations'=>'Empowered Organisations',
           'Empowered Leaders' =>'Empowered Leaders',
           'DIY Empowerment'=>'DIY Empowerment',
           'The 21st Century Manager'=>'The 21st Century Manager',
           'Routes to Discipline'=>'Routes to Discipline',
           'Laws and Rules'=>'Laws and Rules',
           'Non-Compliance'=>'Non-Compliance',
           'Problem Behaviour'=>'Problem Behaviour',
           'Fair and Full Investigation'=>'Fair and Full Investigation',
           'Alternatives to Discipline' =>'Alternatives to Discipline',
           'Disciplinary Policy and Procedure'=>'Disciplinary Policy and Procedure',
           'Counselling and Discipline'=>'Counselling and Discipline',
           'The Disciplinary Hearing'=>'The Disciplinary Hearing',
           'Fair Dismissal'=>'Fair Dismissal',
           'What is Personality?'=>'What is Personality?',
           'The Enneagram'=>'The Enneagram',
           'Ones, the Need to be Perfect'=>'Ones, the Need to be Perfect',
           'Twos, the Need to be Needed'=>'Twos, the Need to be Needed',
           'Threes, the Need to Succeed'=>'Threes, the Need to Succeed',
           'Fours, the Need to be Special'=>'Fours, the Need to be Special',
           'Fives, the Need to Perceive'=>'Fives, the Need to Perceive',
           'Sixes, the Need to be Safe' =>'Sixes, the Need to be Safe',
           'Sevens, the Need to be Happy'=>'Sevens, the Need to be Happy',
           'Eights, the Need to be Strong'=>'Eights, the Need to be Strong',
           'Nines, the Need to be at Peace'=>'Nines, the Need to be at Peace',
           'Managing Personality Types'=>'Managing Personality Types',
           'Twos, the Need to be Needed'=>'Twos, the Need to be Needed',
           'Threes, the Need to Succeed'=>'Threes, the Need to Succeed',
           'Fours, the Need to be Special'=>'Fours, the Need to be Special',
           'Fives, the Need to Perceive' =>'Fives, the Need to Perceive',
           'Sixes, the Need to be Safe'=>'Sixes, the Need to be Safe',
           'Sevens, the Need to be Happy'=>'Sevens, the Need to be Happy',
           'Eights, the Need to be Strong'=>'Eights, the Need to be Strong',
           'What is Facilitation?'=>'What is Facilitation?',
           'People and Groups'=>'People and Groups',
           'Facilitating the Start of Groupwork'=>'Facilitating the Start of Groupwork',
           'Control and Power in Facilitation'=>'Control and Power in Facilitation',
           'Empowering the Group'=>'Empowering the Group',
           'Overcoming the Blocks to Growth'=>'Overcoming the Blocks to Growth',
           'The Facilitators Toolkit'=>'The Facilitators Toolkit',
           'Overcoming the Blocks to Growth'=>'Overcoming the Blocks to Growth',
           'The Art of Non-Doing'=>'The Art of Non-Doing',
           'Group Energy'=>'Group Energy',
           'The Role of the Facilitator'=>'The Role of the Facilitator',
           'Group Endings and Separations'=>'Group Endings and Separations',
           'Influencing Skills' =>'Influencing Skills',
           'Negotiating Skills' =>'Negotiating Skills',
           'Preparing for Negotiations'=>'Preparing for Negotiations',
           'A Negotiation Game Plan'=>'A Negotiation Game Plan',
           'Power and Negotiations'=>'Power and Negotiations',
           'The Options in Conflict' =>'The Options in Conflict',
           'Making Your Case in Negotiations' =>'Making Your Case in Negotiations',
           'Stick to Your Guns in Negotiations'=>'Stick to Your Guns in Negotiations',
           'A Successful Negotiation'=>'A Successful Negotiation',
           'Agreement and After'=>'Agreement and After',
           'Management and Leadership'=>'Management and Leadership',
           'The Making of Leaders'=>'The Making of Leaders',
           'Leaders and Their Personalities'=>'Leaders and Their Personalities',
           'Mission, Vision, and Values'=>'Mission, Vision, and Values',
           'Organisational Culture'=>'Organisational Culture',
           'Leadership Styles'=>'Leadership Styles',
           'Master Communicators'=>'Master Communicators',
           'People Builders'=>'People Builders',
           'The Credibility of Leadership'=>'The Credibility of Leadership',
           'Leaders of the Future'=>'Leaders of the Future',
           'The Nature of Potential'=>'The Nature of Potential',
           'Self-Development'=>'Self-Development',
           'Know Yourself'=>'Know Yourself',
           'Goals and Goal-Setting'=>'Goals and Goal-Setting',
           'Programming Your Goals'=>'Programming Your Goals',
           'Super-Energy'=>'Super-Energy',
           'Action and Progress'=>'Action and Progress',
           'The 3lb Universe'=>'The 3lb Universe',
           'Positivity'=>'Positivity',
           'From Mastery to Mystery'=>'From Mastery to Mystery',
           'Goal-Setting'=>'Goal-Setting',
           'What is Performance Appraisal?'=>'What is Performance Appraisal?',
           'Performance Appraisal Schemes'=>'Performance Appraisal Schemes',
           'Assessing Performance'=>'Assessing Performance',
           'The Performance Appraisal Interview'=>'The Performance Appraisal Interview',
           'Managing the Under-Performer'=>'Managing the Under-Performer',
           'The Plateau-ed Performer'=>'The Plateau-ed Performer',
           'Managing the High Flyer'=>'Managing the High Flyer',
           'Constructive Feedback'=>'Constructive Feedback',
           'Play to their Strengths'=>'Play to their Strengths',
           'Outcomes of Appraisal'=>'Outcomes of Appraisal',
           'Play to their Strengths'=>'Play to their Strengths',
           'SUCCEED in Presentations'=>'SUCCEED in Presentations',
           'A Business Audience'=>'A Business Audience',
           'The Structure of Presentations'=>'The Structure of Presentations',
           'Preparing the Presentation'=>'Preparing the Presentation',
           'Presentation Techniques'=>'Presentation Techniques',
           'Using Your Voice'=>'Using Your Voice',
           'Visual Aids'=>'Visual Aids',
           'Body Language in Presentations'=>'Body Language in Presentations',
           'Overcoming Your Speaking Nerves'=>'Overcoming Your Speaking Nerves',
           'Mastering the Delivery'=>'Mastering the Delivery',
           'Approaches to Recruitment'=>'Approaches to Recruitment',
           'Being Fair in Recruitment'=>'Being Fair in Recruitment',
           'Policy and Procedure in Selection'=>'Policy and Procedure in Selection',
           'Groundwork for Hiring'=>'Groundwork for Hiring',
           'Filling the Vacancy'=>'Filling the Vacancy',
           'The Selection Interview'=>'The Selection Interview',
           'Selection Interview Skills'=>'Selection Interview Skills',
           'Go and No Go Questions'=>'Go and No Go Questions',
           'Tests and Assessments'=>'Tests and Assessments',
           'Selection and Appointment'=>'Selection and Appointment',
           'The Nature of Stress'=>'The Nature of Stress',
           'Stressors'=>'Stressors',
           'Coping with Stress'=>'Coping with Stress',
           'Managing the Physical'=>'Managing the Physical',
           'Stress Solutions'=>'Stress Solutions',
           'Managing Perceptions'=>'Managing Perceptions',
           'Managing Emotions'=>'Managing Emotions',
           'Managing Perspective'=>'Managing Perspective',
           'Focused Relaxation'=>'Focused Relaxation',
           'Stress-Busters'=>'Stress-Busters',
           'The Nature of Teams'=>'The Nature of Teams',
           'Team Development' =>'Team Development',
           'Teamwork'=>'Teamwork',
           'Team Cohesion'=>'Team Cohesion',
           'Threats to Teamwork'=>'Threats to Teamwork',
           'Team Leadership'=>'Team Leadership',
           'Team Roles'=>'Team Roles',
           'Team Meetings'=>'Team Meetings',
           'Unshared Certainty to Shared Uncertainty'=>'Unshared Certainty to Shared Uncertainty',
           'Teambuilders'=>'Teambuilders',
           'What Are Thinking Skills?'=>'What Are Thinking Skills?',
           'The Thoughts In Your Head'=>'The Thoughts In Your Head',
           'Memory, Concentration, and Imagination'=>'Memory, Concentration, and Imagination',
           'Blocks to Thinking'=>'Blocks to Thinking',
           'Reasoned Thinking'=>'Reasoned Thinking',
           'Creative Thinking'=>'Creative Thinking',
           'Brainstorming'=>'Brainstorming',
           'Decision-Taking'=>'Decision-Taking',
           'Problem-Solving'=>'Problem-Solving',
           'Innovation'=>'Innovation',
           'The Paradoxes of Time'=>'The Paradoxes of Time',
           'Working Time'=>'Working Time',
           'Models of Time Management'=>'Models of Time Management',
           'Routine Time'=>'Routine Time',
           'Time on Progress Work'=>'Time on Progress Work',
           'Time and Projects'=>'Time and Projects',
           'Non-Doing Work'=>'Non-Doing Work',
           'Time and Others'=>'Time and Others',
           'Time Travellers'=>'Time Travellers',
           'Personal Effectiveness'=>'Personal Effectiveness',
           'The Need for Training'=>'The Need for Training',
           'Managing Training'=>'Managing Training',
           'Models of Learning'=>'Models of Learning',
           'Designing Training'=>'Designing Training',
           'Running a Course'=>'Running a Course',
           'The Process of Training'=>'The Process of Training',
           'Groupwork and Training'=>'Groupwork and Training',
           'Learning Styles'=>'Learning Styles',
           'The Resourceful Trainer'=>'The Resourceful Trainer',
           'Evaluating Training'=>'Evaluating Training',
        ); 
       // Question topic flash card
       $question_topics_flash_card  = array( 
        'What Is Assertiveness?'=>'What Is Assertiveness?',
        'The Origins of Assertiveness'=>'The Origins of Assertiveness',
        'Facets of Assertiveness'=>'Facets of Assertiveness',
        'Applications of Assertiveness'=>'Applications of Assertiveness',
        'Techniques of Assertiveness'=>'Techniques of Assertiveness',
        'Managing Assertively'=>'Managing Assertively',
        'Social Assertiveness'=>'Social Assertiveness',
        'Assertive Roles at Work'=>'Assertive Roles at Work',
        'Managing Your Boss Assertively'=>'Managing Your Boss Assertively',
        'Assertiveness Training'=>'Assertiveness Training',
        'What is Change Management?'=>'What is Change Management?',
        'Responding to Change'=>'Responding to Change',
        'Managing the Change Cycle'=>'Managing the Change Cycle',
        'Cores and Peripheries'=>'Cores and Peripheries',
        'Managing Paradox'=>'Managing Paradox',
        'Managing Risk' =>'Managing Risk',  
        'Managing Learning'=>'Managing Learning',
        'The Process of Change'=>'The Process of Change',
        'Managing Uncertainty'=>'Managing Uncertainty',
        'Organisational Change'=>'Organisational Change',
        'Communications'=>'Communications',
        'Communication Strategies'=>'Communication Strategies',
        'Communication Networks'=>'Communication Networks',
        'The Means of Communication'=>'The Means of Communication',
        'Communication Barriers'=>'Communication Barriers',
        'Communication Styles'=>'Communication Styles',
        'The ABC of Writing'=>'The ABC of Writing',
        'The Art of Conversation'=>'The Art of Conversation',
        'The Interpersonal Dance' =>'The Interpersonal Dance',
        'Non-Verbal Communication' =>'Non-Verbal Communication',
        'The Counselling Approach'  =>'The Counselling Approach',
        'Awareness, Acceptance, and Change'=>'Awareness, Acceptance, and Change',
        'Personal Growth'=>'Personal Growth',
        'The Dispositions of Counselling'=>'The Dispositions of Counselling',
        'The Counselling Interview' =>'The Counselling Interview',    
        'The Art of Listening'=>'The Art of Listening',
        'Asking Questions'=>'Asking Questions',
        'Challenging and Closing Down'=>'Challenging and Closing Down',
        'Moving On From Counselling'=>'Moving On From Counselling',
        'People Problems'=>'People Problems',
        'What is Customer Care?'=>'What is Customer Care?',
        'Ichiban to Kaizen'=>'Ichiban to Kaizen',
        'Customer Focus'=>'Customer Focus',
        'The Customer Promise'=>'The Customer Promise' ,  
        'Customer Champions'=>'Customer Champions',
        'Customer Feedback'=>'Customer Feedback',
        'Moments of Truth'=>'Moments of Truth',
        'Customer Relations'=>'Customer Relations',
        'Customer Complaints'=>'Customer Complaints',
        'Service Style'=>'Service Style',
        'From Directing To Delegating'=>'From Directing To Delegating',
        'Models Of Management'=>'Models Of Management',
        'Types Of Delegating'=>'Types Of Delegating',
        'Delegate To Develop'=>'Delegate To Develop',
        'Delegating As A Manager'=>'Delegating As A Manager',
        'Power And Empowerment'=>'Power And Empowerment',
        'Empowered Organisations'=>'Empowered Organisations',
        'Empowering Leaders'=>'Empowering Leaders',
        'DIY Empowerment'=>'DIY Empowerment',
        'The 21st Century Manager'=>'The 21st Century Manager',
        'Routes to Discipline'=>'Routes to Discipline',
        'Laws and Rules'=>'Laws and Rules',
        'Non-Compliance'=>'Non-Compliance',
        'Problem Behaviour'=>'Problem Behaviour',
        'Fair and Full Investigation'=>'Fair and Full Investigation',
        'Alternatives to Discipline'=>'Alternatives to Discipline',
        'Disciplinary Policy and Procedure'=>'Disciplinary Policy and Procedure',
        'The Difficult Conversation'=>'The Difficult Conversation',
        'The Disciplinary Hearing'=>'The Disciplinary Hearing',
        'Fair Dismissal'=>'Fair Dismissal',
        'What is Personality?'=>'What is Personality?',
        'The Enneagram'=>'The Enneagram',
        'The Need to be Perfect'=>'The Need to be Perfect',
        'The Need to be Needed'=>'The Need to be Needed',
        'The Need to Succeed'=>'The Need to Succeed',
        'The Need to be Special'=>'The Need to be Special',
        'The Need to Perceive'=>'The Need to Perceive',
        'The Need to be Safe'=>'The Need to be Safe',
        'The Need to be Happy'=>'The Need to be Happy',
        'The Need to be Strong'=>'The Need to be Strong',
        'The Need to be at Peace'=>'The Need to be at Peace',
        'Managing Personality Types'=>'Managing Personality Types',
        'What is Facilitation?' =>'What is Facilitation?',
        'People and Groups'=>'People and Groups',
        'Group Formation'=>'Group Formation',
        'Group Leadership'=>'Group Leadership', 
        'Empowering the Group'=>'Empowering the Group',
        'The Facilitators Toolkit'=>'The Facilitators Toolkit',
        'Group Dynamics'=>'Group Dynamics',
        'The Art of Non-Doing'=>'The Art of Non-Doing',
        'The Expert Facilitator'=>'The Expert Facilitator',
        'Endings and Separations'=>'Endings and Separations',
        'Influencing Skills'=>'Influencing Skills',
        'Negotiating skills'=>'Negotiating skills',
        'Preparing for Negotiations'=>'Preparing for Negotiations',
        'A Negotiation Game Plan'=>'A Negotiation Game Plan',
        'Power and Negotiations'=>'Power and Negotiations',
        'The Options in Conflict'=>'The Options in Conflict',
        'Making Your Case in Negotiations'=>'Making Your Case in Negotiations',
        'Stick to Your Guns in Negotiations'=>'Stick to Your Guns in Negotiations',
        'A Successful Negotiation'=>'A Successful Negotiation',
        'Agreement and After'=>'Agreement and After',
        'Management and Leadership'=>'Management and Leadership',
        'The Making of Leaders'=>'The Making of Leaders',
        'Leadership Types'=>'Leadership Types',
        'Mission, Vision, and Values'=>'Mission, Vision, and Values',
        'Organisational Culture'=>'Organisational Culture',
        'Leadership Style'=>'Leadership Style',
        'Master Communicators'=>'Master Communicators',
        'People Builders'=>'People Builders',
        'The Credibility of Leaders'=>'The Credibility of Leaders',
        'Leaders of the Future'=>'Leaders of the Future',
        'The Nature of Potential'=>'The Nature of Potential',       
        'Self-Development'=>'Self-Development',
        'Know Yourself'=>'Know Yourself',
        'Goals and Goal-Setting'=>'Goals and Goal-Setting',
        'Programming your Goals'=>'Programming your Goals',
        'Super-Energy'=>'Super-Energy',
        'Action and Progress'=>'Action and Progress',
        'The 3lb Universe'=>'The 3lb Universe',
        'Positivity'=>'Positivity',
        'From Mastery to Mystery'=>'From Mastery to Mystery',
        'SUCCEED in Presentations'=>'SUCCEED in Presentations',
        'A Business Audience'=>'A Business Audience',
        'The Structure of Presentations'=>'The Structure of Presentations',
        'Preparing the Presentation'=>'Preparing the Presentation',
        'Presentation Techniques'=>'Presentation Techniques',
        'Using Your Voice'=>'Using Your Voice',
        'Visual Aids'=>'Visual Aids',
        'Body Language in Presentations'=>'Body Language in Presentations',
        'Overcoming Your Speaking Nerves'=>'Overcoming Your Speaking Nerves',
        'Mastering the Delivery'=>'Mastering the Delivery',
        'Approaches to Recruitment'=>'Approaches to Recruitment',
        'Being Fair'=>'Being Fair',
        'Recruitment Policy and Procedure'=>'Recruitment Policy and Procedure',
        'Groundwork for Hiring'=>'Groundwork for Hiring',
        'Filling the Vacancy'=>'Filling the Vacancy',
        'The Selection Interview'=>'The Selection Interview',
        'Selection Interview Skills'=>'Selection Interview Skills',
        'Go and No Go Questions' =>'Go and No Go Questions',
        'Tests and Assessments'=>'Tests and Assessments',
        'Selection and Appointment'=>'Selection and Appointment',
        'The Nature of Stress'=>'The Nature of Stress',
        'Stressors'=>'Stressors',
        'Coping with Stress'=>'Coping with Stress',
        'Stress and the Physical Response'=>'Stress and the Physical Response',
        'Stress Solutions'=>'Stress Solutions',
        'Managing Perceptions'=>'Managing Perceptions',
        'Managing Emotions'=>'Managing Emotions',
        'Putting Things Into Perspective'=>'Putting Things Into Perspective', 
        'Focused Relaxation'=>'Focused Relaxation',
        'Stress-Busters'=>'Stress-Busters',
        'What Is Appraisal?'=>'What Is Appraisal?',
        'Appraisal Schemes'=>'Appraisal Schemes',
        'Assessment'=>'Assessment',
        'The Appraisal Interview'=>'The Appraisal Interview',
        'Managing the Under-Performer'=>'Managing the Under-Performer',
        'The Plateaued Performer'=>'The Plateaued Performer',
        'Managing the High Flyer'=>'Managing the High Flyer',
        'Constructive Feedback' =>'Constructive Feedback',
        'Play to their Strengths'=>'Play to their Strengths',
        'Outcomes of Appraisal'=>'Outcomes of Appraisal',
        'The Nature of Teams'=>'The Nature of Teams',
        'Team Development'=>'Team Development',
        'Teamwork'=>'Teamwork',
        'Team Cohesion'=>'Team Cohesion',
         'Threats to Teamwork'=>'Threats to Teamwork',
         'Team Leadership'=>'Team Leadership',
         'Team Roles'=>'Team Roles',
         'Team Meetings'=>'Team Meetings',
         'Building and Bonding'=>'Building and Bonding',
         'Teambuilders'=>'Teambuilders',
         'What are Thinking Skills?'=>'What are Thinking Skills?',
         'The Thoughts In Your Head'=>'The Thoughts In Your Head',
         '3D Thinking'=>'3D Thinking',
         'Blocks to Thinking'=>'Blocks to Thinking',
         'Reasoned Thinking'=>'Reasoned Thinking',
         'Creative Thinking'=>'Creative Thinking',
         'Group Thinking'=>'Group Thinking',
        'Decision-Taking'=>'Decision-Taking',
        'Problem-Solving'=>'Problem-Solving',
        'Innovation'=>'Innovation',
        'The Paradoxes of Time'=>'The Paradoxes of Time',
        'Working Time'=>'Working Time',
        'Models of Time Management'=>'Models of Time Management',
        'Routine Time'=>'Routine Time',
        'Time on Progress Work'=>'Time on Progress Work',
        'Time and Projects'=>'Time and Projects',
        'Non-Doing Work'=>'Non-Doing Work',
        'Time and Others'=>'Time and Others',
        'Time Travellers'=>'Time Travellers',
        'The Effective Time Manager'=>'The Effective Time Manager',
        'The Need for Training'=>'The Need for Training',
        'Managing Training'=>'Managing Training',
        'Models of Learning'=>'Models of Learning',
        'Designing Training'=>'Designing Training',
        'Running a Course'=>'Running a Course',
         'The Process of Training'=>'The Process of Training',
        'Groupwork and Training'=>'Groupwork and Training',
        'Learning Styles'=>'Learning Styles',
        'The Resourceful Trainer'=>'The Resourceful Trainer',
        'Evaluating Training'=>'Evaluating Training'
        

       ); 
       $question_topic_fill_in_the_blank = array(
        'What is Assertiveness?'=>'What is Assertiveness?',
        'The Origins of Assertiveness'=>'The Origins of Assertiveness',
        'Facets of Assertiveness'=>'Facets of Assertiveness',
        'Applications of Assertiveness'=>'Applications of Assertiveness',
        'Techniques of Assertiveness'=>'Techniques of Assertiveness',
        'Managing Assertively'=>'Managing Assertively',
        'Social Assertiveness'=>'Social Assertiveness',
        'Assertive Roles at Work'=>'Assertive Roles at Work',
        'Managing Your Boss Assertively'=>'Managing Your Boss Assertively',
        'Assertiveness Training'=>'Assertiveness Training',
        'What is Change Management?'=>'What is Change Management?',
        'Responding to Change'=>'Responding to Change',
        'Managing the Change Cycle'=>'Managing the Change Cycle',
        'Cores and Peripheries'=>'Cores and Peripheries',
        'Managing Paradox'=>'Managing Paradox',
        'Managing Risk in Times of Change'=>'Managing Risk in Times of Change',
        'Managing Learning in Times of Change'=>'Managing Learning in Times of Change',
        'The Process of Change'=>'The Process of Change',
        'Managing Uncertainty'=>'Managing Uncertainty',
        'Organisational Change'=>'Organisational Change',
        'Communications'=>'Communications',
        'Communication Strategies'=>'Communication Strategies',
        'Communication Networks'=>'Communication Networks',
        'The Means of Communication'=>'The Means of Communication',
        'Communication Barriers'=>'Communication Barriers',
        'Communication Styles'=>'Communication Styles',
        'The ABC of Writing'=>'The ABC of Writing',
        'The Art of Conversation'=>'The Art of Conversation',
        'Interpersonal Skills'=>'Interpersonal Skills',
        'Non-Verbal Communication'=>'Non-Verbal Communication',
        'The Counselling Approach'=>'The Counselling Approach',
        'Awareness, Acceptance, and Change'=>'Awareness, Acceptance, and Change',
        'Personal Growth'=>'Personal Growth',
        'The Dispositions of Counselling'=>'The Dispositions of Counselling',
        'The Counselling Interview'=>'The Counselling Interview',
        'The Art of Listening'=>'The Art of Listening',
        'Asking Questions'=>'Asking Questions',
        'Challenging and Closing Down'=>'Challenging and Closing Down',
        'Moving On'=>'Moving On',
        'People Problems'=>'People Problems',
        'What is Customer Care?'=>'What is Customer Care?',
        'Ichiban to Kaizen'=>'Ichiban to Kaizen',
        'Customer Focus'=>'Customer Focus',
        'The Customer Promise'=>'The Customer Promise',
        'Customer Champions'=>'Customer Champions',
        'Customer Feedback'=>'Customer Feedback',
        'Moments of Truth'=>'Moments of Truth',
        'Customer Relations'=>'Customer Relations',
        'Customer Complaints'=>'Customer Complaints',
        'Service Style'=>'Service Style',
        'From Directing to Delegating'=>'From Directing to Delegating',
        'Models of Management'=>'Models of Management',
        'Types of Delegating'=>'Types of Delegating',
        'Delegate to Develop'=>'Delegate to Develop',
        'Delegating as a Manager'=>'Delegating as a Manager',
        'Power and Empowerment'=>'Power and Empowerment',
        'Empowered Organisations'=>'Empowered Organisations',
        'Empowered Leaders'=>'Empowered Leaders',
        'DIY Empowerment'=>'DIY Empowerment',
        'The 21st Century Manager'=>'The 21st Century Manager',
        'Routes to Discipline'=>'Routes to Discipline',
        'Laws and Rules'=>'Laws and Rules',
        'Non-Compliance'=>'Non-Compliance',
        'Problem Behaviour'=>'Problem Behaviour',
        'Fair and Full Investigation'=>'Fair and Full Investigation',
        'Alternatives to Discipline'=>'Alternatives to Discipline',
        'Disciplinary Policy and Procedure'=>'Disciplinary Policy and Procedure',
        'Counselling and Discipline'=>'Counselling and Discipline',
        'The Disciplinary Hearing'=>'The Disciplinary Hearing',
        'Fair Dismissal'=>'Fair Dismissal',
        'What is Personality?'=>'What is Personality?',
        'The Enneagram'=>'The Enneagram',
        'Ones, the Need to be Perfect'=>'Ones, the Need to be Perfect',
        'Twos, the Need to be Needed'=>'Twos, the Need to be Needed',
        'Threes, the Need to Succeed'=>'Threes, the Need to Succeed',
        'Fours, the Need to be Special'=>'Fours, the Need to be Special',
        'Fives, the Need to Perceive'=>'Fives, the Need to Perceive',
        'Sixes, the Need to be Safe'=>'Sixes, the Need to be Safe',
        'Sevens, the Need to be Happy'=>'Sevens, the Need to be Happy',
        'Eights, the Need to be Strong'=>'Eights, the Need to be Strong',
        'Nines, the Need to be at Peace'=>'Nines, the Need to be at Peace',
        'Managing Personality Types'=>'Managing Personality Types',
        'What is Facilitation?'=>'What is Facilitation?',
        'People and Groups'=>'People and Groups',
        'Facilitating the Start of Groupwork'=>'Facilitating the Start of Groupwork',
        'Control and Power in Facilitation'=>'Control and Power in Facilitation',
        'Empowering the Group'=>'Empowering the Group',
        'The Facilitators Toolkit'=>'The Facilitators Toolkit',
        'Overcoming the Blocks to Growth'=>'Overcoming the Blocks to Growth',
        'The Art of Non-Doing'=>'The Art of Non-Doing',
        'Group Energy'=>'Group Energy',
        'Endings and Separations'=>'Endings and Separations',
        'Influencing Skills'=>'Influencing Skills',
        'Negotiating Skills'=>'Negotiating Skills',
        'Preparing for Negotiations'=>'Preparing for Negotiations',
        'A Negotiation Game Plan'=>'A Negotiation Game Plan',
        'Power and Negotiations'=>'Power and Negotiations',
        'The Options in Conflict'=>'The Options in Conflict',
        'Making Your Case in Negotiations'=>'Making Your Case in Negotiations',
        'Stick to Your Guns in Negotiations'=>'Stick to Your Guns in Negotiations',
        'A Successful Negotiation'=>'A Successful Negotiation',
        'Agreement and After'=>'Agreement and After',
        'Management and Leadership'=>'Management and Leadership',
        'The Making of Leaders'=>'The Making of Leaders',
        'Leaders and Their Personalities'=>'Leaders and Their Personalities',
        'Mission, Vision, and Values'=>'Mission, Vision, and Values',
        'Organisational Culture'=>'Organisational Culture',
        'Leadership Style'=>'Leadership Style',
        'Master Communicators'=>'Master Communicators',
        'People Builders'=>'People Builders',
        'The Credibility of Leaders'=>'The Credibility of Leaders',
        'Leaders of the Future'=>'Leaders of the Future',
        'The Nature of Potential'=>'The Nature of Potential',
        'Self-Development'=>'Self-Development',
        'Know Yourself'=>'Know Yourself',
        'Goals and Goal-Setting'=>'Goals and Goal-Setting',
        'Programming your Goals'=>'Programming your Goals',
        'Super-Energy'=>'Super-Energy',
        'Action and Progress'=>'Action and Progress',
        'The 3lb Universe'=>'The 3lb Universe',
        'Positivity'=>'Positivity',
        'From Mastery to Mystery'=>'From Mastery to Mystery',
        'What Is Appraisal?'=>'What Is Appraisal?',
        'Appraisal Schemes'=>'Appraisal Schemes',
        'Assessment'=>'Assessment',
        'The Appraisal Interview'=>'The Appraisal Interview',
        'Managing the Under-Performer'=>'Managing the Under-Performer',
        'The Plateau-ed Performer'=>'The Plateau-ed Performer',
        'Managing the High Flyer'=>'Managing the High Flyer',
        'Constructive Feedback'=>'Constructive Feedback',
        'Play to their Strengths'=>'Play to their Strengths',
        'Outcomes of Appraisal'=>'Outcomes of Appraisal',
        'SUCCEED in Presentations'=>'SUCCEED in Presentations',
        'A Business Audience'=>'A Business Audience',
        'The Structure of Presentations'=>'The Structure of Presentations',
        'Preparing the Presentation'=>'Preparing the Presentation',
        'Presentation Techniques'=>'Presentation Techniques',
        'Using Your Voice'=>'Using Your Voice',
        'Visual Aids'=>'Visual Aids',
        'Body Language in Presentations'=>'Body Language in Presentations',
        'Overcoming Your Speaking Nerves'=>'Overcoming Your Speaking Nerves',
        'Mastering the Delivery'=>'Mastering the Delivery',
        'Approaches to Recruitment'=>'Approaches to Recruitment',
        'Being Fair'=>'Being Fair',
        'Recruitment Policy and Procedure'=>'Recruitment Policy and Procedure',
        'Groundwork for Hiring'=>'Groundwork for Hiring',
        'Filling the Vacancy'=>'Filling the Vacancy',
        'The Selection Interview'=>'The Selection Interview',
        'Selection Interview Skills'=>'Selection Interview Skills',
        'Go and No Go Questions'=>'Go and No Go Questions',
        'Tests and Assessments'=>'Tests and Assessments',
        'Selection and Appointment'=>'Selection and Appointment',
        'The Nature of Stress'=>'The Nature of Stress',
    
        'Stressors'=>'Stressors',
        'Coping with Stress'=>'Coping with Stress',
        'Stress and the Physical Response'=>'Stress and the Physical Response',
        'Stress Solutions'=>'Stress Solutions',
        'Managing Perceptions'=>'Managing Perceptions',
        'Managing Emotions'=>'Managing Emotions',
        'Putting Things into Perspective'=>'Putting Things into Perspective',
        'Focused Relaxation'=>'Focused Relaxation',
        'Stress-Busters'=>'Stress-Busters',
        'The Nature of Teams'=>'The Nature of Teams',
        'Team Development'=>'Team Development',
        'Teamwork'=>'Teamwork',
        'Team Cohesion'=>'Team Cohesion',
        'Threats to Teamwork'=>'Threats to Teamwork',
        'Team Leadership'=>'Team Leadership',
        'Team Roles'=>'Team Roles',
        'Team Meetings'=>'Team Meetings',
        'Unshared Certainty to Shared Uncertainty'=>'Unshared Certainty to Shared Uncertainty',
        'Teambuilders'=>'Teambuilders',
        'What are Thinking Skills?'=>'What are Thinking Skills?',
        'The Thoughts In Your Head'=>'The Thoughts In Your Head',
        'Memory, Concentration, and Imagination'=>'Memory, Concentration, and Imagination',
        'Blocks to Thinking'=>'Blocks to Thinking',
        'Reasoned Thinking'=>'Reasoned Thinking',
        'Creative Thinking'=>'Creative Thinking',
        'Brainstorming'=>'Brainstorming',
        'Decision-Taking'=>'Decision-Taking',
        'Problem-Solving'=>'Problem-Solving',
        'Innovation'=>'Innovation',
        'The Paradoxes of Time'=>'The Paradoxes of Time',
        'Working Time'=>'Working Time',
        'Models of Time Management'=>'Models of Time Management',
        'Routine Time'=>'Routine Time',
        'Time on Progress Work'=>'Time on Progress Work',
        'Time and Projects'=>'Time and Projects',
        'Non-Doing Work'=>'Non-Doing Work',
        'Time and Others'=>'Time and Others',
        'Time Travellers'=>'Time Travellers',
        'The Effective Time Manager'=>'The Effective Time Manager',
        'The Need for Training'=>'The Need for Training',
        'Managing Training'=>'Managing Training',
        'Models of Learning'=>'Models of Learning',
        'Designing Training'=>'Designing Training',
        'Running a Course'=>'Running a Course',
        'The Process of Training'=>'The Process of Training',
        'Groupwork and Training'=>'Groupwork and Training',
        'Learning Styles'=>'Learning Styles',
        'The Resourceful Trainer'=>'The Resourceful Trainer',
        'Evaluating Training'=>'Evaluating Training',
        'Assertiveness'=>'Assertiveness',
        'Change Management'=>'Change Management',
        'Communications'=>'Communications',
        'Counselling Skills'=>'Counselling Skills',
        'Customer Care'=>'Customer Care',
        'Delegation and Empowerment'=>'Delegation and Empowerment',
        'Effective Discipline'=>'Effective Discipline',
        'Enneagram Personality Types'=>'Enneagram Personality Types',
        'Facilitation Skills'=>'Facilitation Skills',
        'Influencing and Negotiating Skills'=>'Influencing and Negotiating Skills',
        'Leadership Skills'=>'Leadership Skills',
        'Maximising Your Potential'=>'Maximising Your Potential',
        'Performance Management and Appraisal'=>'Performance Management and Appraisal',
        'Presentation Skills'=>'Presentation Skills',
        'Recruitment and Selection'=>'Recruitment and Selection',
        'Stress Management'=>'Stress Management',
        'Teambuilding'=>'Teambuilding',
        'Thinking Skills'=>'Thinking Skills',
        'Time Management'=>'Time Management',
        'Training Skills'=>'Training Skills',
               );

        $number_question_topic = array(
            'Assertiveness'=>'Assertiveness',
            'Change Management'=>'Change Management',
            'Communications'=>'Communications',
            'Counselling Skills'=>'Counselling Skills',
            'Customer Care'=>'Customer Care',
            'Delegation and Empowerment'=>'Delegation and Empowerment',
            'Effective Discipline'=>'Effective Discipline',
            'Enneagram Personality Types'=>'Enneagram Personality Types',
            'Facilitation Skills'=>'Facilitation Skills',
            'Influencing and Negotiating Skills'=>'Influencing and Negotiating Skills',
            'Leadership Skills'=>'Leadership Skills',
            'Maximising Your Potential'=>'Maximising Your Potential',
            'Performance Management and Appraisal'=>'Performance Management and Appraisal',
            'Presentation Skills'=>'Presentation Skills',
            'Recruitment and Selection'=>'Recruitment and Selection',
            'Stress Management'=>'Stress Management',
            'Teambuilding'=>'Teambuilding',
            'Thinking Skills'=>'Thinking Skills',
            'Time Management'=>'Time Management',
            'Training Skills'=>'Training Skills',
        );  
        $question_topic_true_and_false = array(
            'What is Assertiveness?'=>'What is Assertiveness?',
            'The Origins of Assertiveness'=>'The Origins of Assertiveness',
            'Facets of Assertiveness'=>'Facets of Assertiveness',
            'Applications of Assertiveness'=>'Applications of Assertiveness',
            'Techniques of Assertiveness'=>'Techniques of Assertiveness',
            'Managing Assertively'=>'Managing Assertively',
            'Social Assertiveness'=>'Social Assertiveness',
            'Assertive Roles at Work'=>'Assertive Roles at Work',
            'Managing Your Boss Assertively'=>'Managing Your Boss Assertively',
            'Assertiveness Training'=>'Assertiveness Training',
            'What is Change Management?'=>'What is Change Management?',
            'Responding to Change'=>'Responding to Change',
            'Managing the Change Cycle'=>'Managing the Change Cycle',
            'Cores and Peripheries'=>'Cores and Peripheries',
            'Managing Paradox'=>'Managing Paradox',
            'Managing Risk in Times of Change'=>'Managing Risk in Times of Change',
            'Managing Learning in Times of Change'=>'Managing Learning in Times of Change',
            'The Process of Change'=>'The Process of Change',
            'Managing Uncertainty'=>'Managing Uncertainty',
            'Organisational Change'=>'Organisational Change',
            'Communications'=>'Communications',
            'Communication Strategies'=>'Communication Strategies',
            'Communication Networks'=>'Communication Networks',
            'The Means of Communication'=>'The Means of Communication',
            'Communication Barriers'=>'Communication Barriers',
            'Communication Styles'=>'Communication Styles',
            'The ABC of Writing'=>'The ABC of Writing',
            'The Art of Conversation'=>'The Art of Conversation',
            'Interpersonal Skills'=>'Interpersonal Skills',
            'Non-Verbal Communication'=>'Non-Verbal Communication',
            'The Counselling Approach'=>'The Counselling Approach',
            'Awareness, Acceptance, and Change'=>'Awareness, Acceptance, and Change',
            'Personal Growth'=>'Personal Growth',
            'The Dispositions of Counselling'=>'The Dispositions of Counselling',
            'The Counselling Interview'=>'The Counselling Interview',
            'The Art of Listening'=>'The Art of Listening',
            'Asking Questions'=>'Asking Questions',
            'Challenging and Closing Down'=>'Challenging and Closing Down',
            'Moving On'=>'Moving On',
            'People Problems'=>'People Problems',
            'What is Customer Care?'=>'What is Customer Care?',
            'Ichiban to Kaizen'=>'Ichiban to Kaizen',
            'Customer Focus'=>'Customer Focus',
            'The Customer Promise'=>'The Customer Promise',
            'Customer Champions'=>'Customer Champions',
            'Customer Feedback'=>'Customer Feedback',
            'Moments of Truth'=>'Moments of Truth',
            'Customer Relations'=>'Customer Relations',
            'Customer Complaints'=>'Customer Complaints',
            'Service Style'=>'Service Style',
            'From Directing to Delegating'=>'From Directing to Delegating',
            'Models of Management'=>'Models of Management',
            'Types of Delegating'=>'Types of Delegating',
            'Delegate to Develop'=>'Delegate to Develop',
            'Delegating as a Manager'=>'Delegating as a Manager',
            'Power and Empowerment'=>'Power and Empowerment',
            'Empowered Organisations'=>'Empowered Organisations',
            'Empowered Leaders'=>'Empowered Leaders',
            'DIY Empowerment'=>'DIY Empowerment',
            'The 21st Century Manager'=>'The 21st Century Manager',
            'Routes to Discipline'=>'Routes to Discipline',
            'Laws and Rules'=>'Laws and Rules',
            'Non-Compliance'=>'Non-Compliance',
            'Problem Behaviour'=>'Problem Behaviour',
            'Fair and Full Investigation'=>'Fair and Full Investigation',
            'Alternatives to Discipline'=>'Alternatives to Discipline',
            'Disciplinary Policy and Procedure'=>'Disciplinary Policy and Procedure',
            'Counselling and Discipline'=>'Counselling and Discipline',
            'The Disciplinary Hearing'=>'The Disciplinary Hearing',
            'Fair Dismissal'=>'Fair Dismissal',
            'What is Personality?'=>'What is Personality?',
            'The Enneagram'=>'The Enneagram',
            'Ones, the Need to be Perfect'=>'Ones, the Need to be Perfect',
            'Twos, the Need to be Needed'=>'Twos, the Need to be Needed',
            'Threes, the Need to Succeed'=>'Threes, the Need to Succeed',
            'Fours, the Need to be Special'=>'Fours, the Need to be Special',
            'Fives, the Need to Perceive'=>'Fives, the Need to Perceive',
            'Sixes, the Need to be Safe'=>'Sixes, the Need to be Safe',
            'Sevens, the Need to be Happy'=>'Sevens, the Need to be Happy',
            'Eights, the Need to be Strong'=>'Eights, the Need to be Strong',
            'Nines, the Need to be at Peace'=>'Nines, the Need to be at Peace',
            'Managing Personality Types'=>'Managing Personality Types',
            'What is Facilitation?'=>'What is Facilitation?',
            'People and Groups'=>'People and Groups',
            'Facilitating the Start of Groupwork'=>'Facilitating the Start of Groupwork',
            'Control and Power in Facilitation'=>'Control and Power in Facilitation',
            'Empowering the Group'=>'Empowering the Group',
            'The Facilitators Toolkit'=>'The Facilitators Toolkit',
            'Overcoming the Blocks to Growth'=>'Overcoming the Blocks to Growth',
            'The Art of Non-Doing'=>'The Art of Non-Doing',
            'Group Energy'=>'Group Energy',
            'Endings and Separations'=>'Endings and Separations',
            'Influencing Skills'=>'Influencing Skills',
            'Negotiating Skills'=>'Negotiating Skills',
            'Preparing for Negotiations'=>'Preparing for Negotiations',
            'A Negotiation Game Plan'=>'A Negotiation Game Plan',
            'Power and Negotiations'=>'Power and Negotiations',
            'The Options in Conflict'=>'The Options in Conflict',
            'Making Your Case in Negotiations'=>'Making Your Case in Negotiations',
            'Stick to Your Guns in Negotiations'=>'Stick to Your Guns in Negotiations',
            'A Successful Negotiation'=>'A Successful Negotiation',
            'Agreement and After'=>'Agreement and After',
            'Management and Leadership'=>'Management and Leadership',
            'The Making of Leaders'=>'The Making of Leaders',
            'Leaders and Their Personalities'=>'Leaders and Their Personalities',
            'Mission, Vision, and Values'=>'Mission, Vision, and Values',
            'Organisational Culture'=>'Organisational Culture',
            'Leadership Style'=>'Leadership Style',
            'Master Communicators'=>'Master Communicators',
            'People Builders'=>'People Builders',
            'The Credibility of Leaders'=>'The Credibility of Leaders',
            'Leaders of the Future'=>'Leaders of the Future',
            'The Nature of Potential'=>'The Nature of Potential',
            'Self-Development'=>'Self-Development',
            'Know Yourself'=>'Know Yourself',
            'Goals and Goal-Setting'=>'Goals and Goal-Setting',
            'Programming your Goals'=>'Programming your Goals',
            'Super-Energy'=>'Super-Energy',
            'Action and Progress'=>'Action and Progress',
            'The 3lb Universe'=>'The 3lb Universe',
            'Positivity'=>'Positivity',
            'From Mastery to Mystery'=>'From Mastery to Mystery',
            'What Is Appraisal?'=>'What Is Appraisal?',
            'Appraisal Schemes'=>'Appraisal Schemes',
            'Assessment'=>'Assessment',
            'The Appraisal Interview'=>'The Appraisal Interview',
            'Managing the Under-Performer'=>'Managing the Under-Performer',
            'The Plateau-ed Performer'=>'The Plateau-ed Performer',
            'Managing the High Flyer'=>'Managing the High Flyer',
            'Constructive Feedback'=>'Constructive Feedback',
            'Play to their Strengths'=>'Play to their Strengths',
            'Outcomes of Appraisal'=>'Outcomes of Appraisal',
            'SUCCEED in Presentations'=>'SUCCEED in Presentations',
            'A Business Audience'=>'A Business Audience',
            'The Structure of Presentations'=>'The Structure of Presentations',
            'Preparing the Presentation'=>'Preparing the Presentation',
            'Presentation Techniques'=>'Presentation Techniques',
            'Using Your Voice'=>'Using Your Voice',
            'Visual Aids'=>'Visual Aids',
            'Body Language in Presentations'=>'Body Language in Presentations',
            'Overcoming Your Speaking Nerves'=>'Overcoming Your Speaking Nerves',
            'Mastering the Delivery'=>'Mastering the Delivery',
            'Approaches to Recruitment'=>'Approaches to Recruitment',
            'Being Fair'=>'Being Fair',
            'Recruitment Policy and Procedure'=>'Recruitment Policy and Procedure',
            'Groundwork for Hiring'=>'Groundwork for Hiring',
            'Filling the Vacancy'=>'Filling the Vacancy',
            'The Selection Interview'=>'The Selection Interview',
            'Selection Interview Skills'=>'Selection Interview Skills',
            'Go and No Go Questions'=>'Go and No Go Questions',
            'Tests and Assessments'=>'Tests and Assessments',
            'Selection and Appointment'=>'Selection and Appointment',
            'The Nature of Stress'=>'The Nature of Stress',
            'Stressors'=>'Stressors',
            'Coping with Stress'=>'Coping with Stress',
            'Stress and the Physical Response'=>'Stress and the Physical Response',
            'Stress Solutions'=>'Stress Solutions',
            'Managing Perceptions'=>'Managing Perceptions',
            'Managing Emotions'=>'Managing Emotions',
            'Putting Things into Perspective'=>'Putting Things into Perspective',
            'Focused Relaxation'=>'Focused Relaxation',
            'Stress-Busters'=>'Stress-Busters',
            'The Nature of Teams'=>'The Nature of Teams',
            'Team Development'=>'Team Development',
            'Teamwork'=>'Teamwork',
            'Team Cohesion'=>'Team Cohesion',
            'Threats to Teamwork'=>'Threats to Teamwork',
            'Team Leadership'=>'Team Leadership',
            'Team Roles'=>'Team Roles',
            'Team Meetings'=>'Team Meetings',
            'Unshared Certainty to Shared Uncertainty'=>'Unshared Certainty to Shared Uncertainty',
            'Teambuilders'=>'Teambuilders',
            'What are Thinking Skills?'=>'What are Thinking Skills?',
            'The Thoughts In Your Head'=>'The Thoughts In Your Head',
            'Memory, Concentration, and Imagination'=>'Memory, Concentration, and Imagination',
            'Blocks to Thinking'=>'Blocks to Thinking',
            'Reasoned Thinking'=>'Reasoned Thinking',
            'Creative Thinking'=>'Creative Thinking',
            'Brainstorming'=>'Brainstorming',
            'Decision-Taking'=>'Decision-Taking',
            'Problem-Solving'=>'Problem-Solving',
            'Innovation'=>'Innovation',
            'The Paradoxes of Time'=>'The Paradoxes of Time',
            'Working Time'=>'Working Time',
            'Models of Time Management'=>'Models of Time Management',
            'Routine Time'=>'Routine Time',
            'Time on Progress Work'=>'Time on Progress Work',
            'Time and Projects'=>'Time and Projects',
            'Non-Doing Work'=>'Non-Doing Work',
            'Time and Others'=>'Time and Others',
            'Time Travellers'=>'Time Travellers',
            'The Effective Time Manager'=>'The Effective Time Manager',
            'The Need for Training'=>'The Need for Training',
            'Managing Training'=>'Managing Training',
            'Models of Learning'=>'Models of Learning',
            'Designing Training'=>'Designing Training',
            'Running a Course'=>'Running a Course',
            'The Process of Training'=>'The Process of Training',
            'Groupwork and Training'=>'Groupwork and Training',
            'Learning Styles'=>'Learning Styles',
            'The Resourceful Trainer'=>'The Resourceful Trainer',
            'Evaluating Training'=>'Evaluating Training',
            'Assertiveness'=>'Assertiveness',
            'Change Management'=>'Change Management',
            'Communications'=>'Communications',
            'Counselling Skills'=>'Counselling Skills',
            'Customer Care'=>'Customer Care',
            'Delegation and Empowerment'=>'Delegation and Empowerment',
            'Effective Discipline'=>'Effective Discipline',
            'Enneagram Personality Types'=>'Enneagram Personality Types',
            'Facilitation Skills'=>'Facilitation Skills',
            'Influencing and Negotiating Skills'=>'Influencing and Negotiating Skills',
            'Leadership Skills'=>'Leadership Skills',
            'Maximising Your Potential'=>'Maximising Your Potential',
            'Performance Management and Appraisal'=>'Performance Management and Appraisal',
            'Presentation Skills'=>'Presentation Skills',
            'Recruitment and Selection'=>'Recruitment and Selection',
            'Stress Management'=>'Stress Management',
            'Teambuilding'=>'Teambuilding',
            'Thinking Skills'=>'Thinking Skills',
            'Time Management'=>'Time Management',
            'Training Skills'=>'Training Skills',
                   );                      
                   $question_topic_either_or =  array (
                    'Performance Management and Appraisal' => 'Performance Management and Appraisal',
                    'Assertivenes' => 'Assertiveness',
                    'Change Management' => 'Change Management',
                    'Meeting Skills' => 'Meeting Skills',
                    'Asking Questions' => 'Asking Questions',
                    'Customer Complaints' => 'Customer Complaints',
                    'Customer Service' => 'Customer Service',
                    'Empowered Organisations'=> 'Empowered Organisations',
                    'Effective Discipline' => 'Effective Discipline',
                    'Enneagram Personality Types' => 'Enneagram Personality Types',
                    'Facilitation Skills' => 'Facilitation Skills',
                    'Influencing and Negotiating Skills' => 'Influencing and Negotiating Skills',
                    'Leadership Skills' => 'Leadership Skills',
                    'Know Yourself' => 'Know Yourself',
                    'Presentation Skills' => 'Presentation Skills',
                    'The Person Specification' => 'The Person Specification',
                    'Recruitment and Selection' => 'Recruitment and Selection',
                    'Recruitment Policy and Procedure' => 'Recruitment Policy and Procedure',
                    'Stress Management' => 'Stress Management',
                    'Teambuilding' => 'Teambuilding',
                    'Thinking Skills' => 'Thinking Skills',
                    'Time Management' => 'Time Management',
                    'Training Skills'=> 'Training Skills',
        );    
        $question_topic_six_of_best = array (
            'Appraisal Schemes' => 'Appraisal Schemes',
             'The Appraisal Interview' => 'The Appraisal Interview',
             'Constructive Feedback'=> 'Constructive Feedback',
             'Outcomes of Appraisal' => 'Outcomes of Appraisal',
             'The Assertive Manager' => 'The Assertive Manager',
            'What is Change Management?' => 'What is Change Management?',
             'Cores and Peripheries' => 'Cores and Peripheries',
             'Smart Reading' => 'Smart Reading',
             'The Counselling Approach' => 'The Counselling Approach',
             'The Counselling Interview'=> 'The Counselling Interview',
            'The Art of Listening' => 'The Art of Listening',
             'Moving on from Counselling' => 'Moving on from Counselling',
            'The Customer Promise' => 'The Customer Promise',
             'Empowered Organisations' => 'Empowered Organisations',
             'Delegating as a Manager' => 'Delegating as a Manager',
             'Organisational Structures' => 'Organisational Structures',
             'Empowered Organisations'=> 'Empowered Organisations',
            'Empowering Leaders' => 'Empowering Leaders',
             'Laws and Rules'=> 'Laws and Rules',
             'Fair and Full Investigation' => 'Fair and Full Investigation',
             'Alternatives to Discipline' => 'Alternatives to Discipline',
             'Disciplinary Policy and Procedure' => 'Disciplinary Policy and Procedure',
             'The Difficult Conversation'=> 'The Difficult Conversation',
             'The Disciplinary Hearing'=> 'The Disciplinary Hearing',
             'Managing Personality Types' => 'Managing Personality Types',
            'What is Facilitation?' => 'What is Facilitation?',
             'Empowering the Group' => 'Empowering the Group',
           'Control and Power in Facilitation'=> 'Control and Power in Facilitation',
             'Group Energy' => 'Group Energy',
             'Influencing Skills' => 'Influencing Skills',
            'Power and Negotiations'=> 'Power and Negotiations',
            'Management and Leadership' => 'Management and Leadership',
             'Mission, Vision, and Values' => 'Mission, Vision, and Values',
           'Organisational Culture' => 'Organisational Culture',
             'Leadership Styles' => 'Leadership Styles',
             'People Builders' => 'People Builders',
             'The Nature of Potential'=> 'The Nature of Potential',
             'From Mastery to Mystery' => 'From Mastery to Mystery',
            'Body Language in Presentations'=> 'Body Language in Presentations',
             'Selection Interview Skills' => 'Selection Interview Skills',
             'Putting Things into Perspective' => 'Putting Things into Perspective',
             'Focused Relaxation'=> 'Focused Relaxation',
             'Teamwork' => 'Teamwork',
            'The Nature of Teams' => 'The Nature of Teams',
             'Reasoned Thinking' => 'Reasoned Thinking',
            'Working Time' => 'Working Time',
             'Routine Time' => 'Routine Time',
             'Time on Progress Work' => 'Time on Progress Work',
            'Non-Doing Work' => 'Non-Doing Work',
             'Time and Others'=> 'Time and Others',
             'Designing Training' => 'Designing Training',
           );  
           $question_topic_sequence= array (
            'Conflict Resolution' => 'Conflict Resolution',
            'Alternative Conflict Resolution'=> 'Alternative Conflict Resolution',
           'The Kubler-Ross Model of Change' => 'The Kubler-Ross Model of Change',
           'Natural Change' => 'Natural Change',
           'Persuasion' => 'Persuasion',
           'The Communications Loop' => 'The Communications Loop',
           'An Interpersonal Exchange' => 'An Interpersonal Exchange',
            'A Counselling Session' => 'A Counselling Session',
            'Resolving a Customer Complaint' => 'Resolving a Customer Complaint',
           'Progressive Levels of Responsibility' => 'Progressive Levels of Responsibility',
            'Levels of Freedom' => 'Levels of Freedom',
            'What People Want from their Leaders' => 'What People Want from their Leaders',
            'Disciplinary Procedure' => 'Disciplinary Procedure',
            'Counselling' => 'Counselling',
           'Disciplinary Hearing' => 'Disciplinary Hearing',
             'The Business Cycle' => 'The Business Cycle',
            'Group Workshops' => 'Group Workshops',
           'Power Negotiations'=> 'Power Negotiations',
            'Transformational Leadership' => 'Transformational Leadership',
            'Stages of Change' => 'Stages of Change',
           'Leadership Skills' => 'Leadership Skills',
            'Goals and Goal-Setting' => 'Goals and Goal-Setting',
            'Constructive Feedback' => 'Constructive Feedback',
            'The Appraisal Interview' => 'The Appraisal Interview',
           'Logorrophobia' => 'Logorrophobia',
            'Top 10 Job Requirement Skills'=> 'Top 10 Job Requirement Skills',
           'The Recruitment Cycle' => 'The Recruitment Cycle',
            'Selection Techniques' => 'Selection Techniques',
            'Shortlisting' => 'Shortlisting',
            'Job Advertisement' => 'Job Advertisement',
            'Recruitment Interview'=> 'Recruitment Interview',
            'Stressful Life Events' => 'Stressful Life Events',
            'Team Meetings' => 'Team Meetings',
            'Team Meetings' => 'Team Meetings',
            'Building a Team' => 'Building a Team',
            'Tuckmans Team Development Model' => 'Tuckmans Team Development Model',
            'Stages of Team Dependence' => 'Stages of Team Dependence',
            'Visualisation' => 'Visualisation',
             'Classic Problem-Solving'=> 'Classic Problem-Solving',
            'Task Prioritisation' => 'Task Prioritisation',
           'The Project Life Cycle' => 'The Project Life Cycle',
           'The Conscious-Competence Ladder' => 'The Conscious-Competence Ladder',
           'Giving Instructions' => 'Giving Instructions',
            'Kolbs Experiential Learning Model'=> 'Kolbs Experiential Learning Model',
           'John Whitmore Coaching Model'=> 'John Whitmore Coaching Model',
           'GROW Coaching Model' => 'GROW Coaching Model',
           
          );    
          $question_topic_matching_item = array (
            'What is Appraisal?' => 'What is Appraisal?',
           'Assessment'=> 'Assessment',
           'Managing the Under-Performer' => 'Managing the Under-Performer',
            'Performance Management and Appraisal' => 'Performance Management and Appraisal',
           'The Plateau-ed Performer' => 'The Plateau-ed Performer',
            'Outcomes of Appraisal' => 'Outcomes of Appraisal',
            'Facets of Assertiveness' => 'Facets of Assertiveness',
             'Applications of Assertiveness' => 'Applications of Assertiveness',
            'Techniques of Assertiveness' => 'Techniques of Assertiveness',
            'The Assertive Manager'=> 'The Assertive Manager',
            'The Process of Change' => 'The Process of Change',
           'Organisational Change' => 'Organisational Change',
            'Communication Strategies' => 'Communication Strategies',
            'The Means of Communication' => 'The Means of Communication',
             'Communication Barriers' => 'Communication Barriers',
            'The Art of Conversation' => 'The Art of Conversation',
             'Interpersonal Skills' => 'Interpersonal Skills',
            'Non-Verbal Communication' => 'Non-Verbal Communication',
            'The Counselling Approach' => 'The Counselling Approach',
           'Awareness, Acceptance, and Change' => 'Awareness, Acceptance, and Change',
            'Personal Growth'=> 'Personal Growth',
             'The Counselling Interview' => 'The Counselling Interview',
            'The Art of Listening' => 'The Art of Listening',
            'Asking Questions' => 'Asking Questions',
           'People Problems'=> 'People Problems',
            'Customer Care' => 'Customer Care',
            'Delegation and Empowerment' => 'Delegation and Empowerment',
          'Effective Discipline'=> 'Effective Discipline',
           'Enneagram Personality Types'=> 'Enneagram Personality Types',
            'Facilitation Skills'=> 'Facilitation Skills',
          'Influencing and Negotiating Skills' => 'Influencing and Negotiating Skills',
           'Leadership Skills'=> 'Leadership Skills',
            'Maximising Your Potential'=> 'Maximising Your Potential',
            'Presentation Skills'=> 'Presentation Skills',
            'Recruitment and Selection' => 'Recruitment and Selection',
             'Stress Management' => 'Stress Management',
           'Teambuilding' => 'Teambuilding',
            'Thinking Skills' => 'Thinking Skills',
            'Time Management' => 'Time Management',
            'Training Skills' => 'Training Skills',
            'Performance Management and Appraisal'=> 'Performance Management and Appraisal',
            'Assertiveness' => 'Assertiveness',
            'Change Management' => 'Change Management',
            'Communications' => 'Communications',
            'Counselling Skills'=> 'Counselling Skills',
          );                            
        return view('backend.questions.create', compact('questiontype_array', 'option_array','questioncat_array','question_type','question_topics_multi_choice','question_topics_flash_card','question_topic_fill_in_the_blank','number_question_topic','question_topic_true_and_false','question_topic_either_or','question_topic_six_of_best','question_topic_sequence','question_topic_matching_item'));
    }
    /**
     * Load the specific form 
     *
     ** @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function loadForm(Request $request) {
        
        $question_type =  $request->route('id');
        $option_array = array();
        $questiontypes = Questiontype::pluck('type_title', 'id')->all();
        $questiontype_array[0] = 'Please Select';
        if (!empty($questiontypes)) {
            foreach ($questiontypes as $key => $value) {
                $questiontype_array[$key] = $value;
            }
        }

        $option_array = array(
            'optionOne' => 'Option A',
            'optionTwo' => 'Option B',
            'optionThree' => 'Option C',
            'optionFour' => 'Option D',
        );

        $questioncat_array  = array(
            'Assertiveness' => 'Assertiveness',
            'Change Management' => 'Change Management',
            'Communications' => 'Communications',
            'Counselling Skills' => 'Counselling Skills',
            'Customer Care' => 'Customer Care',
            'Delegation and Empowerment' => 'Delegation and Empowerment',
            'Effective Discipline' => 'Effective Discipline',
            'Enneagram PersonalityTypes' => 'Enneagram Personality Types',
            'Facilitation Skills' => 'Facilitation Skills',
            'Influencing and Negotiating Skills' => 'Influencing and Negotiating Skills',
            'Leadership Skills' => 'Leadership Skills',
            'Maximising Your Potential' => 'Maximising Your Potential',
            'Performance Management and Appraisal' => 'Performance Management and Appraisal',
            'Presentation Skills' => 'Presentation Skills',
            'Recruitment and Selection' => 'Recruitment and Selection',
            'Stress Management' => 'Stress Management',
            'Teambuilding' => 'Teambuilding',
            'Thinking Skills' => 'Thinking Skills',
            'Time Management' => 'Time Management',
            'Training Skills' => 'Training Skills',
        );

        //multi choice question topics.
        $question_topics_multi_choice  = array( 
            'What is Assertiveness?' => 'What is Assertiveness?',
            'The Origins of Assertiveness' => 'The Origins of Assertiveness',
            'Facets of Assertiveness' => 'Facets of Assertiveness',
            'Applications of Assertiveness' => 'Applications of Assertiveness',
            'Techniques of Assertiveness'=>'Techniques of Assertiveness',
            'Managing Assertively'=>'Managing Assertively',
            'Social Assertiveness'=>'Social Assertiveness',
            'Assertive Roles at Work'=>'Assertive Roles at Work',
            'Managing Your Boss Assertively'=>'Managing Your Boss Assertively',
            'Assertiveness Training'=>'Assertiveness Training',
            'What is Change Management?'=>'What is Change Management?',
            'Responding to Change'=>'Responding to Change',
            'Managing the Change Cycle'=>'Managing the Change Cycle',
            'Cores and Peripheries'=>'Cores and Peripheries',
            'Managing Paradox'=>'Managing Paradox',
            'Managing Risk in Times of Change'=>'Managing Risk in Times of Change',
            'Managing Learning in Times of Change'=>'Managing Learning in Times of Change',
            'The Process of Change'=>'The Process of Change',
            'Managing Uncertainty'=>'Managing Uncertainty',
            'Organisational Change'=>'Organisational Change',
            'Communications'=>'Communications',
            'Communication Strategies'=>'Communication Strategies',
            'Communication Networks'=>'Communication Networks',
            'The Means of Communication'=>'The Means of Communication',
            'Communication Barriers'=>'Communication Barriers',
            'Communication Styles'=>'Communication Styles',
            'The ABC of Writing'=>'The ABC of Writing',
            'The Art of Conversation'=>'The Art of Conversation',
            'Interpersonal Skills'=>'Interpersonal Skills',
            'Non-Verbal Communication'=>'Non-Verbal Communication',
            'The Counselling Approach'=>'The Counselling Approach',
            'Awareness, Acceptance, and Change'=>'Awareness, Acceptance, and Change',
            'Personal Growth'=>'Personal Growth',
            'The Dispositions of Counselling'=>'The Dispositions of Counselling',
            'The Counselling Interview'=>'The Counselling Interview',
            'The Art of Listening'=>'The Art of Listening',
            'Asking Questions'=>'Asking Questions',
           'Challenging and Closing Down'=>'Challenging and Closing Down',
           'Moving On'=>'Moving On',
           'People Problems'=>'People Problems',
           'What is Customer Care?'=>'What is Customer Care?',
           'Ichiban to Kaizen' =>'Ichiban to Kaizen',
           'Customer Focus' =>'Customer Focus',
           'The Customer Promise'=>'The Customer Promise',
           'Customer Champions'=>'Customer Champions',
           'Customer Feedback'=>'Customer Feedback',
           'Moments of Truth'=>'Moments of Truth',
           'Customer Relations'=>'Customer Relations',
           'Customer Complaints' =>'Customer Complaints',
           'Service Style'=>'Service Style',
           'From Directing to Delegating'=>'From Directing to Delegating',
           'Models of Management'=>'Models of Management',
           'Types of Delegating'=>'Types of Delegating',
           'Delegate to Develop'=>'Delegate to Develop',
           'Delegating as a Manager'=>'Delegating as a Manager',
           'Power and Empowerment'=>'Power and Empowerment',
           'Empowered Organisations'=>'Empowered Organisations',
           'Empowered Leaders' =>'Empowered Leaders',
           'DIY Empowerment'=>'DIY Empowerment',
           'The 21st Century Manager'=>'The 21st Century Manager',
           'Routes to Discipline'=>'Routes to Discipline',
           'Laws and Rules'=>'Laws and Rules',
           'Non-Compliance'=>'Non-Compliance',
           'Problem Behaviour'=>'Problem Behaviour',
           'Fair and Full Investigation'=>'Fair and Full Investigation',
           'Alternatives to Discipline' =>'Alternatives to Discipline',
           'Disciplinary Policy and Procedure'=>'Disciplinary Policy and Procedure',
           'Counselling and Discipline'=>'Counselling and Discipline',
           'The Disciplinary Hearing'=>'The Disciplinary Hearing',
           'Fair Dismissal'=>'Fair Dismissal',
           'What is Personality?'=>'What is Personality?',
           'The Enneagram'=>'The Enneagram',
           'Ones, the Need to be Perfect'=>'Ones, the Need to be Perfect',
           'Twos, the Need to be Needed'=>'Twos, the Need to be Needed',
           'Threes, the Need to Succeed'=>'Threes, the Need to Succeed',
           'Fours, the Need to be Special'=>'Fours, the Need to be Special',
           'Fives, the Need to Perceive'=>'Fives, the Need to Perceive',
           'Sixes, the Need to be Safe' =>'Sixes, the Need to be Safe',
           'Sevens, the Need to be Happy'=>'Sevens, the Need to be Happy',
           'Eights, the Need to be Strong'=>'Eights, the Need to be Strong',
           'Nines, the Need to be at Peace'=>'Nines, the Need to be at Peace',
           'Managing Personality Types'=>'Managing Personality Types',
           'Twos, the Need to be Needed'=>'Twos, the Need to be Needed',
           'Threes, the Need to Succeed'=>'Threes, the Need to Succeed',
           'Fours, the Need to be Special'=>'Fours, the Need to be Special',
           'Fives, the Need to Perceive' =>'Fives, the Need to Perceive',
           'Sixes, the Need to be Safe'=>'Sixes, the Need to be Safe',
           'Sevens, the Need to be Happy'=>'Sevens, the Need to be Happy',
           'Eights, the Need to be Strong'=>'Eights, the Need to be Strong',
           'What is Facilitation?'=>'What is Facilitation?',
           'People and Groups'=>'People and Groups',
           'Facilitating the Start of Groupwork'=>'Facilitating the Start of Groupwork',
           'Control and Power in Facilitation'=>'Control and Power in Facilitation',
           'Empowering the Group'=>'Empowering the Group',
           'Overcoming the Blocks to Growth'=>'Overcoming the Blocks to Growth',
           'The Facilitators Toolkit'=>'The Facilitators Toolkit',
           'Overcoming the Blocks to Growth'=>'Overcoming the Blocks to Growth',
           'The Art of Non-Doing'=>'The Art of Non-Doing',
           'Group Energy'=>'Group Energy',
           'The Role of the Facilitator'=>'The Role of the Facilitator',
           'Group Endings and Separations'=>'Group Endings and Separations',
           'Influencing Skills' =>'Influencing Skills',
           'Negotiating Skills' =>'Negotiating Skills',
           'Preparing for Negotiations'=>'Preparing for Negotiations',
           'A Negotiation Game Plan'=>'A Negotiation Game Plan',
           'Power and Negotiations'=>'Power and Negotiations',
           'The Options in Conflict' =>'The Options in Conflict',
           'Making Your Case in Negotiations' =>'Making Your Case in Negotiations',
           'Stick to Your Guns in Negotiations'=>'Stick to Your Guns in Negotiations',
           'A Successful Negotiation'=>'A Successful Negotiation',
           'Agreement and After'=>'Agreement and After',
           'Management and Leadership'=>'Management and Leadership',
           'The Making of Leaders'=>'The Making of Leaders',
           'Leaders and Their Personalities'=>'Leaders and Their Personalities',
           'Mission, Vision, and Values'=>'Mission, Vision, and Values',
           'Organisational Culture'=>'Organisational Culture',
           'Leadership Styles'=>'Leadership Styles',
           'Master Communicators'=>'Master Communicators',
           'People Builders'=>'People Builders',
           'The Credibility of Leadership'=>'The Credibility of Leadership',
           'Leaders of the Future'=>'Leaders of the Future',
           'The Nature of Potential'=>'The Nature of Potential',
           'Self-Development'=>'Self-Development',
           'Know Yourself'=>'Know Yourself',
           'Goals and Goal-Setting'=>'Goals and Goal-Setting',
           'Programming Your Goals'=>'Programming Your Goals',
           'Super-Energy'=>'Super-Energy',
           'Action and Progress'=>'Action and Progress',
           'The 3lb Universe'=>'The 3lb Universe',
           'Positivity'=>'Positivity',
           'From Mastery to Mystery'=>'From Mastery to Mystery',
           'Goal-Setting'=>'Goal-Setting',
           'What is Performance Appraisal?'=>'What is Performance Appraisal?',
           'Performance Appraisal Schemes'=>'Performance Appraisal Schemes',
           'Assessing Performance'=>'Assessing Performance',
           'The Performance Appraisal Interview'=>'The Performance Appraisal Interview',
           'Managing the Under-Performer'=>'Managing the Under-Performer',
           'The Plateau-ed Performer'=>'The Plateau-ed Performer',
           'Managing the High Flyer'=>'Managing the High Flyer',
           'Constructive Feedback'=>'Constructive Feedback',
           'Play to their Strengths'=>'Play to their Strengths',
           'Outcomes of Appraisal'=>'Outcomes of Appraisal',
           'Play to their Strengths'=>'Play to their Strengths',
           'SUCCEED in Presentations'=>'SUCCEED in Presentations',
           'A Business Audience'=>'A Business Audience',
           'The Structure of Presentations'=>'The Structure of Presentations',
           'Preparing the Presentation'=>'Preparing the Presentation',
           'Presentation Techniques'=>'Presentation Techniques',
           'Using Your Voice'=>'Using Your Voice',
           'Visual Aids'=>'Visual Aids',
           'Body Language in Presentations'=>'Body Language in Presentations',
           'Overcoming Your Speaking Nerves'=>'Overcoming Your Speaking Nerves',
           'Mastering the Delivery'=>'Mastering the Delivery',
           'Approaches to Recruitment'=>'Approaches to Recruitment',
           'Being Fair in Recruitment'=>'Being Fair in Recruitment',
           'Policy and Procedure in Selection'=>'Policy and Procedure in Selection',
           'Groundwork for Hiring'=>'Groundwork for Hiring',
           'Filling the Vacancy'=>'Filling the Vacancy',
           'The Selection Interview'=>'The Selection Interview',
           'Selection Interview Skills'=>'Selection Interview Skills',
           'Go and No Go Questions'=>'Go and No Go Questions',
           'Tests and Assessments'=>'Tests and Assessments',
           'Selection and Appointment'=>'Selection and Appointment',
           'The Nature of Stress'=>'The Nature of Stress',
           'Stressors'=>'Stressors',
           'Coping with Stress'=>'Coping with Stress',
           'Managing the Physical'=>'Managing the Physical',
           'Stress Solutions'=>'Stress Solutions',
           'Managing Perceptions'=>'Managing Perceptions',
           'Managing Emotions'=>'Managing Emotions',
           'Managing Perspective'=>'Managing Perspective',
           'Focused Relaxation'=>'Focused Relaxation',
           'Stress-Busters'=>'Stress-Busters',
           'The Nature of Teams'=>'The Nature of Teams',
           'Team Development' =>'Team Development',
           'Teamwork'=>'Teamwork',
           'Team Cohesion'=>'Team Cohesion',
           'Threats to Teamwork'=>'Threats to Teamwork',
           'Team Leadership'=>'Team Leadership',
           'Team Roles'=>'Team Roles',
           'Team Meetings'=>'Team Meetings',
           'Unshared Certainty to Shared Uncertainty'=>'Unshared Certainty to Shared Uncertainty',
           'Teambuilders'=>'Teambuilders',
           'What Are Thinking Skills?'=>'What Are Thinking Skills?',
           'The Thoughts In Your Head'=>'The Thoughts In Your Head',
           'Memory, Concentration, and Imagination'=>'Memory, Concentration, and Imagination',
           'Blocks to Thinking'=>'Blocks to Thinking',
           'Reasoned Thinking'=>'Reasoned Thinking',
           'Creative Thinking'=>'Creative Thinking',
           'Brainstorming'=>'Brainstorming',
           'Decision-Taking'=>'Decision-Taking',
           'Problem-Solving'=>'Problem-Solving',
           'Innovation'=>'Innovation',
           'The Paradoxes of Time'=>'The Paradoxes of Time',
           'Working Time'=>'Working Time',
           'Models of Time Management'=>'Models of Time Management',
           'Routine Time'=>'Routine Time',
           'Time on Progress Work'=>'Time on Progress Work',
           'Time and Projects'=>'Time and Projects',
           'Non-Doing Work'=>'Non-Doing Work',
           'Time and Others'=>'Time and Others',
           'Time Travellers'=>'Time Travellers',
           'Personal Effectiveness'=>'Personal Effectiveness',
           'The Need for Training'=>'The Need for Training',
           'Managing Training'=>'Managing Training',
           'Models of Learning'=>'Models of Learning',
           'Designing Training'=>'Designing Training',
           'Running a Course'=>'Running a Course',
           'The Process of Training'=>'The Process of Training',
           'Groupwork and Training'=>'Groupwork and Training',
           'Learning Styles'=>'Learning Styles',
           'The Resourceful Trainer'=>'The Resourceful Trainer',
           'Evaluating Training'=>'Evaluating Training',
        


        ); 
        // Question topic flash card
        $question_topics_flash_card  = array( 
            'What Is Assertiveness?'=>'What Is Assertiveness?',
            'The Origins of Assertiveness'=>'The Origins of Assertiveness',
            'Facets of Assertiveness'=>'Facets of Assertiveness',
            'Applications of Assertiveness'=>'Applications of Assertiveness',
            'Techniques of Assertiveness'=>'Techniques of Assertiveness',
            'Managing Assertively'=>'Managing Assertively',
            'Social Assertiveness'=>'Social Assertiveness',
            'Assertive Roles at Work'=>'Assertive Roles at Work',
            'Managing Your Boss Assertively'=>'Managing Your Boss Assertively',
            'Assertiveness Training'=>'Assertiveness Training',
            'What is Change Management?'=>'What is Change Management?',
            'Responding to Change'=>'Responding to Change',
            'Managing the Change Cycle'=>'Managing the Change Cycle',
            'Cores and Peripheries'=>'Cores and Peripheries',
            'Managing Paradox'=>'Managing Paradox',
            'Managing Risk' =>'Managing Risk',  
            'Managing Learning'=>'Managing Learning',
            'The Process of Change'=>'The Process of Change',
            'Managing Uncertainty'=>'Managing Uncertainty',
            'Organisational Change'=>'Organisational Change',
            'Communications'=>'Communications',
            'Communication Strategies'=>'Communication Strategies',
            'Communication Networks'=>'Communication Networks',
            'The Means of Communication'=>'The Means of Communication',
            'Communication Barriers'=>'Communication Barriers',
            'Communication Styles'=>'Communication Styles',
            'The ABC of Writing'=>'The ABC of Writing',
            'The Art of Conversation'=>'The Art of Conversation',
            'The Interpersonal Dance' =>'The Interpersonal Dance',
            'Non-Verbal Communication' =>'Non-Verbal Communication',
            'The Counselling Approach'  =>'The Counselling Approach',
            'Awareness, Acceptance, and Change'=>'Awareness, Acceptance, and Change',
            'Personal Growth'=>'Personal Growth',
            'The Dispositions of Counselling'=>'The Dispositions of Counselling',
            'The Counselling Interview' =>'The Counselling Interview',    
            'The Art of Listening'=>'The Art of Listening',
            'Asking Questions'=>'Asking Questions',
            'Challenging and Closing Down'=>'Challenging and Closing Down',
            'Moving On From Counselling'=>'Moving On From Counselling',
            'People Problems'=>'People Problems',
            'What is Customer Care?'=>'What is Customer Care?',
            'Ichiban to Kaizen'=>'Ichiban to Kaizen',
            'Customer Focus'=>'Customer Focus',
            'The Customer Promise'=>'The Customer Promise' ,  
            'Customer Champions'=>'Customer Champions',
            'Customer Feedback'=>'Customer Feedback',
            'Moments of Truth'=>'Moments of Truth',
            'Customer Relations'=>'Customer Relations',
            'Customer Complaints'=>'Customer Complaints',
            'Service Style'=>'Service Style',
            'From Directing To Delegating'=>'From Directing To Delegating',
            'Models Of Management'=>'Models Of Management',
            'Types Of Delegating'=>'Types Of Delegating',
            'Delegate To Develop'=>'Delegate To Develop',
            'Delegating As A Manager'=>'Delegating As A Manager',
            'Power And Empowerment'=>'Power And Empowerment',
            'Empowered Organisations'=>'Empowered Organisations',
            'Empowering Leaders'=>'Empowering Leaders',
            'DIY Empowerment'=>'DIY Empowerment',
            'The 21st Century Manager'=>'The 21st Century Manager',
            'Routes to Discipline'=>'Routes to Discipline',
            'Laws and Rules'=>'Laws and Rules',
            'Non-Compliance'=>'Non-Compliance',
            'Problem Behaviour'=>'Problem Behaviour',
            'Fair and Full Investigation'=>'Fair and Full Investigation',
            'Alternatives to Discipline'=>'Alternatives to Discipline',
            'Disciplinary Policy and Procedure'=>'Disciplinary Policy and Procedure',
            'The Difficult Conversation'=>'The Difficult Conversation',
            'The Disciplinary Hearing'=>'The Disciplinary Hearing',
            'Fair Dismissal'=>'Fair Dismissal',
            'What is Personality?'=>'What is Personality?',
            'The Enneagram'=>'The Enneagram',
            'The Need to be Perfect'=>'The Need to be Perfect',
            'The Need to be Needed'=>'The Need to be Needed',
            'The Need to Succeed'=>'The Need to Succeed',
            'The Need to be Special'=>'The Need to be Special',
            'The Need to Perceive'=>'The Need to Perceive',
            'The Need to be Safe'=>'The Need to be Safe',
            'The Need to be Happy'=>'The Need to be Happy',
            'The Need to be Strong'=>'The Need to be Strong',
            'The Need to be at Peace'=>'The Need to be at Peace',
            'Managing Personality Types'=>'Managing Personality Types',
            'What is Facilitation?' =>'What is Facilitation?',
            'People and Groups'=>'People and Groups',
            'Group Formation'=>'Group Formation',
            'Group Leadership'=>'Group Leadership', 
            'Empowering the Group'=>'Empowering the Group',
            'The Facilitators Toolkit'=>'The Facilitators Toolkit',
            'Group Dynamics'=>'Group Dynamics',
            'The Art of Non-Doing'=>'The Art of Non-Doing',
            'The Expert Facilitator'=>'The Expert Facilitator',
            'Endings and Separations'=>'Endings and Separations',
            'Influencing Skills'=>'Influencing Skills',
            'Negotiating skills'=>'Negotiating skills',
            'Preparing for Negotiations'=>'Preparing for Negotiations',
            'A Negotiation Game Plan'=>'A Negotiation Game Plan',
            'Power and Negotiations'=>'Power and Negotiations',
            'The Options in Conflict'=>'The Options in Conflict',
            'Making Your Case in Negotiations'=>'Making Your Case in Negotiations',
            'Stick to Your Guns in Negotiations'=>'Stick to Your Guns in Negotiations',
            'A Successful Negotiation'=>'A Successful Negotiation',
            'Agreement and After'=>'Agreement and After',
            'Management and Leadership'=>'Management and Leadership',
            'The Making of Leaders'=>'The Making of Leaders',
            'Leadership Types'=>'Leadership Types',
            'Mission, Vision, and Values'=>'Mission, Vision, and Values',
            'Organisational Culture'=>'Organisational Culture',
            'Leadership Style'=>'Leadership Style',
            'Master Communicators'=>'Master Communicators',
            'People Builders'=>'People Builders',
            'The Credibility of Leaders'=>'The Credibility of Leaders',
            'Leaders of the Future'=>'Leaders of the Future',
            'The Nature of Potential'=>'The Nature of Potential',       
            'Self-Development'=>'Self-Development',
            'Know Yourself'=>'Know Yourself',
            'Goals and Goal-Setting'=>'Goals and Goal-Setting',
            'Programming your Goals'=>'Programming your Goals',
            'Super-Energy'=>'Super-Energy',
            'Action and Progress'=>'Action and Progress',
            'The 3lb Universe'=>'The 3lb Universe',
            'Positivity'=>'Positivity',
            'From Mastery to Mystery'=>'From Mastery to Mystery',
            'SUCCEED in Presentations'=>'SUCCEED in Presentations',
            'A Business Audience'=>'A Business Audience',
            'The Structure of Presentations'=>'The Structure of Presentations',
            'Preparing the Presentation'=>'Preparing the Presentation',
            'Presentation Techniques'=>'Presentation Techniques',
            'Using Your Voice'=>'Using Your Voice',
            'Visual Aids'=>'Visual Aids',
            'Body Language in Presentations'=>'Body Language in Presentations',
            'Overcoming Your Speaking Nerves'=>'Overcoming Your Speaking Nerves',
            'Mastering the Delivery'=>'Mastering the Delivery',
            'Approaches to Recruitment'=>'Approaches to Recruitment',
            'Being Fair'=>'Being Fair',
            'Recruitment Policy and Procedure'=>'Recruitment Policy and Procedure',
            'Groundwork for Hiring'=>'Groundwork for Hiring',
            'Filling the Vacancy'=>'Filling the Vacancy',
            'The Selection Interview'=>'The Selection Interview',
            'Selection Interview Skills'=>'Selection Interview Skills',
            'Go and No Go Questions' =>'Go and No Go Questions',
            'Tests and Assessments'=>'Tests and Assessments',
            'Selection and Appointment'=>'Selection and Appointment',
            'The Nature of Stress'=>'The Nature of Stress',
            'Stressors'=>'Stressors',
            'Coping with Stress'=>'Coping with Stress',
            'Stress and the Physical Response'=>'Stress and the Physical Response',
            'Stress Solutions'=>'Stress Solutions',
            'Managing Perceptions'=>'Managing Perceptions',
            'Managing Emotions'=>'Managing Emotions',
            'Putting Things Into Perspective'=>'Putting Things Into Perspective', 
            'Focused Relaxation'=>'Focused Relaxation',
            'Stress-Busters'=>'Stress-Busters',
            'What Is Appraisal?'=>'What Is Appraisal?',
            'Appraisal Schemes'=>'Appraisal Schemes',
            'Assessment'=>'Assessment',
            'The Appraisal Interview'=>'The Appraisal Interview',
            'Managing the Under-Performer'=>'Managing the Under-Performer',
            'The Plateaued Performer'=>'The Plateaued Performer',
            'Managing the High Flyer'=>'Managing the High Flyer',
            'Constructive Feedback' =>'Constructive Feedback',
            'Play to their Strengths'=>'Play to their Strengths',
            'Outcomes of Appraisal'=>'Outcomes of Appraisal',
            'The Nature of Teams'=>'The Nature of Teams',
            'Team Development'=>'Team Development',
            'Teamwork'=>'Teamwork',
            'Team Cohesion'=>'Team Cohesion',
             'Threats to Teamwork'=>'Threats to Teamwork',
             'Team Leadership'=>'Team Leadership',
             'Team Roles'=>'Team Roles',
             'Team Meetings'=>'Team Meetings',
             'Building and Bonding'=>'Building and Bonding',
             'Teambuilders'=>'Teambuilders',
             'What are Thinking Skills?'=>'What are Thinking Skills?',
             'The Thoughts In Your Head'=>'The Thoughts In Your Head',
             '3D Thinking'=>'3D Thinking',
             'Blocks to Thinking'=>'Blocks to Thinking',
             'Reasoned Thinking'=>'Reasoned Thinking',
             'Creative Thinking'=>'Creative Thinking',
             'Group Thinking'=>'Group Thinking',
            'Decision-Taking'=>'Decision-Taking',
            'Problem-Solving'=>'Problem-Solving',
            'Innovation'=>'Innovation',
            'The Paradoxes of Time'=>'The Paradoxes of Time',
            'Working Time'=>'Working Time',
            'Models of Time Management'=>'Models of Time Management',
            'Routine Time'=>'Routine Time',
            'Time on Progress Work'=>'Time on Progress Work',
            'Time and Projects'=>'Time and Projects',
            'Non-Doing Work'=>'Non-Doing Work',
            'Time and Others'=>'Time and Others',
            'Time Travellers'=>'Time Travellers',
            'The Effective Time Manager'=>'The Effective Time Manager',
            'The Need for Training'=>'The Need for Training',
            'Managing Training'=>'Managing Training',
            'Models of Learning'=>'Models of Learning',
            'Designing Training'=>'Designing Training',
            'Running a Course'=>'Running a Course',
             'The Process of Training'=>'The Process of Training',
            'Groupwork and Training'=>'Groupwork and Training',
            'Learning Styles'=>'Learning Styles',
            'The Resourceful Trainer'=>'The Resourceful Trainer',
            'Evaluating Training'=>'Evaluating Training'
            
    
           ); 
       $question_topic_fill_in_the_blank = array(
        'What is Assertiveness?'=>'What is Assertiveness?',
        'The Origins of Assertiveness'=>'The Origins of Assertiveness',
        'Facets of Assertiveness'=>'Facets of Assertiveness',
        'Applications of Assertiveness'=>'Applications of Assertiveness',
        'Techniques of Assertiveness'=>'Techniques of Assertiveness',
        'Managing Assertively'=>'Managing Assertively',
        'Social Assertiveness'=>'Social Assertiveness',
        'Assertive Roles at Work'=>'Assertive Roles at Work',
        'Managing Your Boss Assertively'=>'Managing Your Boss Assertively',
        'Assertiveness Training'=>'Assertiveness Training',
        'What is Change Management?'=>'What is Change Management?',
        'Responding to Change'=>'Responding to Change',
        'Managing the Change Cycle'=>'Managing the Change Cycle',
        'Cores and Peripheries'=>'Cores and Peripheries',
        'Managing Paradox'=>'Managing Paradox',
        'Managing Risk in Times of Change'=>'Managing Risk in Times of Change',
        'Managing Learning in Times of Change'=>'Managing Learning in Times of Change',
        'The Process of Change'=>'The Process of Change',
        'Managing Uncertainty'=>'Managing Uncertainty',
        'Organisational Change'=>'Organisational Change',
        'Communications'=>'Communications',
        'Communication Strategies'=>'Communication Strategies',
        'Communication Networks'=>'Communication Networks',
        'The Means of Communication'=>'The Means of Communication',
        'Communication Barriers'=>'Communication Barriers',
        'Communication Styles'=>'Communication Styles',
        'The ABC of Writing'=>'The ABC of Writing',
        'The Art of Conversation'=>'The Art of Conversation',
        'Interpersonal Skills'=>'Interpersonal Skills',
        'Non-Verbal Communication'=>'Non-Verbal Communication',
        'The Counselling Approach'=>'The Counselling Approach',
        'Awareness, Acceptance, and Change'=>'Awareness, Acceptance, and Change',
        'Personal Growth'=>'Personal Growth',
        'The Dispositions of Counselling'=>'The Dispositions of Counselling',
        'The Counselling Interview'=>'The Counselling Interview',
        'The Art of Listening'=>'The Art of Listening',
        'Asking Questions'=>'Asking Questions',
        'Challenging and Closing Down'=>'Challenging and Closing Down',
        'Moving On'=>'Moving On',
        'People Problems'=>'People Problems',
        'What is Customer Care?'=>'What is Customer Care?',
        'Ichiban to Kaizen'=>'Ichiban to Kaizen',
        'Customer Focus'=>'Customer Focus',
        'The Customer Promise'=>'The Customer Promise',
        'Customer Champions'=>'Customer Champions',
        'Customer Feedback'=>'Customer Feedback',
        'Moments of Truth'=>'Moments of Truth',
        'Customer Relations'=>'Customer Relations',
        'Customer Complaints'=>'Customer Complaints',
        'Service Style'=>'Service Style',
        'From Directing to Delegating'=>'From Directing to Delegating',
        'Models of Management'=>'Models of Management',
        'Types of Delegating'=>'Types of Delegating',
        'Delegate to Develop'=>'Delegate to Develop',
        'Delegating as a Manager'=>'Delegating as a Manager',
        'Power and Empowerment'=>'Power and Empowerment',
        'Empowered Organisations'=>'Empowered Organisations',
        'Empowered Leaders'=>'Empowered Leaders',
        'DIY Empowerment'=>'DIY Empowerment',
        'The 21st Century Manager'=>'The 21st Century Manager',
        'Routes to Discipline'=>'Routes to Discipline',
        'Laws and Rules'=>'Laws and Rules',
        'Non-Compliance'=>'Non-Compliance',
        'Problem Behaviour'=>'Problem Behaviour',
        'Fair and Full Investigation'=>'Fair and Full Investigation',
        'Alternatives to Discipline'=>'Alternatives to Discipline',
        'Disciplinary Policy and Procedure'=>'Disciplinary Policy and Procedure',
        'Counselling and Discipline'=>'Counselling and Discipline',
        'The Disciplinary Hearing'=>'The Disciplinary Hearing',
        'Fair Dismissal'=>'Fair Dismissal',
        'What is Personality?'=>'What is Personality?',
        'The Enneagram'=>'The Enneagram',
        'Ones, the Need to be Perfect'=>'Ones, the Need to be Perfect',
        'Twos, the Need to be Needed'=>'Twos, the Need to be Needed',
        'Threes, the Need to Succeed'=>'Threes, the Need to Succeed',
        'Fours, the Need to be Special'=>'Fours, the Need to be Special',
        'Fives, the Need to Perceive'=>'Fives, the Need to Perceive',
        'Sixes, the Need to be Safe'=>'Sixes, the Need to be Safe',
        'Sevens, the Need to be Happy'=>'Sevens, the Need to be Happy',
        'Eights, the Need to be Strong'=>'Eights, the Need to be Strong',
        'Nines, the Need to be at Peace'=>'Nines, the Need to be at Peace',
        'Managing Personality Types'=>'Managing Personality Types',
        'What is Facilitation?'=>'What is Facilitation?',
        'People and Groups'=>'People and Groups',
        'Facilitating the Start of Groupwork'=>'Facilitating the Start of Groupwork',
        'Control and Power in Facilitation'=>'Control and Power in Facilitation',
        'Empowering the Group'=>'Empowering the Group',
        'The Facilitators Toolkit'=>'The Facilitators Toolkit',
        'Overcoming the Blocks to Growth'=>'Overcoming the Blocks to Growth',
        'The Art of Non-Doing'=>'The Art of Non-Doing',
        'Group Energy'=>'Group Energy',
        'Endings and Separations'=>'Endings and Separations',
        'Influencing Skills'=>'Influencing Skills',
        'Negotiating Skills'=>'Negotiating Skills',
        'Preparing for Negotiations'=>'Preparing for Negotiations',
        'A Negotiation Game Plan'=>'A Negotiation Game Plan',
        'Power and Negotiations'=>'Power and Negotiations',
        'The Options in Conflict'=>'The Options in Conflict',
        'Making Your Case in Negotiations'=>'Making Your Case in Negotiations',
        'Stick to Your Guns in Negotiations'=>'Stick to Your Guns in Negotiations',
        'A Successful Negotiation'=>'A Successful Negotiation',
        'Agreement and After'=>'Agreement and After',
        'Management and Leadership'=>'Management and Leadership',
        'The Making of Leaders'=>'The Making of Leaders',
        'Leaders and Their Personalities'=>'Leaders and Their Personalities',
        'Mission, Vision, and Values'=>'Mission, Vision, and Values',
        'Organisational Culture'=>'Organisational Culture',
        'Leadership Style'=>'Leadership Style',
        'Master Communicators'=>'Master Communicators',
        'People Builders'=>'People Builders',
        'The Credibility of Leaders'=>'The Credibility of Leaders',
        'Leaders of the Future'=>'Leaders of the Future',
        'The Nature of Potential'=>'The Nature of Potential',
        'Self-Development'=>'Self-Development',
        'Know Yourself'=>'Know Yourself',
        'Goals and Goal-Setting'=>'Goals and Goal-Setting',
        'Programming your Goals'=>'Programming your Goals',
        'Super-Energy'=>'Super-Energy',
        'Action and Progress'=>'Action and Progress',
        'The 3lb Universe'=>'The 3lb Universe',
        'Positivity'=>'Positivity',
        'From Mastery to Mystery'=>'From Mastery to Mystery',
        'What Is Appraisal?'=>'What Is Appraisal?',
        'Appraisal Schemes'=>'Appraisal Schemes',
        'Assessment'=>'Assessment',
        'The Appraisal Interview'=>'The Appraisal Interview',
        'Managing the Under-Performer'=>'Managing the Under-Performer',
        'The Plateau-ed Performer'=>'The Plateau-ed Performer',
        'Managing the High Flyer'=>'Managing the High Flyer',
        'Constructive Feedback'=>'Constructive Feedback',
        'Play to their Strengths'=>'Play to their Strengths',
        'Outcomes of Appraisal'=>'Outcomes of Appraisal',
        'SUCCEED in Presentations'=>'SUCCEED in Presentations',
        'A Business Audience'=>'A Business Audience',
        'The Structure of Presentations'=>'The Structure of Presentations',
        'Preparing the Presentation'=>'Preparing the Presentation',
        'Presentation Techniques'=>'Presentation Techniques',
        'Using Your Voice'=>'Using Your Voice',
        'Visual Aids'=>'Visual Aids',
        'Body Language in Presentations'=>'Body Language in Presentations',
        'Overcoming Your Speaking Nerves'=>'Overcoming Your Speaking Nerves',
        'Mastering the Delivery'=>'Mastering the Delivery',
        'Approaches to Recruitment'=>'Approaches to Recruitment',
        'Being Fair'=>'Being Fair',
        'Recruitment Policy and Procedure'=>'Recruitment Policy and Procedure',
        'Groundwork for Hiring'=>'Groundwork for Hiring',
        'Filling the Vacancy'=>'Filling the Vacancy',
        'The Selection Interview'=>'The Selection Interview',
        'Selection Interview Skills'=>'Selection Interview Skills',
        'Go and No Go Questions'=>'Go and No Go Questions',
        'Tests and Assessments'=>'Tests and Assessments',
        'Selection and Appointment'=>'Selection and Appointment',
        'The Nature of Stress'=>'The Nature of Stress',
    
        'Stressors'=>'Stressors',
        'Coping with Stress'=>'Coping with Stress',
        'Stress and the Physical Response'=>'Stress and the Physical Response',
        'Stress Solutions'=>'Stress Solutions',
        'Managing Perceptions'=>'Managing Perceptions',
        'Managing Emotions'=>'Managing Emotions',
        'Putting Things into Perspective'=>'Putting Things into Perspective',
        'Focused Relaxation'=>'Focused Relaxation',
        'Stress-Busters'=>'Stress-Busters',
        'The Nature of Teams'=>'The Nature of Teams',
        'Team Development'=>'Team Development',
        'Teamwork'=>'Teamwork',
        'Team Cohesion'=>'Team Cohesion',
        'Threats to Teamwork'=>'Threats to Teamwork',
        'Team Leadership'=>'Team Leadership',
        'Team Roles'=>'Team Roles',
        'Team Meetings'=>'Team Meetings',
        'Unshared Certainty to Shared Uncertainty'=>'Unshared Certainty to Shared Uncertainty',
        'Teambuilders'=>'Teambuilders',
        'What are Thinking Skills?'=>'What are Thinking Skills?',
        'The Thoughts In Your Head'=>'The Thoughts In Your Head',
        'Memory, Concentration, and Imagination'=>'Memory, Concentration, and Imagination',
        'Blocks to Thinking'=>'Blocks to Thinking',
        'Reasoned Thinking'=>'Reasoned Thinking',
        'Creative Thinking'=>'Creative Thinking',
        'Brainstorming'=>'Brainstorming',
        'Decision-Taking'=>'Decision-Taking',
        'Problem-Solving'=>'Problem-Solving',
        'Innovation'=>'Innovation',
        'The Paradoxes of Time'=>'The Paradoxes of Time',
        'Working Time'=>'Working Time',
        'Models of Time Management'=>'Models of Time Management',
        'Routine Time'=>'Routine Time',
        'Time on Progress Work'=>'Time on Progress Work',
        'Time and Projects'=>'Time and Projects',
        'Non-Doing Work'=>'Non-Doing Work',
        'Time and Others'=>'Time and Others',
        'Time Travellers'=>'Time Travellers',
        'The Effective Time Manager'=>'The Effective Time Manager',
        'The Need for Training'=>'The Need for Training',
        'Managing Training'=>'Managing Training',
        'Models of Learning'=>'Models of Learning',
        'Designing Training'=>'Designing Training',
        'Running a Course'=>'Running a Course',
        'The Process of Training'=>'The Process of Training',
        'Groupwork and Training'=>'Groupwork and Training',
        'Learning Styles'=>'Learning Styles',
        'The Resourceful Trainer'=>'The Resourceful Trainer',
        'Evaluating Training'=>'Evaluating Training',
        'Assertiveness'=>'Assertiveness',
        'Change Management'=>'Change Management',
        'Communications'=>'Communications',
        'Counselling Skills'=>'Counselling Skills',
        'Customer Care'=>'Customer Care',
        'Delegation and Empowerment'=>'Delegation and Empowerment',
        'Effective Discipline'=>'Effective Discipline',
        'Enneagram Personality Types'=>'Enneagram Personality Types',
        'Facilitation Skills'=>'Facilitation Skills',
        'Influencing and Negotiating Skills'=>'Influencing and Negotiating Skills',
        'Leadership Skills'=>'Leadership Skills',
        'Maximising Your Potential'=>'Maximising Your Potential',
        'Performance Management and Appraisal'=>'Performance Management and Appraisal',
        'Presentation Skills'=>'Presentation Skills',
        'Recruitment and Selection'=>'Recruitment and Selection',
        'Stress Management'=>'Stress Management',
        'Teambuilding'=>'Teambuilding',
        'Thinking Skills'=>'Thinking Skills',
        'Time Management'=>'Time Management',
        'Training Skills'=>'Training Skills',
               );
       $number_question_topic = array(
        'Assertiveness'=>'Assertiveness',
'Change Management'=>'Change Management',
'Communications'=>'Communications',
'Counselling Skills'=>'Counselling Skills',
'Customer Care'=>'Customer Care',
'Delegation and Empowerment'=>'Delegation and Empowerment',
'Effective Discipline'=>'Effective Discipline',
'Enneagram Personality Types'=>'Enneagram Personality Types',
'Facilitation Skills'=>'Facilitation Skills',
'Influencing and Negotiating Skills'=>'Influencing and Negotiating Skills',
'Leadership Skills'=>'Leadership Skills',
'Maximising Your Potential'=>'Maximising Your Potential',
'Performance Management and Appraisal'=>'Performance Management and Appraisal',
'Presentation Skills'=>'Presentation Skills',
'Recruitment and Selection'=>'Recruitment and Selection',
'Stress Management'=>'Stress Management',
'Teambuilding'=>'Teambuilding',
'Thinking Skills'=>'Thinking Skills',
'Time Management'=>'Time Management',
'Training Skills'=>'Training Skills',
    );  
    $question_topic_true_and_false = array(
        'What is Assertiveness?'=>'What is Assertiveness?',
        'The Origins of Assertiveness'=>'The Origins of Assertiveness',
        'Facets of Assertiveness'=>'Facets of Assertiveness',
        'Applications of Assertiveness'=>'Applications of Assertiveness',
        'Techniques of Assertiveness'=>'Techniques of Assertiveness',
        'Managing Assertively'=>'Managing Assertively',
        'Social Assertiveness'=>'Social Assertiveness',
        'Assertive Roles at Work'=>'Assertive Roles at Work',
        'Managing Your Boss Assertively'=>'Managing Your Boss Assertively',
        'Assertiveness Training'=>'Assertiveness Training',
        'What is Change Management?'=>'What is Change Management?',
        'Responding to Change'=>'Responding to Change',
        'Managing the Change Cycle'=>'Managing the Change Cycle',
        'Cores and Peripheries'=>'Cores and Peripheries',
        'Managing Paradox'=>'Managing Paradox',
        'Managing Risk in Times of Change'=>'Managing Risk in Times of Change',
        'Managing Learning in Times of Change'=>'Managing Learning in Times of Change',
        'The Process of Change'=>'The Process of Change',
        'Managing Uncertainty'=>'Managing Uncertainty',
        'Organisational Change'=>'Organisational Change',
        'Communications'=>'Communications',
        'Communication Strategies'=>'Communication Strategies',
        'Communication Networks'=>'Communication Networks',
        'The Means of Communication'=>'The Means of Communication',
        'Communication Barriers'=>'Communication Barriers',
        'Communication Styles'=>'Communication Styles',
        'The ABC of Writing'=>'The ABC of Writing',
        'The Art of Conversation'=>'The Art of Conversation',
        'Interpersonal Skills'=>'Interpersonal Skills',
        'Non-Verbal Communication'=>'Non-Verbal Communication',
        'The Counselling Approach'=>'The Counselling Approach',
        'Awareness, Acceptance, and Change'=>'Awareness, Acceptance, and Change',
        'Personal Growth'=>'Personal Growth',
        'The Dispositions of Counselling'=>'The Dispositions of Counselling',
        'The Counselling Interview'=>'The Counselling Interview',
        'The Art of Listening'=>'The Art of Listening',
        'Asking Questions'=>'Asking Questions',
        'Challenging and Closing Down'=>'Challenging and Closing Down',
        'Moving On'=>'Moving On',
        'People Problems'=>'People Problems',
        'What is Customer Care?'=>'What is Customer Care?',
        'Ichiban to Kaizen'=>'Ichiban to Kaizen',
        'Customer Focus'=>'Customer Focus',
        'The Customer Promise'=>'The Customer Promise',
        'Customer Champions'=>'Customer Champions',
        'Customer Feedback'=>'Customer Feedback',
        'Moments of Truth'=>'Moments of Truth',
        'Customer Relations'=>'Customer Relations',
        'Customer Complaints'=>'Customer Complaints',
        'Service Style'=>'Service Style',
        'From Directing to Delegating'=>'From Directing to Delegating',
        'Models of Management'=>'Models of Management',
        'Types of Delegating'=>'Types of Delegating',
        'Delegate to Develop'=>'Delegate to Develop',
        'Delegating as a Manager'=>'Delegating as a Manager',
        'Power and Empowerment'=>'Power and Empowerment',
        'Empowered Organisations'=>'Empowered Organisations',
        'Empowered Leaders'=>'Empowered Leaders',
        'DIY Empowerment'=>'DIY Empowerment',
        'The 21st Century Manager'=>'The 21st Century Manager',
        'Routes to Discipline'=>'Routes to Discipline',
        'Laws and Rules'=>'Laws and Rules',
        'Non-Compliance'=>'Non-Compliance',
        'Problem Behaviour'=>'Problem Behaviour',
        'Fair and Full Investigation'=>'Fair and Full Investigation',
        'Alternatives to Discipline'=>'Alternatives to Discipline',
        'Disciplinary Policy and Procedure'=>'Disciplinary Policy and Procedure',
        'Counselling and Discipline'=>'Counselling and Discipline',
        'The Disciplinary Hearing'=>'The Disciplinary Hearing',
        'Fair Dismissal'=>'Fair Dismissal',
        'What is Personality?'=>'What is Personality?',
        'The Enneagram'=>'The Enneagram',
        'Ones, the Need to be Perfect'=>'Ones, the Need to be Perfect',
        'Twos, the Need to be Needed'=>'Twos, the Need to be Needed',
        'Threes, the Need to Succeed'=>'Threes, the Need to Succeed',
        'Fours, the Need to be Special'=>'Fours, the Need to be Special',
        'Fives, the Need to Perceive'=>'Fives, the Need to Perceive',
        'Sixes, the Need to be Safe'=>'Sixes, the Need to be Safe',
        'Sevens, the Need to be Happy'=>'Sevens, the Need to be Happy',
        'Eights, the Need to be Strong'=>'Eights, the Need to be Strong',
        'Nines, the Need to be at Peace'=>'Nines, the Need to be at Peace',
        'Managing Personality Types'=>'Managing Personality Types',
        'What is Facilitation?'=>'What is Facilitation?',
        'People and Groups'=>'People and Groups',
        'Facilitating the Start of Groupwork'=>'Facilitating the Start of Groupwork',
        'Control and Power in Facilitation'=>'Control and Power in Facilitation',
        'Empowering the Group'=>'Empowering the Group',
        'The Facilitators Toolkit'=>'The Facilitators Toolkit',
        'Overcoming the Blocks to Growth'=>'Overcoming the Blocks to Growth',
        'The Art of Non-Doing'=>'The Art of Non-Doing',
        'Group Energy'=>'Group Energy',
        'Endings and Separations'=>'Endings and Separations',
        'Influencing Skills'=>'Influencing Skills',
        'Negotiating Skills'=>'Negotiating Skills',
        'Preparing for Negotiations'=>'Preparing for Negotiations',
        'A Negotiation Game Plan'=>'A Negotiation Game Plan',
        'Power and Negotiations'=>'Power and Negotiations',
        'The Options in Conflict'=>'The Options in Conflict',
        'Making Your Case in Negotiations'=>'Making Your Case in Negotiations',
        'Stick to Your Guns in Negotiations'=>'Stick to Your Guns in Negotiations',
        'A Successful Negotiation'=>'A Successful Negotiation',
        'Agreement and After'=>'Agreement and After',
        'Management and Leadership'=>'Management and Leadership',
        'The Making of Leaders'=>'The Making of Leaders',
        'Leaders and Their Personalities'=>'Leaders and Their Personalities',
        'Mission, Vision, and Values'=>'Mission, Vision, and Values',
        'Organisational Culture'=>'Organisational Culture',
        'Leadership Style'=>'Leadership Style',
        'Master Communicators'=>'Master Communicators',
        'People Builders'=>'People Builders',
        'The Credibility of Leaders'=>'The Credibility of Leaders',
        'Leaders of the Future'=>'Leaders of the Future',
        'The Nature of Potential'=>'The Nature of Potential',
        'Self-Development'=>'Self-Development',
        'Know Yourself'=>'Know Yourself',
        'Goals and Goal-Setting'=>'Goals and Goal-Setting',
        'Programming your Goals'=>'Programming your Goals',
        'Super-Energy'=>'Super-Energy',
        'Action and Progress'=>'Action and Progress',
        'The 3lb Universe'=>'The 3lb Universe',
        'Positivity'=>'Positivity',
        'From Mastery to Mystery'=>'From Mastery to Mystery',
        'What Is Appraisal?'=>'What Is Appraisal?',
        'Appraisal Schemes'=>'Appraisal Schemes',
        'Assessment'=>'Assessment',
        'The Appraisal Interview'=>'The Appraisal Interview',
        'Managing the Under-Performer'=>'Managing the Under-Performer',
        'The Plateau-ed Performer'=>'The Plateau-ed Performer',
        'Managing the High Flyer'=>'Managing the High Flyer',
        'Constructive Feedback'=>'Constructive Feedback',
        'Play to their Strengths'=>'Play to their Strengths',
        'Outcomes of Appraisal'=>'Outcomes of Appraisal',
        'SUCCEED in Presentations'=>'SUCCEED in Presentations',
        'A Business Audience'=>'A Business Audience',
        'The Structure of Presentations'=>'The Structure of Presentations',
        'Preparing the Presentation'=>'Preparing the Presentation',
        'Presentation Techniques'=>'Presentation Techniques',
        'Using Your Voice'=>'Using Your Voice',
        'Visual Aids'=>'Visual Aids',
        'Body Language in Presentations'=>'Body Language in Presentations',
        'Overcoming Your Speaking Nerves'=>'Overcoming Your Speaking Nerves',
        'Mastering the Delivery'=>'Mastering the Delivery',
        'Approaches to Recruitment'=>'Approaches to Recruitment',
        'Being Fair'=>'Being Fair',
        'Recruitment Policy and Procedure'=>'Recruitment Policy and Procedure',
        'Groundwork for Hiring'=>'Groundwork for Hiring',
        'Filling the Vacancy'=>'Filling the Vacancy',
        'The Selection Interview'=>'The Selection Interview',
        'Selection Interview Skills'=>'Selection Interview Skills',
        'Go and No Go Questions'=>'Go and No Go Questions',
        'Tests and Assessments'=>'Tests and Assessments',
        'Selection and Appointment'=>'Selection and Appointment',
        'The Nature of Stress'=>'The Nature of Stress',
        'Stressors'=>'Stressors',
        'Coping with Stress'=>'Coping with Stress',
        'Stress and the Physical Response'=>'Stress and the Physical Response',
        'Stress Solutions'=>'Stress Solutions',
        'Managing Perceptions'=>'Managing Perceptions',
        'Managing Emotions'=>'Managing Emotions',
        'Putting Things into Perspective'=>'Putting Things into Perspective',
        'Focused Relaxation'=>'Focused Relaxation',
        'Stress-Busters'=>'Stress-Busters',
        'The Nature of Teams'=>'The Nature of Teams',
        'Team Development'=>'Team Development',
        'Teamwork'=>'Teamwork',
        'Team Cohesion'=>'Team Cohesion',
        'Threats to Teamwork'=>'Threats to Teamwork',
        'Team Leadership'=>'Team Leadership',
        'Team Roles'=>'Team Roles',
        'Team Meetings'=>'Team Meetings',
        'Unshared Certainty to Shared Uncertainty'=>'Unshared Certainty to Shared Uncertainty',
        'Teambuilders'=>'Teambuilders',
        'What are Thinking Skills?'=>'What are Thinking Skills?',
        'The Thoughts In Your Head'=>'The Thoughts In Your Head',
        'Memory, Concentration, and Imagination'=>'Memory, Concentration, and Imagination',
        'Blocks to Thinking'=>'Blocks to Thinking',
        'Reasoned Thinking'=>'Reasoned Thinking',
        'Creative Thinking'=>'Creative Thinking',
        'Brainstorming'=>'Brainstorming',
        'Decision-Taking'=>'Decision-Taking',
        'Problem-Solving'=>'Problem-Solving',
        'Innovation'=>'Innovation',
        'The Paradoxes of Time'=>'The Paradoxes of Time',
        'Working Time'=>'Working Time',
        'Models of Time Management'=>'Models of Time Management',
        'Routine Time'=>'Routine Time',
        'Time on Progress Work'=>'Time on Progress Work',
        'Time and Projects'=>'Time and Projects',
        'Non-Doing Work'=>'Non-Doing Work',
        'Time and Others'=>'Time and Others',
        'Time Travellers'=>'Time Travellers',
        'The Effective Time Manager'=>'The Effective Time Manager',
        'The Need for Training'=>'The Need for Training',
        'Managing Training'=>'Managing Training',
        'Models of Learning'=>'Models of Learning',
        'Designing Training'=>'Designing Training',
        'Running a Course'=>'Running a Course',
        'The Process of Training'=>'The Process of Training',
        'Groupwork and Training'=>'Groupwork and Training',
        'Learning Styles'=>'Learning Styles',
        'The Resourceful Trainer'=>'The Resourceful Trainer',
        'Evaluating Training'=>'Evaluating Training',
        'Assertiveness'=>'Assertiveness',
        'Change Management'=>'Change Management',
        'Communications'=>'Communications',
        'Counselling Skills'=>'Counselling Skills',
        'Customer Care'=>'Customer Care',
        'Delegation and Empowerment'=>'Delegation and Empowerment',
        'Effective Discipline'=>'Effective Discipline',
        'Enneagram Personality Types'=>'Enneagram Personality Types',
        'Facilitation Skills'=>'Facilitation Skills',
        'Influencing and Negotiating Skills'=>'Influencing and Negotiating Skills',
        'Leadership Skills'=>'Leadership Skills',
        'Maximising Your Potential'=>'Maximising Your Potential',
        'Performance Management and Appraisal'=>'Performance Management and Appraisal',
        'Presentation Skills'=>'Presentation Skills',
        'Recruitment and Selection'=>'Recruitment and Selection',
        'Stress Management'=>'Stress Management',
        'Teambuilding'=>'Teambuilding',
        'Thinking Skills'=>'Thinking Skills',
        'Time Management'=>'Time Management',
        'Training Skills'=>'Training Skills',
               );   
               $question_topic_either_or =  array (
                'Performance Management and Appraisal' => 'Performance Management and Appraisal',
                'Assertivenes' => 'Assertiveness',
                'Change Management' => 'Change Management',
                'Meeting Skills' => 'Meeting Skills',
                'Asking Questions' => 'Asking Questions',
                'Customer Complaints' => 'Customer Complaints',
                'Customer Service' => 'Customer Service',
                'Empowered Organisations'=> 'Empowered Organisations',
                'Effective Discipline' => 'Effective Discipline',
                'Enneagram Personality Types' => 'Enneagram Personality Types',
                'Facilitation Skills' => 'Facilitation Skills',
                'Influencing and Negotiating Skills' => 'Influencing and Negotiating Skills',
                'Leadership Skills' => 'Leadership Skills',
                'Know Yourself' => 'Know Yourself',
                'Presentation Skills' => 'Presentation Skills',
                'The Person Specification' => 'The Person Specification',
                'Recruitment and Selection' => 'Recruitment and Selection',
                'Recruitment Policy and Procedure' => 'Recruitment Policy and Procedure',
                'Stress Management' => 'Stress Management',
                'Teambuilding' => 'Teambuilding',
                'Thinking Skills' => 'Thinking Skills',
                'Time Management' => 'Time Management',
                'Training Skills'=> 'Training Skills',
    );     
    $question_topic_six_of_best = array (
        'Appraisal Schemes' => 'Appraisal Schemes',
         'The Appraisal Interview' => 'The Appraisal Interview',
         'Constructive Feedback'=> 'Constructive Feedback',
         'Outcomes of Appraisal' => 'Outcomes of Appraisal',
         'The Assertive Manager' => 'The Assertive Manager',
        'What is Change Management?' => 'What is Change Management?',
         'Cores and Peripheries' => 'Cores and Peripheries',
         'Smart Reading' => 'Smart Reading',
         'The Counselling Approach' => 'The Counselling Approach',
         'The Counselling Interview'=> 'The Counselling Interview',
        'The Art of Listening' => 'The Art of Listening',
         'Moving on from Counselling' => 'Moving on from Counselling',
        'The Customer Promise' => 'The Customer Promise',
         'Empowered Organisations' => 'Empowered Organisations',
         'Delegating as a Manager' => 'Delegating as a Manager',
         'Organisational Structures' => 'Organisational Structures',
         'Empowered Organisations'=> 'Empowered Organisations',
        'Empowering Leaders' => 'Empowering Leaders',
         'Laws and Rules'=> 'Laws and Rules',
         'Fair and Full Investigation' => 'Fair and Full Investigation',
         'Alternatives to Discipline' => 'Alternatives to Discipline',
         'Disciplinary Policy and Procedure' => 'Disciplinary Policy and Procedure',
         'The Difficult Conversation'=> 'The Difficult Conversation',
         'The Disciplinary Hearing'=> 'The Disciplinary Hearing',
         'Managing Personality Types' => 'Managing Personality Types',
        'What is Facilitation?' => 'What is Facilitation?',
         'Empowering the Group' => 'Empowering the Group',
       'Control and Power in Facilitation'=> 'Control and Power in Facilitation',
         'Group Energy' => 'Group Energy',
         'Influencing Skills' => 'Influencing Skills',
        'Power and Negotiations'=> 'Power and Negotiations',
        'Management and Leadership' => 'Management and Leadership',
         'Mission, Vision, and Values' => 'Mission, Vision, and Values',
       'Organisational Culture' => 'Organisational Culture',
         'Leadership Styles' => 'Leadership Styles',
         'People Builders' => 'People Builders',
         'The Nature of Potential'=> 'The Nature of Potential',
         'From Mastery to Mystery' => 'From Mastery to Mystery',
        'Body Language in Presentations'=> 'Body Language in Presentations',
         'Selection Interview Skills' => 'Selection Interview Skills',
         'Putting Things into Perspective' => 'Putting Things into Perspective',
         'Focused Relaxation'=> 'Focused Relaxation',
         'Teamwork' => 'Teamwork',
        'The Nature of Teams' => 'The Nature of Teams',
         'Reasoned Thinking' => 'Reasoned Thinking',
        'Working Time' => 'Working Time',
         'Routine Time' => 'Routine Time',
         'Time on Progress Work' => 'Time on Progress Work',
        'Non-Doing Work' => 'Non-Doing Work',
         'Time and Others'=> 'Time and Others',
         'Designing Training' => 'Designing Training',
       );    
       $question_topic_sequence= array (
        'Conflict Resolution' => 'Conflict Resolution',
        'Alternative Conflict Resolution'=> 'Alternative Conflict Resolution',
       'The Kubler-Ross Model of Change' => 'The Kubler-Ross Model of Change',
       'Natural Change' => 'Natural Change',
       'Persuasion' => 'Persuasion',
       'The Communications Loop' => 'The Communications Loop',
       'An Interpersonal Exchange' => 'An Interpersonal Exchange',
        'A Counselling Session' => 'A Counselling Session',
        'Resolving a Customer Complaint' => 'Resolving a Customer Complaint',
       'Progressive Levels of Responsibility' => 'Progressive Levels of Responsibility',
        'Levels of Freedom' => 'Levels of Freedom',
        'What People Want from their Leaders' => 'What People Want from their Leaders',
        'Disciplinary Procedure' => 'Disciplinary Procedure',
        'Counselling' => 'Counselling',
       'Disciplinary Hearing' => 'Disciplinary Hearing',
         'The Business Cycle' => 'The Business Cycle',
        'Group Workshops' => 'Group Workshops',
       'Power Negotiations'=> 'Power Negotiations',
        'Transformational Leadership' => 'Transformational Leadership',
        'Stages of Change' => 'Stages of Change',
       'Leadership Skills' => 'Leadership Skills',
        'Goals and Goal-Setting' => 'Goals and Goal-Setting',
        'Constructive Feedback' => 'Constructive Feedback',
        'The Appraisal Interview' => 'The Appraisal Interview',
       'Logorrophobia' => 'Logorrophobia',
        'Top 10 Job Requirement Skills'=> 'Top 10 Job Requirement Skills',
       'The Recruitment Cycle' => 'The Recruitment Cycle',
        'Selection Techniques' => 'Selection Techniques',
        'Shortlisting' => 'Shortlisting',
        'Job Advertisement' => 'Job Advertisement',
        'Recruitment Interview'=> 'Recruitment Interview',
        'Stressful Life Events' => 'Stressful Life Events',
        'Team Meetings' => 'Team Meetings',
        'Team Meetings' => 'Team Meetings',
        'Building a Team' => 'Building a Team',
        'Tuckmans Team Development Model' => 'Tuckmans Team Development Model',
        'Stages of Team Dependence' => 'Stages of Team Dependence',
        'Visualisation' => 'Visualisation',
         'Classic Problem-Solving'=> 'Classic Problem-Solving',
        'Task Prioritisation' => 'Task Prioritisation',
       'The Project Life Cycle' => 'The Project Life Cycle',
       'The Conscious-Competence Ladder' => 'The Conscious-Competence Ladder',
       'Giving Instructions' => 'Giving Instructions',
        'Kolbs Experiential Learning Model'=> 'Kolbs Experiential Learning Model',
       'John Whitmore Coaching Model'=> 'John Whitmore Coaching Model',
       'GROW Coaching Model' => 'GROW Coaching Model',
       
      ); 
      $question_topic_matching_item = array (
        'What is Appraisal?' => 'What is Appraisal?',
       'Assessment'=> 'Assessment',
       'Managing the Under-Performer' => 'Managing the Under-Performer',
        'Performance Management and Appraisal' => 'Performance Management and Appraisal',
       'The Plateau-ed Performer' => 'The Plateau-ed Performer',
        'Outcomes of Appraisal' => 'Outcomes of Appraisal',
        'Facets of Assertiveness' => 'Facets of Assertiveness',
         'Applications of Assertiveness' => 'Applications of Assertiveness',
        'Techniques of Assertiveness' => 'Techniques of Assertiveness',
        'The Assertive Manager'=> 'The Assertive Manager',
        'The Process of Change' => 'The Process of Change',
       'Organisational Change' => 'Organisational Change',
        'Communication Strategies' => 'Communication Strategies',
        'The Means of Communication' => 'The Means of Communication',
         'Communication Barriers' => 'Communication Barriers',
        'The Art of Conversation' => 'The Art of Conversation',
         'Interpersonal Skills' => 'Interpersonal Skills',
        'Non-Verbal Communication' => 'Non-Verbal Communication',
        'The Counselling Approach' => 'The Counselling Approach',
       'Awareness, Acceptance, and Change' => 'Awareness, Acceptance, and Change',
        'Personal Growth'=> 'Personal Growth',
         'The Counselling Interview' => 'The Counselling Interview',
        'The Art of Listening' => 'The Art of Listening',
        'Asking Questions' => 'Asking Questions',
       'People Problems'=> 'People Problems',
        'Customer Care' => 'Customer Care',
        'Delegation and Empowerment' => 'Delegation and Empowerment',
      'Effective Discipline'=> 'Effective Discipline',
       'Enneagram Personality Types'=> 'Enneagram Personality Types',
        'Facilitation Skills'=> 'Facilitation Skills',
      'Influencing and Negotiating Skills' => 'Influencing and Negotiating Skills',
       'Leadership Skills'=> 'Leadership Skills',
        'Maximising Your Potential'=> 'Maximising Your Potential',
        'Presentation Skills'=> 'Presentation Skills',
        'Recruitment and Selection' => 'Recruitment and Selection',
         'Stress Management' => 'Stress Management',
       'Teambuilding' => 'Teambuilding',
        'Thinking Skills' => 'Thinking Skills',
        'Time Management' => 'Time Management',
        'Training Skills' => 'Training Skills',
        'Performance Management and Appraisal'=> 'Performance Management and Appraisal',
        'Assertiveness' => 'Assertiveness',
        'Change Management' => 'Change Management',
        'Communications' => 'Communications',
        'Counselling Skills'=> 'Counselling Skills',
      );                                             
        if($question_type == 10 ||  $question_type == 9 ||   $question_type == 8 ||  $question_type == 7 || $question_type == 6 || $question_type == 5 || $question_type == 4 || $question_type == 3 || $question_type == 2 || $question_type == 1 ){
    
             return response()->json([
                 'html' => view('backend.questions.form_'.$question_type, compact('questiontype_array', 'option_array','questioncat_array','question_topics_multi_choice','question_topics_flash_card','question_topic_fill_in_the_blank','number_question_topic','question_topic_true_and_false','question_topic_either_or','question_topic_six_of_best','question_topic_sequence','question_topic_matching_item'))->render()
             ]);
            
        }else{
             return response()->json([
                 'html' => view('backend.questions.form_no_data', compact('questiontype_array', 'option_array','questioncat_array'))->render()
             ]);
        }
         
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

    public function store(Request $request)
    {
       
        if($request->typeId == 8){
            
            $validator = Validator::make($request->all(), [
                'questionTitle' => 'required',
                'question_category'=> 'required',
                'question_topic'=> 'required',
                'question_instructions'=>'required',
                'optionCorrectAnswer'=>'required',
            ]);
    
            if($validator->fails()){
                
                return Redirect::back()->withErrors($validator)->withInput();
            }
            $posted_array['language_id'] = 1;
            $posted_array['type_id'] = $request->typeId;
           
            // $qestion_arry = array(); 
            // foreach($request->questionTitle as $question ){
            //     $qestion_arry = $question;
            // }
            // print_r($qestion_arry);
            //$posted_array['question_title'] = $request->questionTitle;
            $posted_array['question_category'] = $request->question_category;
            $posted_array['question_topic'] = $request->question_topic;
            $posted_array['question_instructions'] = $request->question_instructions;
            $question_id = Question::create($posted_array)->id;
            $data = array();
            $data['question_title'] = $request->questionTitle;
            $data['right_answer'] = $request->optionCorrectAnswer;

            Question::where('id',$question_id)->update($data);
            return  redirect('backend/questions/all')->with('success','Question has been added successfully');

        } elseif($request->typeId == 10){
            $validator = Validator::make($request->all(), [
                'questionTitle' => 'required',
                'question_category'=> 'required',
                'question_topic'=> 'required',
                'question_instructions'=>'required',
                'optionCorrectAnswer'=>'required',
            ]);
    
            if($validator->fails()){
                
                return Redirect::back()->withErrors($validator)->withInput();
            }
            $posted_array['language_id'] = 1;
            $posted_array['type_id'] = $request->typeId;
            $posted_array['question_title'] = $request->questionTitle;
            $posted_array['question_category'] = $request->question_category;
            $posted_array['question_topic'] = $request->question_topic;
            $posted_array['question_instructions'] = $request->question_instructions;
            $question_id = Question::create($posted_array)->id;
            $data = array();
            $data['right_answer'] = $request->optionCorrectAnswer;
            Question::where('id',$question_id)->update($data);
            return  redirect('backend/questions/all')->with('success','Question has been added successfully');

        }
        elseif($request->typeId == 7 || $request->typeId == 6  ){
            $validator = Validator::make($request->all(), [
                'questionTitle' => 'required',
                'question_category'=> 'required',
                'question_topic'=> 'required',
                'question_instructions'=>'required',
            ]);
    
            if($validator->fails()){
                
                return Redirect::back()->withErrors($validator)->withInput();
            }
            $posted_array['language_id'] = 1;
            $posted_array['type_id'] = $request->typeId;
            $posted_array['question_title'] = $request->questionTitle;
            $posted_array['question_category'] = $request->question_category;
            $posted_array['question_topic'] = $request->question_topic;
            $posted_array['question_instructions'] = $request->question_instructions;
            $question_id = Question::create($posted_array)->id;
            $option_array['answer01'] = $request->answer01;
            $option_array['answer02'] = $request->answer02;
            $option_array['answer03'] = $request->answer03;
            $option_array['answer04'] = $request->answer04;
            $option_array['answer05'] = $request->answer05;
            $option_array['answer06'] = $request->answer06;
            $option_array['answer07'] = $request->answer07;
            $option_array['answer08'] = $request->answer08;
            $option_array['answer09'] = $request->answer09;
            $option_array['answer10'] = $request->answer10;
            //$answer_option = $request->optionCorrectAnswer;

            foreach($option_array as $key => $value){
                $saveOption = array();
                $optionCorrectAnswer = 0;
                // if($value == $answer_option){
                //     $optionCorrectAnswer = 1;
                // }
                $saveOption = array(
                    'question_id' => $question_id,
                    'option_value' => $value,
                    'correct_answer' => $optionCorrectAnswer
                );
                Questionoption::create($saveOption);
            }
            // $questions_arry = Questionoption::Select('option_value')->where('question_id',$question_id)->where('correct_answer',1)->first();
            // $data = array();
            $data['right_answer'] = $request->optionCorrectAnswer;
            Question::where('id',$question_id)->update($data);
            return  redirect('backend/questions/all')->with('success','Question has been added successfully');
        }
        elseif($request->typeId == 5 || $request->typeId == 4){
            $validator = Validator::make($request->all(), [
                'questionTitle' => 'required',
                'question_category'=> 'required',
                'question_topic'=> 'required',
                'question_instructions'=>'required',
            ]);
    
            if($validator->fails()){
                
                return Redirect::back()->withErrors($validator)->withInput();
            }
            $posted_array['language_id'] = 1;
            $posted_array['type_id'] = $request->typeId;
            $posted_array['question_title'] = $request->questionTitle;
            $posted_array['question_category'] = $request->question_category;
            $posted_array['question_topic'] = $request->question_topic;
            $posted_array['question_instructions'] = $request->question_instructions;
            $question_id = Question::create($posted_array)->id;
            $option_array['answer01'] = $request->answer01;
            $option_array['answer02'] = $request->answer02;
         
            $answer_option = $request->optionCorrectAnswer;

            foreach($option_array as $key => $value){
                $saveOption = array();
                $optionCorrectAnswer = 0;
                if($value == $answer_option){
                    $optionCorrectAnswer = 1;
                }
                $saveOption = array(
                    'question_id' => $question_id,
                    'option_value' => $value,
                    'correct_answer' => $optionCorrectAnswer
                );
                Questionoption::create($saveOption);
            }
            $questions_arry = Questionoption::Select('option_value')->where('question_id',$question_id)->where('correct_answer',1)->first();
            $data = array();
            $data['right_answer'] = $questions_arry->option_value;
            Question::where('id',$question_id)->update($data);
            return  redirect('backend/questions/all')->with('success','Question has been added successfully');
        }
        else{
            $validator = Validator::make($request->all(), [
                'questionTitle' => 'required',
                'question_category'=> 'required',
                'question_topic'=> 'required',
                'question_instructions'=>'required',
            ]);
    
            if($validator->fails()){
                
                return Redirect::back()->withErrors($validator)->withInput();
            }
            $posted_array['language_id'] = 1;
            $posted_array['type_id'] = $request->typeId;
            $posted_array['question_title'] = $request->questionTitle;
            $posted_array['question_category'] = $request->question_category;
            $posted_array['question_topic'] = $request->question_topic;
            $posted_array['question_instructions'] = $request->question_instructions;
            $question_id = Question::create($posted_array)->id;
            $option_array['answer01'] = $request->answer01;
            $option_array['answer02'] = $request->answer02;
            $option_array['answer03'] = $request->answer03;
            $option_array['answer04'] = $request->answer04;
            $option_array['answer05'] = $request->answer05;
            $option_array['answer06'] = $request->answer06;
            $option_array['answer07'] = $request->answer07;
            $option_array['answer08'] = $request->answer08;
            $option_array['answer09'] = $request->answer09;
            $option_array['answer10'] = $request->answer10;
            $answer_option = $request->optionCorrectAnswer;

            foreach($option_array as $key => $value){
                $saveOption = array();
                $optionCorrectAnswer = 0;
                if($value == $answer_option){
                    $optionCorrectAnswer = 1;
                }
                $saveOption = array(
                    'question_id' => $question_id,
                    'option_value' => $value,
                    'correct_answer' => $optionCorrectAnswer
                );
                Questionoption::create($saveOption);
            }
            $questions_arry = Questionoption::Select('option_value')->where('question_id',$question_id)->where('correct_answer',1)->first();
            $data = array();
            $data['right_answer'] = $questions_arry->option_value;
            Question::where('id',$question_id)->update($data);
            return  redirect('backend/questions/all')->with('success','Question has been added successfully');
        }
    }


    public function editQuestion($id){
    
        $question_data = Question::where('id',$id)->first();
        $options_arry = Questionoption::Select('option_value')->where('question_id',$id)->get();
        $questiontypes = Questiontype::pluck('type_title', 'id')->all();
		$questiontype_array = array();
        if (!empty($questiontypes)) {
            foreach ($questiontypes as $key => $value) {
                $questiontype_array[$key] = $value;
            }
        }
        $questioncat_array  = array(
            'Assertiveness' => 'Assertiveness',
            'Change Management' => 'Change Management',
            'Communications' => 'Communications',
            'Counselling Skills' => 'Counselling Skills',
            'Customer Care' => 'Customer Care',
            'Delegation and Empowerment' => 'Delegation and Empowerment',
            'Effective Discipline' => 'Effective Discipline',
            'Enneagram PersonalityTypes' => 'Enneagram Personality Types',
            'Facilitation Skills' => 'Facilitation Skills',
            'Influencing and Negotiating Skills' => 'Influencing and Negotiating Skills',
            'Leadership Skills' => 'Leadership Skills',
            'Maximising Your Potential' => 'Maximising Your Potential',
            'Performance Management and Appraisal' => 'Performance Management and Appraisal',
            'Presentation Skills' => 'Presentation Skills',
            'Recruitment and Selection' => 'Recruitment and Selection',
            'Stress Management' => 'Stress Management',
            'Teambuilding' => 'Teambuilding',
            'Thinking Skills' => 'Thinking Skills',
            'Time Management' => 'Time Management',
            'Training Skills' => 'Training Skills',
        );
            // Question topic flash card
            $question_topics_flash_card  = array( 
                'What Is Assertiveness?'=>'What Is Assertiveness?',
                'The Origins of Assertiveness'=>'The Origins of Assertiveness',
                'Facets of Assertiveness'=>'Facets of Assertiveness',
                'Applications of Assertiveness'=>'Applications of Assertiveness',
                'Techniques of Assertiveness'=>'Techniques of Assertiveness',
                'Managing Assertively'=>'Managing Assertively',
                'Social Assertiveness'=>'Social Assertiveness',
                'Assertive Roles at Work'=>'Assertive Roles at Work',
                'Managing Your Boss Assertively'=>'Managing Your Boss Assertively',
                'Assertiveness Training'=>'Assertiveness Training',
                'What is Change Management?'=>'What is Change Management?',
                'Responding to Change'=>'Responding to Change',
                'Managing the Change Cycle'=>'Managing the Change Cycle',
                'Cores and Peripheries'=>'Cores and Peripheries',
                'Managing Paradox'=>'Managing Paradox',
                'Managing Risk' =>'Managing Risk',  
                'Managing Learning'=>'Managing Learning',
                'The Process of Change'=>'The Process of Change',
                'Managing Uncertainty'=>'Managing Uncertainty',
                'Organisational Change'=>'Organisational Change',
                'Communications'=>'Communications',
                'Communication Strategies'=>'Communication Strategies',
                'Communication Networks'=>'Communication Networks',
                'The Means of Communication'=>'The Means of Communication',
                'Communication Barriers'=>'Communication Barriers',
                'Communication Styles'=>'Communication Styles',
                'The ABC of Writing'=>'The ABC of Writing',
                'The Art of Conversation'=>'The Art of Conversation',
                'The Interpersonal Dance' =>'The Interpersonal Dance',
                'Non-Verbal Communication' =>'Non-Verbal Communication',
                'The Counselling Approach'  =>'The Counselling Approach',
                'Awareness, Acceptance, and Change'=>'Awareness, Acceptance, and Change',
                'Personal Growth'=>'Personal Growth',
                'The Dispositions of Counselling'=>'The Dispositions of Counselling',
                'The Counselling Interview' =>'The Counselling Interview',    
                'The Art of Listening'=>'The Art of Listening',
                'Asking Questions'=>'Asking Questions',
                'Challenging and Closing Down'=>'Challenging and Closing Down',
                'Moving On From Counselling'=>'Moving On From Counselling',
                'People Problems'=>'People Problems',
                'What is Customer Care?'=>'What is Customer Care?',
                'Ichiban to Kaizen'=>'Ichiban to Kaizen',
                'Customer Focus'=>'Customer Focus',
                'The Customer Promise'=>'The Customer Promise' ,  
                'Customer Champions'=>'Customer Champions',
                'Customer Feedback'=>'Customer Feedback',
                'Moments of Truth'=>'Moments of Truth',
                'Customer Relations'=>'Customer Relations',
                'Customer Complaints'=>'Customer Complaints',
                'Service Style'=>'Service Style',
                'From Directing To Delegating'=>'From Directing To Delegating',
                'Models Of Management'=>'Models Of Management',
                'Types Of Delegating'=>'Types Of Delegating',
                'Delegate To Develop'=>'Delegate To Develop',
                'Delegating As A Manager'=>'Delegating As A Manager',
                'Power And Empowerment'=>'Power And Empowerment',
                'Empowered Organisations'=>'Empowered Organisations',
                'Empowering Leaders'=>'Empowering Leaders',
                'DIY Empowerment'=>'DIY Empowerment',
                'The 21st Century Manager'=>'The 21st Century Manager',
                'Routes to Discipline'=>'Routes to Discipline',
                'Laws and Rules'=>'Laws and Rules',
                'Non-Compliance'=>'Non-Compliance',
                'Problem Behaviour'=>'Problem Behaviour',
                'Fair and Full Investigation'=>'Fair and Full Investigation',
                'Alternatives to Discipline'=>'Alternatives to Discipline',
                'Disciplinary Policy and Procedure'=>'Disciplinary Policy and Procedure',
                'The Difficult Conversation'=>'The Difficult Conversation',
                'The Disciplinary Hearing'=>'The Disciplinary Hearing',
                'Fair Dismissal'=>'Fair Dismissal',
                'What is Personality?'=>'What is Personality?',
                'The Enneagram'=>'The Enneagram',
                'The Need to be Perfect'=>'The Need to be Perfect',
                'The Need to be Needed'=>'The Need to be Needed',
                'The Need to Succeed'=>'The Need to Succeed',
                'The Need to be Special'=>'The Need to be Special',
                'The Need to Perceive'=>'The Need to Perceive',
                'The Need to be Safe'=>'The Need to be Safe',
                'The Need to be Happy'=>'The Need to be Happy',
                'The Need to be Strong'=>'The Need to be Strong',
                'The Need to be at Peace'=>'The Need to be at Peace',
                'Managing Personality Types'=>'Managing Personality Types',
                'What is Facilitation?' =>'What is Facilitation?',
                'People and Groups'=>'People and Groups',
                'Group Formation'=>'Group Formation',
                'Group Leadership'=>'Group Leadership', 
                'Empowering the Group'=>'Empowering the Group',
                'The Facilitators Toolkit'=>'The Facilitators Toolkit',
                'Group Dynamics'=>'Group Dynamics',
                'The Art of Non-Doing'=>'The Art of Non-Doing',
                'The Expert Facilitator'=>'The Expert Facilitator',
                'Endings and Separations'=>'Endings and Separations',
                'Influencing Skills'=>'Influencing Skills',
                'Negotiating skills'=>'Negotiating skills',
                'Preparing for Negotiations'=>'Preparing for Negotiations',
                'A Negotiation Game Plan'=>'A Negotiation Game Plan',
                'Power and Negotiations'=>'Power and Negotiations',
                'The Options in Conflict'=>'The Options in Conflict',
                'Making Your Case in Negotiations'=>'Making Your Case in Negotiations',
                'Stick to Your Guns in Negotiations'=>'Stick to Your Guns in Negotiations',
                'A Successful Negotiation'=>'A Successful Negotiation',
                'Agreement and After'=>'Agreement and After',
                'Management and Leadership'=>'Management and Leadership',
                'The Making of Leaders'=>'The Making of Leaders',
                'Leadership Types'=>'Leadership Types',
                'Mission, Vision, and Values'=>'Mission, Vision, and Values',
                'Organisational Culture'=>'Organisational Culture',
                'Leadership Style'=>'Leadership Style',
                'Master Communicators'=>'Master Communicators',
                'People Builders'=>'People Builders',
                'The Credibility of Leaders'=>'The Credibility of Leaders',
                'Leaders of the Future'=>'Leaders of the Future',
                'The Nature of Potential'=>'The Nature of Potential',       
                'Self-Development'=>'Self-Development',
                'Know Yourself'=>'Know Yourself',
                'Goals and Goal-Setting'=>'Goals and Goal-Setting',
                'Programming your Goals'=>'Programming your Goals',
                'Super-Energy'=>'Super-Energy',
                'Action and Progress'=>'Action and Progress',
                'The 3lb Universe'=>'The 3lb Universe',
                'Positivity'=>'Positivity',
                'From Mastery to Mystery'=>'From Mastery to Mystery',
                'SUCCEED in Presentations'=>'SUCCEED in Presentations',
                'A Business Audience'=>'A Business Audience',
                'The Structure of Presentations'=>'The Structure of Presentations',
                'Preparing the Presentation'=>'Preparing the Presentation',
                'Presentation Techniques'=>'Presentation Techniques',
                'Using Your Voice'=>'Using Your Voice',
                'Visual Aids'=>'Visual Aids',
                'Body Language in Presentations'=>'Body Language in Presentations',
                'Overcoming Your Speaking Nerves'=>'Overcoming Your Speaking Nerves',
                'Mastering the Delivery'=>'Mastering the Delivery',
                'Approaches to Recruitment'=>'Approaches to Recruitment',
                'Being Fair'=>'Being Fair',
                'Recruitment Policy and Procedure'=>'Recruitment Policy and Procedure',
                'Groundwork for Hiring'=>'Groundwork for Hiring',
                'Filling the Vacancy'=>'Filling the Vacancy',
                'The Selection Interview'=>'The Selection Interview',
                'Selection Interview Skills'=>'Selection Interview Skills',
                'Go and No Go Questions' =>'Go and No Go Questions',
                'Tests and Assessments'=>'Tests and Assessments',
                'Selection and Appointment'=>'Selection and Appointment',
                'The Nature of Stress'=>'The Nature of Stress',
                'Stressors'=>'Stressors',
                'Coping with Stress'=>'Coping with Stress',
                'Stress and the Physical Response'=>'Stress and the Physical Response',
                'Stress Solutions'=>'Stress Solutions',
                'Managing Perceptions'=>'Managing Perceptions',
                'Managing Emotions'=>'Managing Emotions',
                'Putting Things Into Perspective'=>'Putting Things Into Perspective', 
                'Focused Relaxation'=>'Focused Relaxation',
                'Stress-Busters'=>'Stress-Busters',
                'What Is Appraisal?'=>'What Is Appraisal?',
                'Appraisal Schemes'=>'Appraisal Schemes',
                'Assessment'=>'Assessment',
                'The Appraisal Interview'=>'The Appraisal Interview',
                'Managing the Under-Performer'=>'Managing the Under-Performer',
                'The Plateaued Performer'=>'The Plateaued Performer',
                'Managing the High Flyer'=>'Managing the High Flyer',
                'Constructive Feedback' =>'Constructive Feedback',
                'Play to their Strengths'=>'Play to their Strengths',
                'Outcomes of Appraisal'=>'Outcomes of Appraisal',
                'The Nature of Teams'=>'The Nature of Teams',
                'Team Development'=>'Team Development',
                'Teamwork'=>'Teamwork',
                'Team Cohesion'=>'Team Cohesion',
                 'Threats to Teamwork'=>'Threats to Teamwork',
                 'Team Leadership'=>'Team Leadership',
                 'Team Roles'=>'Team Roles',
                 'Team Meetings'=>'Team Meetings',
                 'Building and Bonding'=>'Building and Bonding',
                 'Teambuilders'=>'Teambuilders',
                 'What are Thinking Skills?'=>'What are Thinking Skills?',
                 'The Thoughts In Your Head'=>'The Thoughts In Your Head',
                 '3D Thinking'=>'3D Thinking',
                 'Blocks to Thinking'=>'Blocks to Thinking',
                 'Reasoned Thinking'=>'Reasoned Thinking',
                 'Creative Thinking'=>'Creative Thinking',
                 'Group Thinking'=>'Group Thinking',
                'Decision-Taking'=>'Decision-Taking',
                'Problem-Solving'=>'Problem-Solving',
                'Innovation'=>'Innovation',
                'The Paradoxes of Time'=>'The Paradoxes of Time',
                'Working Time'=>'Working Time',
                'Models of Time Management'=>'Models of Time Management',
                'Routine Time'=>'Routine Time',
                'Time on Progress Work'=>'Time on Progress Work',
                'Time and Projects'=>'Time and Projects',
                'Non-Doing Work'=>'Non-Doing Work',
                'Time and Others'=>'Time and Others',
                'Time Travellers'=>'Time Travellers',
                'The Effective Time Manager'=>'The Effective Time Manager',
                'The Need for Training'=>'The Need for Training',
                'Managing Training'=>'Managing Training',
                'Models of Learning'=>'Models of Learning',
                'Designing Training'=>'Designing Training',
                'Running a Course'=>'Running a Course',
                 'The Process of Training'=>'The Process of Training',
                'Groupwork and Training'=>'Groupwork and Training',
                'Learning Styles'=>'Learning Styles',
                'The Resourceful Trainer'=>'The Resourceful Trainer',
                'Evaluating Training'=>'Evaluating Training'
                
        
               ); 
            //multi choice question topics.
            $question_topics_multi_choice  = array( 
                'What is Assertiveness?' => 'What is Assertiveness?',
                'The Origins of Assertiveness' => 'The Origins of Assertiveness',
                'Facets of Assertiveness' => 'Facets of Assertiveness',
                'Applications of Assertiveness' => 'Applications of Assertiveness',
                'Techniques of Assertiveness'=>'Techniques of Assertiveness',
                'Managing Assertively'=>'Managing Assertively',
                'Social Assertiveness'=>'Social Assertiveness',
                'Assertive Roles at Work'=>'Assertive Roles at Work',
                'Managing Your Boss Assertively'=>'Managing Your Boss Assertively',
                'Assertiveness Training'=>'Assertiveness Training',
                'What is Change Management?'=>'What is Change Management?',
                'Responding to Change'=>'Responding to Change',
                'Managing the Change Cycle'=>'Managing the Change Cycle',
                'Cores and Peripheries'=>'Cores and Peripheries',
                'Managing Paradox'=>'Managing Paradox',
                'Managing Risk in Times of Change'=>'Managing Risk in Times of Change',
                'Managing Learning in Times of Change'=>'Managing Learning in Times of Change',
                'The Process of Change'=>'The Process of Change',
                'Managing Uncertainty'=>'Managing Uncertainty',
                'Organisational Change'=>'Organisational Change',
                'Communications'=>'Communications',
                'Communication Strategies'=>'Communication Strategies',
                'Communication Networks'=>'Communication Networks',
                'The Means of Communication'=>'The Means of Communication',
                'Communication Barriers'=>'Communication Barriers',
                'Communication Styles'=>'Communication Styles',
                'The ABC of Writing'=>'The ABC of Writing',
                'The Art of Conversation'=>'The Art of Conversation',
                'Interpersonal Skills'=>'Interpersonal Skills',
                'Non-Verbal Communication'=>'Non-Verbal Communication',
                'The Counselling Approach'=>'The Counselling Approach',
                'Awareness, Acceptance, and Change'=>'Awareness, Acceptance, and Change',
                'Personal Growth'=>'Personal Growth',
                'The Dispositions of Counselling'=>'The Dispositions of Counselling',
                'The Counselling Interview'=>'The Counselling Interview',
                'The Art of Listening'=>'The Art of Listening',
                'Asking Questions'=>'Asking Questions',
               'Challenging and Closing Down'=>'Challenging and Closing Down',
               'Moving On'=>'Moving On',
               'People Problems'=>'People Problems',
               'What is Customer Care?'=>'What is Customer Care?',
               'Ichiban to Kaizen' =>'Ichiban to Kaizen',
               'Customer Focus' =>'Customer Focus',
               'The Customer Promise'=>'The Customer Promise',
               'Customer Champions'=>'Customer Champions',
               'Customer Feedback'=>'Customer Feedback',
               'Moments of Truth'=>'Moments of Truth',
               'Customer Relations'=>'Customer Relations',
               'Customer Complaints' =>'Customer Complaints',
               'Service Style'=>'Service Style',
               'From Directing to Delegating'=>'From Directing to Delegating',
               'Models of Management'=>'Models of Management',
               'Types of Delegating'=>'Types of Delegating',
               'Delegate to Develop'=>'Delegate to Develop',
               'Delegating as a Manager'=>'Delegating as a Manager',
               'Power and Empowerment'=>'Power and Empowerment',
               'Empowered Organisations'=>'Empowered Organisations',
               'Empowered Leaders' =>'Empowered Leaders',
               'DIY Empowerment'=>'DIY Empowerment',
               'The 21st Century Manager'=>'The 21st Century Manager',
               'Routes to Discipline'=>'Routes to Discipline',
               'Laws and Rules'=>'Laws and Rules',
               'Non-Compliance'=>'Non-Compliance',
               'Problem Behaviour'=>'Problem Behaviour',
               'Fair and Full Investigation'=>'Fair and Full Investigation',
               'Alternatives to Discipline' =>'Alternatives to Discipline',
               'Disciplinary Policy and Procedure'=>'Disciplinary Policy and Procedure',
               'Counselling and Discipline'=>'Counselling and Discipline',
               'The Disciplinary Hearing'=>'The Disciplinary Hearing',
               'Fair Dismissal'=>'Fair Dismissal',
               'What is Personality?'=>'What is Personality?',
               'The Enneagram'=>'The Enneagram',
               'Ones, the Need to be Perfect'=>'Ones, the Need to be Perfect',
               'Twos, the Need to be Needed'=>'Twos, the Need to be Needed',
               'Threes, the Need to Succeed'=>'Threes, the Need to Succeed',
               'Fours, the Need to be Special'=>'Fours, the Need to be Special',
               'Fives, the Need to Perceive'=>'Fives, the Need to Perceive',
               'Sixes, the Need to be Safe' =>'Sixes, the Need to be Safe',
               'Sevens, the Need to be Happy'=>'Sevens, the Need to be Happy',
               'Eights, the Need to be Strong'=>'Eights, the Need to be Strong',
               'Nines, the Need to be at Peace'=>'Nines, the Need to be at Peace',
               'Managing Personality Types'=>'Managing Personality Types',
               'Twos, the Need to be Needed'=>'Twos, the Need to be Needed',
               'Threes, the Need to Succeed'=>'Threes, the Need to Succeed',
               'Fours, the Need to be Special'=>'Fours, the Need to be Special',
               'Fives, the Need to Perceive' =>'Fives, the Need to Perceive',
               'Sixes, the Need to be Safe'=>'Sixes, the Need to be Safe',
               'Sevens, the Need to be Happy'=>'Sevens, the Need to be Happy',
               'Eights, the Need to be Strong'=>'Eights, the Need to be Strong',
               'What is Facilitation?'=>'What is Facilitation?',
               'People and Groups'=>'People and Groups',
               'Facilitating the Start of Groupwork'=>'Facilitating the Start of Groupwork',
               'Control and Power in Facilitation'=>'Control and Power in Facilitation',
               'Empowering the Group'=>'Empowering the Group',
               'Overcoming the Blocks to Growth'=>'Overcoming the Blocks to Growth',
               'The Facilitators Toolkit'=>'The Facilitators Toolkit',
               'Overcoming the Blocks to Growth'=>'Overcoming the Blocks to Growth',
               'The Art of Non-Doing'=>'The Art of Non-Doing',
               'Group Energy'=>'Group Energy',
               'The Role of the Facilitator'=>'The Role of the Facilitator',
               'Group Endings and Separations'=>'Group Endings and Separations',
               'Influencing Skills' =>'Influencing Skills',
               'Negotiating Skills' =>'Negotiating Skills',
               'Preparing for Negotiations'=>'Preparing for Negotiations',
               'A Negotiation Game Plan'=>'A Negotiation Game Plan',
               'Power and Negotiations'=>'Power and Negotiations',
               'The Options in Conflict' =>'The Options in Conflict',
               'Making Your Case in Negotiations' =>'Making Your Case in Negotiations',
               'Stick to Your Guns in Negotiations'=>'Stick to Your Guns in Negotiations',
               'A Successful Negotiation'=>'A Successful Negotiation',
               'Agreement and After'=>'Agreement and After',
               'Management and Leadership'=>'Management and Leadership',
               'The Making of Leaders'=>'The Making of Leaders',
               'Leaders and Their Personalities'=>'Leaders and Their Personalities',
               'Mission, Vision, and Values'=>'Mission, Vision, and Values',
               'Organisational Culture'=>'Organisational Culture',
               'Leadership Styles'=>'Leadership Styles',
               'Master Communicators'=>'Master Communicators',
               'People Builders'=>'People Builders',
               'The Credibility of Leadership'=>'The Credibility of Leadership',
               'Leaders of the Future'=>'Leaders of the Future',
               'The Nature of Potential'=>'The Nature of Potential',
               'Self-Development'=>'Self-Development',
               'Know Yourself'=>'Know Yourself',
               'Goals and Goal-Setting'=>'Goals and Goal-Setting',
               'Programming Your Goals'=>'Programming Your Goals',
               'Super-Energy'=>'Super-Energy',
               'Action and Progress'=>'Action and Progress',
               'The 3lb Universe'=>'The 3lb Universe',
               'Positivity'=>'Positivity',
               'From Mastery to Mystery'=>'From Mastery to Mystery',
               'Goal-Setting'=>'Goal-Setting',
               'What is Performance Appraisal?'=>'What is Performance Appraisal?',
               'Performance Appraisal Schemes'=>'Performance Appraisal Schemes',
               'Assessing Performance'=>'Assessing Performance',
               'The Performance Appraisal Interview'=>'The Performance Appraisal Interview',
               'Managing the Under-Performer'=>'Managing the Under-Performer',
               'The Plateau-ed Performer'=>'The Plateau-ed Performer',
               'Managing the High Flyer'=>'Managing the High Flyer',
               'Constructive Feedback'=>'Constructive Feedback',
               'Play to their Strengths'=>'Play to their Strengths',
               'Outcomes of Appraisal'=>'Outcomes of Appraisal',
               'Play to their Strengths'=>'Play to their Strengths',
               'SUCCEED in Presentations'=>'SUCCEED in Presentations',
               'A Business Audience'=>'A Business Audience',
               'The Structure of Presentations'=>'The Structure of Presentations',
               'Preparing the Presentation'=>'Preparing the Presentation',
               'Presentation Techniques'=>'Presentation Techniques',
               'Using Your Voice'=>'Using Your Voice',
               'Visual Aids'=>'Visual Aids',
               'Body Language in Presentations'=>'Body Language in Presentations',
               'Overcoming Your Speaking Nerves'=>'Overcoming Your Speaking Nerves',
               'Mastering the Delivery'=>'Mastering the Delivery',
               'Approaches to Recruitment'=>'Approaches to Recruitment',
               'Being Fair in Recruitment'=>'Being Fair in Recruitment',
               'Policy and Procedure in Selection'=>'Policy and Procedure in Selection',
               'Groundwork for Hiring'=>'Groundwork for Hiring',
               'Filling the Vacancy'=>'Filling the Vacancy',
               'The Selection Interview'=>'The Selection Interview',
               'Selection Interview Skills'=>'Selection Interview Skills',
               'Go and No Go Questions'=>'Go and No Go Questions',
               'Tests and Assessments'=>'Tests and Assessments',
               'Selection and Appointment'=>'Selection and Appointment',
               'The Nature of Stress'=>'The Nature of Stress',
               'Stressors'=>'Stressors',
               'Coping with Stress'=>'Coping with Stress',
               'Managing the Physical'=>'Managing the Physical',
               'Stress Solutions'=>'Stress Solutions',
               'Managing Perceptions'=>'Managing Perceptions',
               'Managing Emotions'=>'Managing Emotions',
               'Managing Perspective'=>'Managing Perspective',
               'Focused Relaxation'=>'Focused Relaxation',
               'Stress-Busters'=>'Stress-Busters',
               'The Nature of Teams'=>'The Nature of Teams',
               'Team Development' =>'Team Development',
               'Teamwork'=>'Teamwork',
               'Team Cohesion'=>'Team Cohesion',
               'Threats to Teamwork'=>'Threats to Teamwork',
               'Team Leadership'=>'Team Leadership',
               'Team Roles'=>'Team Roles',
               'Team Meetings'=>'Team Meetings',
               'Unshared Certainty to Shared Uncertainty'=>'Unshared Certainty to Shared Uncertainty',
               'Teambuilders'=>'Teambuilders',
               'What Are Thinking Skills?'=>'What Are Thinking Skills?',
               'The Thoughts In Your Head'=>'The Thoughts In Your Head',
               'Memory, Concentration, and Imagination'=>'Memory, Concentration, and Imagination',
               'Blocks to Thinking'=>'Blocks to Thinking',
               'Reasoned Thinking'=>'Reasoned Thinking',
               'Creative Thinking'=>'Creative Thinking',
               'Brainstorming'=>'Brainstorming',
               'Decision-Taking'=>'Decision-Taking',
               'Problem-Solving'=>'Problem-Solving',
               'Innovation'=>'Innovation',
               'The Paradoxes of Time'=>'The Paradoxes of Time',
               'Working Time'=>'Working Time',
               'Models of Time Management'=>'Models of Time Management',
               'Routine Time'=>'Routine Time',
               'Time on Progress Work'=>'Time on Progress Work',
               'Time and Projects'=>'Time and Projects',
               'Non-Doing Work'=>'Non-Doing Work',
               'Time and Others'=>'Time and Others',
               'Time Travellers'=>'Time Travellers',
               'Personal Effectiveness'=>'Personal Effectiveness',
               'The Need for Training'=>'The Need for Training',
               'Managing Training'=>'Managing Training',
               'Models of Learning'=>'Models of Learning',
               'Designing Training'=>'Designing Training',
               'Running a Course'=>'Running a Course',
               'The Process of Training'=>'The Process of Training',
               'Groupwork and Training'=>'Groupwork and Training',
               'Learning Styles'=>'Learning Styles',
               'The Resourceful Trainer'=>'The Resourceful Trainer',
               'Evaluating Training'=>'Evaluating Training',
            
    
    
            ); 
            $question_topic_fill_in_the_blank = array(
                'What is Assertiveness?'=>'What is Assertiveness?',
                'The Origins of Assertiveness'=>'The Origins of Assertiveness',
                'Facets of Assertiveness'=>'Facets of Assertiveness',
                'Applications of Assertiveness'=>'Applications of Assertiveness',
                'Techniques of Assertiveness'=>'Techniques of Assertiveness',
                'Managing Assertively'=>'Managing Assertively',
                'Social Assertiveness'=>'Social Assertiveness',
                'Assertive Roles at Work'=>'Assertive Roles at Work',
                'Managing Your Boss Assertively'=>'Managing Your Boss Assertively',
                'Assertiveness Training'=>'Assertiveness Training',
                'What is Change Management?'=>'What is Change Management?',
                'Responding to Change'=>'Responding to Change',
                'Managing the Change Cycle'=>'Managing the Change Cycle',
                'Cores and Peripheries'=>'Cores and Peripheries',
                'Managing Paradox'=>'Managing Paradox',
                'Managing Risk in Times of Change'=>'Managing Risk in Times of Change',
                'Managing Learning in Times of Change'=>'Managing Learning in Times of Change',
                'The Process of Change'=>'The Process of Change',
                'Managing Uncertainty'=>'Managing Uncertainty',
                'Organisational Change'=>'Organisational Change',
                'Communications'=>'Communications',
                'Communication Strategies'=>'Communication Strategies',
                'Communication Networks'=>'Communication Networks',
                'The Means of Communication'=>'The Means of Communication',
                'Communication Barriers'=>'Communication Barriers',
                'Communication Styles'=>'Communication Styles',
                'The ABC of Writing'=>'The ABC of Writing',
                'The Art of Conversation'=>'The Art of Conversation',
                'Interpersonal Skills'=>'Interpersonal Skills',
                'Non-Verbal Communication'=>'Non-Verbal Communication',
                'The Counselling Approach'=>'The Counselling Approach',
                'Awareness, Acceptance, and Change'=>'Awareness, Acceptance, and Change',
                'Personal Growth'=>'Personal Growth',
                'The Dispositions of Counselling'=>'The Dispositions of Counselling',
                'The Counselling Interview'=>'The Counselling Interview',
                'The Art of Listening'=>'The Art of Listening',
                'Asking Questions'=>'Asking Questions',
                'Challenging and Closing Down'=>'Challenging and Closing Down',
                'Moving On'=>'Moving On',
                'People Problems'=>'People Problems',
                'What is Customer Care?'=>'What is Customer Care?',
                'Ichiban to Kaizen'=>'Ichiban to Kaizen',
                'Customer Focus'=>'Customer Focus',
                'The Customer Promise'=>'The Customer Promise',
                'Customer Champions'=>'Customer Champions',
                'Customer Feedback'=>'Customer Feedback',
                'Moments of Truth'=>'Moments of Truth',
                'Customer Relations'=>'Customer Relations',
                'Customer Complaints'=>'Customer Complaints',
                'Service Style'=>'Service Style',
                'From Directing to Delegating'=>'From Directing to Delegating',
                'Models of Management'=>'Models of Management',
                'Types of Delegating'=>'Types of Delegating',
                'Delegate to Develop'=>'Delegate to Develop',
                'Delegating as a Manager'=>'Delegating as a Manager',
                'Power and Empowerment'=>'Power and Empowerment',
                'Empowered Organisations'=>'Empowered Organisations',
                'Empowered Leaders'=>'Empowered Leaders',
                'DIY Empowerment'=>'DIY Empowerment',
                'The 21st Century Manager'=>'The 21st Century Manager',
                'Routes to Discipline'=>'Routes to Discipline',
                'Laws and Rules'=>'Laws and Rules',
                'Non-Compliance'=>'Non-Compliance',
                'Problem Behaviour'=>'Problem Behaviour',
                'Fair and Full Investigation'=>'Fair and Full Investigation',
                'Alternatives to Discipline'=>'Alternatives to Discipline',
                'Disciplinary Policy and Procedure'=>'Disciplinary Policy and Procedure',
                'Counselling and Discipline'=>'Counselling and Discipline',
                'The Disciplinary Hearing'=>'The Disciplinary Hearing',
                'Fair Dismissal'=>'Fair Dismissal',
                'What is Personality?'=>'What is Personality?',
                'The Enneagram'=>'The Enneagram',
                'Ones, the Need to be Perfect'=>'Ones, the Need to be Perfect',
                'Twos, the Need to be Needed'=>'Twos, the Need to be Needed',
                'Threes, the Need to Succeed'=>'Threes, the Need to Succeed',
                'Fours, the Need to be Special'=>'Fours, the Need to be Special',
                'Fives, the Need to Perceive'=>'Fives, the Need to Perceive',
                'Sixes, the Need to be Safe'=>'Sixes, the Need to be Safe',
                'Sevens, the Need to be Happy'=>'Sevens, the Need to be Happy',
                'Eights, the Need to be Strong'=>'Eights, the Need to be Strong',
                'Nines, the Need to be at Peace'=>'Nines, the Need to be at Peace',
                'Managing Personality Types'=>'Managing Personality Types',
                'What is Facilitation?'=>'What is Facilitation?',
                'People and Groups'=>'People and Groups',
                'Facilitating the Start of Groupwork'=>'Facilitating the Start of Groupwork',
                'Control and Power in Facilitation'=>'Control and Power in Facilitation',
                'Empowering the Group'=>'Empowering the Group',
                'The Facilitators Toolkit'=>'The Facilitators Toolkit',
                'Overcoming the Blocks to Growth'=>'Overcoming the Blocks to Growth',
                'The Art of Non-Doing'=>'The Art of Non-Doing',
                'Group Energy'=>'Group Energy',
                'Endings and Separations'=>'Endings and Separations',
                'Influencing Skills'=>'Influencing Skills',
                'Negotiating Skills'=>'Negotiating Skills',
                'Preparing for Negotiations'=>'Preparing for Negotiations',
                'A Negotiation Game Plan'=>'A Negotiation Game Plan',
                'Power and Negotiations'=>'Power and Negotiations',
                'The Options in Conflict'=>'The Options in Conflict',
                'Making Your Case in Negotiations'=>'Making Your Case in Negotiations',
                'Stick to Your Guns in Negotiations'=>'Stick to Your Guns in Negotiations',
                'A Successful Negotiation'=>'A Successful Negotiation',
                'Agreement and After'=>'Agreement and After',
                'Management and Leadership'=>'Management and Leadership',
                'The Making of Leaders'=>'The Making of Leaders',
                'Leaders and Their Personalities'=>'Leaders and Their Personalities',
                'Mission, Vision, and Values'=>'Mission, Vision, and Values',
                'Organisational Culture'=>'Organisational Culture',
                'Leadership Style'=>'Leadership Style',
                'Master Communicators'=>'Master Communicators',
                'People Builders'=>'People Builders',
                'The Credibility of Leaders'=>'The Credibility of Leaders',
                'Leaders of the Future'=>'Leaders of the Future',
                'The Nature of Potential'=>'The Nature of Potential',
                'Self-Development'=>'Self-Development',
                'Know Yourself'=>'Know Yourself',
                'Goals and Goal-Setting'=>'Goals and Goal-Setting',
                'Programming your Goals'=>'Programming your Goals',
                'Super-Energy'=>'Super-Energy',
                'Action and Progress'=>'Action and Progress',
                'The 3lb Universe'=>'The 3lb Universe',
                'Positivity'=>'Positivity',
                'From Mastery to Mystery'=>'From Mastery to Mystery',
                'What Is Appraisal?'=>'What Is Appraisal?',
                'Appraisal Schemes'=>'Appraisal Schemes',
                'Assessment'=>'Assessment',
                'The Appraisal Interview'=>'The Appraisal Interview',
                'Managing the Under-Performer'=>'Managing the Under-Performer',
                'The Plateau-ed Performer'=>'The Plateau-ed Performer',
                'Managing the High Flyer'=>'Managing the High Flyer',
                'Constructive Feedback'=>'Constructive Feedback',
                'Play to their Strengths'=>'Play to their Strengths',
                'Outcomes of Appraisal'=>'Outcomes of Appraisal',
                'SUCCEED in Presentations'=>'SUCCEED in Presentations',
                'A Business Audience'=>'A Business Audience',
                'The Structure of Presentations'=>'The Structure of Presentations',
                'Preparing the Presentation'=>'Preparing the Presentation',
                'Presentation Techniques'=>'Presentation Techniques',
                'Using Your Voice'=>'Using Your Voice',
                'Visual Aids'=>'Visual Aids',
                'Body Language in Presentations'=>'Body Language in Presentations',
                'Overcoming Your Speaking Nerves'=>'Overcoming Your Speaking Nerves',
                'Mastering the Delivery'=>'Mastering the Delivery',
                'Approaches to Recruitment'=>'Approaches to Recruitment',
                'Being Fair'=>'Being Fair',
                'Recruitment Policy and Procedure'=>'Recruitment Policy and Procedure',
                'Groundwork for Hiring'=>'Groundwork for Hiring',
                'Filling the Vacancy'=>'Filling the Vacancy',
                'The Selection Interview'=>'The Selection Interview',
                'Selection Interview Skills'=>'Selection Interview Skills',
                'Go and No Go Questions'=>'Go and No Go Questions',
                'Tests and Assessments'=>'Tests and Assessments',
                'Selection and Appointment'=>'Selection and Appointment',
                'The Nature of Stress'=>'The Nature of Stress',
            
                'Stressors'=>'Stressors',
                'Coping with Stress'=>'Coping with Stress',
                'Stress and the Physical Response'=>'Stress and the Physical Response',
                'Stress Solutions'=>'Stress Solutions',
                'Managing Perceptions'=>'Managing Perceptions',
                'Managing Emotions'=>'Managing Emotions',
                'Putting Things into Perspective'=>'Putting Things into Perspective',
                'Focused Relaxation'=>'Focused Relaxation',
                'Stress-Busters'=>'Stress-Busters',
                'The Nature of Teams'=>'The Nature of Teams',
                'Team Development'=>'Team Development',
                'Teamwork'=>'Teamwork',
                'Team Cohesion'=>'Team Cohesion',
                'Threats to Teamwork'=>'Threats to Teamwork',
                'Team Leadership'=>'Team Leadership',
                'Team Roles'=>'Team Roles',
                'Team Meetings'=>'Team Meetings',
                'Unshared Certainty to Shared Uncertainty'=>'Unshared Certainty to Shared Uncertainty',
                'Teambuilders'=>'Teambuilders',
                'What are Thinking Skills?'=>'What are Thinking Skills?',
                'The Thoughts In Your Head'=>'The Thoughts In Your Head',
                'Memory, Concentration, and Imagination'=>'Memory, Concentration, and Imagination',
                'Blocks to Thinking'=>'Blocks to Thinking',
                'Reasoned Thinking'=>'Reasoned Thinking',
                'Creative Thinking'=>'Creative Thinking',
                'Brainstorming'=>'Brainstorming',
                'Decision-Taking'=>'Decision-Taking',
                'Problem-Solving'=>'Problem-Solving',
                'Innovation'=>'Innovation',
                'The Paradoxes of Time'=>'The Paradoxes of Time',
                'Working Time'=>'Working Time',
                'Models of Time Management'=>'Models of Time Management',
                'Routine Time'=>'Routine Time',
                'Time on Progress Work'=>'Time on Progress Work',
                'Time and Projects'=>'Time and Projects',
                'Non-Doing Work'=>'Non-Doing Work',
                'Time and Others'=>'Time and Others',
                'Time Travellers'=>'Time Travellers',
                'The Effective Time Manager'=>'The Effective Time Manager',
                'The Need for Training'=>'The Need for Training',
                'Managing Training'=>'Managing Training',
                'Models of Learning'=>'Models of Learning',
                'Designing Training'=>'Designing Training',
                'Running a Course'=>'Running a Course',
                'The Process of Training'=>'The Process of Training',
                'Groupwork and Training'=>'Groupwork and Training',
                'Learning Styles'=>'Learning Styles',
                'The Resourceful Trainer'=>'The Resourceful Trainer',
                'Evaluating Training'=>'Evaluating Training',
                'Assertiveness'=>'Assertiveness',
                'Change Management'=>'Change Management',
                'Communications'=>'Communications',
                'Counselling Skills'=>'Counselling Skills',
                'Customer Care'=>'Customer Care',
                'Delegation and Empowerment'=>'Delegation and Empowerment',
                'Effective Discipline'=>'Effective Discipline',
                'Enneagram Personality Types'=>'Enneagram Personality Types',
                'Facilitation Skills'=>'Facilitation Skills',
                'Influencing and Negotiating Skills'=>'Influencing and Negotiating Skills',
                'Leadership Skills'=>'Leadership Skills',
                'Maximising Your Potential'=>'Maximising Your Potential',
                'Performance Management and Appraisal'=>'Performance Management and Appraisal',
                'Presentation Skills'=>'Presentation Skills',
                'Recruitment and Selection'=>'Recruitment and Selection',
                'Stress Management'=>'Stress Management',
                'Teambuilding'=>'Teambuilding',
                'Thinking Skills'=>'Thinking Skills',
                'Time Management'=>'Time Management',
                'Training Skills'=>'Training Skills',
                       );
                       $number_question_topic = array(
                        'Assertiveness'=>'Assertiveness',
                'Change Management'=>'Change Management',
                'Communications'=>'Communications',
                'Counselling Skills'=>'Counselling Skills',
                'Customer Care'=>'Customer Care',
                'Delegation and Empowerment'=>'Delegation and Empowerment',
                'Effective Discipline'=>'Effective Discipline',
                'Enneagram Personality Types'=>'Enneagram Personality Types',
                'Facilitation Skills'=>'Facilitation Skills',
                'Influencing and Negotiating Skills'=>'Influencing and Negotiating Skills',
                'Leadership Skills'=>'Leadership Skills',
                'Maximising Your Potential'=>'Maximising Your Potential',
                'Performance Management and Appraisal'=>'Performance Management and Appraisal',
                'Presentation Skills'=>'Presentation Skills',
                'Recruitment and Selection'=>'Recruitment and Selection',
                'Stress Management'=>'Stress Management',
                'Teambuilding'=>'Teambuilding',
                'Thinking Skills'=>'Thinking Skills',
                'Time Management'=>'Time Management',
                'Training Skills'=>'Training Skills',
                    );   
                    $question_topic_true_and_false = array(
                        'What is Assertiveness?'=>'What is Assertiveness?',
                        'The Origins of Assertiveness'=>'The Origins of Assertiveness',
                        'Facets of Assertiveness'=>'Facets of Assertiveness',
                        'Applications of Assertiveness'=>'Applications of Assertiveness',
                        'Techniques of Assertiveness'=>'Techniques of Assertiveness',
                        'Managing Assertively'=>'Managing Assertively',
                        'Social Assertiveness'=>'Social Assertiveness',
                        'Assertive Roles at Work'=>'Assertive Roles at Work',
                        'Managing Your Boss Assertively'=>'Managing Your Boss Assertively',
                        'Assertiveness Training'=>'Assertiveness Training',
                        'What is Change Management?'=>'What is Change Management?',
                        'Responding to Change'=>'Responding to Change',
                        'Managing the Change Cycle'=>'Managing the Change Cycle',
                        'Cores and Peripheries'=>'Cores and Peripheries',
                        'Managing Paradox'=>'Managing Paradox',
                        'Managing Risk in Times of Change'=>'Managing Risk in Times of Change',
                        'Managing Learning in Times of Change'=>'Managing Learning in Times of Change',
                        'The Process of Change'=>'The Process of Change',
                        'Managing Uncertainty'=>'Managing Uncertainty',
                        'Organisational Change'=>'Organisational Change',
                        'Communications'=>'Communications',
                        'Communication Strategies'=>'Communication Strategies',
                        'Communication Networks'=>'Communication Networks',
                        'The Means of Communication'=>'The Means of Communication',
                        'Communication Barriers'=>'Communication Barriers',
                        'Communication Styles'=>'Communication Styles',
                        'The ABC of Writing'=>'The ABC of Writing',
                        'The Art of Conversation'=>'The Art of Conversation',
                        'Interpersonal Skills'=>'Interpersonal Skills',
                        'Non-Verbal Communication'=>'Non-Verbal Communication',
                        'The Counselling Approach'=>'The Counselling Approach',
                        'Awareness, Acceptance, and Change'=>'Awareness, Acceptance, and Change',
                        'Personal Growth'=>'Personal Growth',
                        'The Dispositions of Counselling'=>'The Dispositions of Counselling',
                        'The Counselling Interview'=>'The Counselling Interview',
                        'The Art of Listening'=>'The Art of Listening',
                        'Asking Questions'=>'Asking Questions',
                        'Challenging and Closing Down'=>'Challenging and Closing Down',
                        'Moving On'=>'Moving On',
                        'People Problems'=>'People Problems',
                        'What is Customer Care?'=>'What is Customer Care?',
                        'Ichiban to Kaizen'=>'Ichiban to Kaizen',
                        'Customer Focus'=>'Customer Focus',
                        'The Customer Promise'=>'The Customer Promise',
                        'Customer Champions'=>'Customer Champions',
                        'Customer Feedback'=>'Customer Feedback',
                        'Moments of Truth'=>'Moments of Truth',
                        'Customer Relations'=>'Customer Relations',
                        'Customer Complaints'=>'Customer Complaints',
                        'Service Style'=>'Service Style',
                        'From Directing to Delegating'=>'From Directing to Delegating',
                        'Models of Management'=>'Models of Management',
                        'Types of Delegating'=>'Types of Delegating',
                        'Delegate to Develop'=>'Delegate to Develop',
                        'Delegating as a Manager'=>'Delegating as a Manager',
                        'Power and Empowerment'=>'Power and Empowerment',
                        'Empowered Organisations'=>'Empowered Organisations',
                        'Empowered Leaders'=>'Empowered Leaders',
                        'DIY Empowerment'=>'DIY Empowerment',
                        'The 21st Century Manager'=>'The 21st Century Manager',
                        'Routes to Discipline'=>'Routes to Discipline',
                        'Laws and Rules'=>'Laws and Rules',
                        'Non-Compliance'=>'Non-Compliance',
                        'Problem Behaviour'=>'Problem Behaviour',
                        'Fair and Full Investigation'=>'Fair and Full Investigation',
                        'Alternatives to Discipline'=>'Alternatives to Discipline',
                        'Disciplinary Policy and Procedure'=>'Disciplinary Policy and Procedure',
                        'Counselling and Discipline'=>'Counselling and Discipline',
                        'The Disciplinary Hearing'=>'The Disciplinary Hearing',
                        'Fair Dismissal'=>'Fair Dismissal',
                        'What is Personality?'=>'What is Personality?',
                        'The Enneagram'=>'The Enneagram',
                        'Ones, the Need to be Perfect'=>'Ones, the Need to be Perfect',
                        'Twos, the Need to be Needed'=>'Twos, the Need to be Needed',
                        'Threes, the Need to Succeed'=>'Threes, the Need to Succeed',
                        'Fours, the Need to be Special'=>'Fours, the Need to be Special',
                        'Fives, the Need to Perceive'=>'Fives, the Need to Perceive',
                        'Sixes, the Need to be Safe'=>'Sixes, the Need to be Safe',
                        'Sevens, the Need to be Happy'=>'Sevens, the Need to be Happy',
                        'Eights, the Need to be Strong'=>'Eights, the Need to be Strong',
                        'Nines, the Need to be at Peace'=>'Nines, the Need to be at Peace',
                        'Managing Personality Types'=>'Managing Personality Types',
                        'What is Facilitation?'=>'What is Facilitation?',
                        'People and Groups'=>'People and Groups',
                        'Facilitating the Start of Groupwork'=>'Facilitating the Start of Groupwork',
                        'Control and Power in Facilitation'=>'Control and Power in Facilitation',
                        'Empowering the Group'=>'Empowering the Group',
                        'The Facilitators Toolkit'=>'The Facilitators Toolkit',
                        'Overcoming the Blocks to Growth'=>'Overcoming the Blocks to Growth',
                        'The Art of Non-Doing'=>'The Art of Non-Doing',
                        'Group Energy'=>'Group Energy',
                        'Endings and Separations'=>'Endings and Separations',
                        'Influencing Skills'=>'Influencing Skills',
                        'Negotiating Skills'=>'Negotiating Skills',
                        'Preparing for Negotiations'=>'Preparing for Negotiations',
                        'A Negotiation Game Plan'=>'A Negotiation Game Plan',
                        'Power and Negotiations'=>'Power and Negotiations',
                        'The Options in Conflict'=>'The Options in Conflict',
                        'Making Your Case in Negotiations'=>'Making Your Case in Negotiations',
                        'Stick to Your Guns in Negotiations'=>'Stick to Your Guns in Negotiations',
                        'A Successful Negotiation'=>'A Successful Negotiation',
                        'Agreement and After'=>'Agreement and After',
                        'Management and Leadership'=>'Management and Leadership',
                        'The Making of Leaders'=>'The Making of Leaders',
                        'Leaders and Their Personalities'=>'Leaders and Their Personalities',
                        'Mission, Vision, and Values'=>'Mission, Vision, and Values',
                        'Organisational Culture'=>'Organisational Culture',
                        'Leadership Style'=>'Leadership Style',
                        'Master Communicators'=>'Master Communicators',
                        'People Builders'=>'People Builders',
                        'The Credibility of Leaders'=>'The Credibility of Leaders',
                        'Leaders of the Future'=>'Leaders of the Future',
                        'The Nature of Potential'=>'The Nature of Potential',
                        'Self-Development'=>'Self-Development',
                        'Know Yourself'=>'Know Yourself',
                        'Goals and Goal-Setting'=>'Goals and Goal-Setting',
                        'Programming your Goals'=>'Programming your Goals',
                        'Super-Energy'=>'Super-Energy',
                        'Action and Progress'=>'Action and Progress',
                        'The 3lb Universe'=>'The 3lb Universe',
                        'Positivity'=>'Positivity',
                        'From Mastery to Mystery'=>'From Mastery to Mystery',
                        'What Is Appraisal?'=>'What Is Appraisal?',
                        'Appraisal Schemes'=>'Appraisal Schemes',
                        'Assessment'=>'Assessment',
                        'The Appraisal Interview'=>'The Appraisal Interview',
                        'Managing the Under-Performer'=>'Managing the Under-Performer',
                        'The Plateau-ed Performer'=>'The Plateau-ed Performer',
                        'Managing the High Flyer'=>'Managing the High Flyer',
                        'Constructive Feedback'=>'Constructive Feedback',
                        'Play to their Strengths'=>'Play to their Strengths',
                        'Outcomes of Appraisal'=>'Outcomes of Appraisal',
                        'SUCCEED in Presentations'=>'SUCCEED in Presentations',
                        'A Business Audience'=>'A Business Audience',
                        'The Structure of Presentations'=>'The Structure of Presentations',
                        'Preparing the Presentation'=>'Preparing the Presentation',
                        'Presentation Techniques'=>'Presentation Techniques',
                        'Using Your Voice'=>'Using Your Voice',
                        'Visual Aids'=>'Visual Aids',
                        'Body Language in Presentations'=>'Body Language in Presentations',
                        'Overcoming Your Speaking Nerves'=>'Overcoming Your Speaking Nerves',
                        'Mastering the Delivery'=>'Mastering the Delivery',
                        'Approaches to Recruitment'=>'Approaches to Recruitment',
                        'Being Fair'=>'Being Fair',
                        'Recruitment Policy and Procedure'=>'Recruitment Policy and Procedure',
                        'Groundwork for Hiring'=>'Groundwork for Hiring',
                        'Filling the Vacancy'=>'Filling the Vacancy',
                        'The Selection Interview'=>'The Selection Interview',
                        'Selection Interview Skills'=>'Selection Interview Skills',
                        'Go and No Go Questions'=>'Go and No Go Questions',
                        'Tests and Assessments'=>'Tests and Assessments',
                        'Selection and Appointment'=>'Selection and Appointment',
                        'The Nature of Stress'=>'The Nature of Stress',
                        'Stressors'=>'Stressors',
                        'Coping with Stress'=>'Coping with Stress',
                        'Stress and the Physical Response'=>'Stress and the Physical Response',
                        'Stress Solutions'=>'Stress Solutions',
                        'Managing Perceptions'=>'Managing Perceptions',
                        'Managing Emotions'=>'Managing Emotions',
                        'Putting Things into Perspective'=>'Putting Things into Perspective',
                        'Focused Relaxation'=>'Focused Relaxation',
                        'Stress-Busters'=>'Stress-Busters',
                        'The Nature of Teams'=>'The Nature of Teams',
                        'Team Development'=>'Team Development',
                        'Teamwork'=>'Teamwork',
                        'Team Cohesion'=>'Team Cohesion',
                        'Threats to Teamwork'=>'Threats to Teamwork',
                        'Team Leadership'=>'Team Leadership',
                        'Team Roles'=>'Team Roles',
                        'Team Meetings'=>'Team Meetings',
                        'Unshared Certainty to Shared Uncertainty'=>'Unshared Certainty to Shared Uncertainty',
                        'Teambuilders'=>'Teambuilders',
                        'What are Thinking Skills?'=>'What are Thinking Skills?',
                        'The Thoughts In Your Head'=>'The Thoughts In Your Head',
                        'Memory, Concentration, and Imagination'=>'Memory, Concentration, and Imagination',
                        'Blocks to Thinking'=>'Blocks to Thinking',
                        'Reasoned Thinking'=>'Reasoned Thinking',
                        'Creative Thinking'=>'Creative Thinking',
                        'Brainstorming'=>'Brainstorming',
                        'Decision-Taking'=>'Decision-Taking',
                        'Problem-Solving'=>'Problem-Solving',
                        'Innovation'=>'Innovation',
                        'The Paradoxes of Time'=>'The Paradoxes of Time',
                        'Working Time'=>'Working Time',
                        'Models of Time Management'=>'Models of Time Management',
                        'Routine Time'=>'Routine Time',
                        'Time on Progress Work'=>'Time on Progress Work',
                        'Time and Projects'=>'Time and Projects',
                        'Non-Doing Work'=>'Non-Doing Work',
                        'Time and Others'=>'Time and Others',
                        'Time Travellers'=>'Time Travellers',
                        'The Effective Time Manager'=>'The Effective Time Manager',
                        'The Need for Training'=>'The Need for Training',
                        'Managing Training'=>'Managing Training',
                        'Models of Learning'=>'Models of Learning',
                        'Designing Training'=>'Designing Training',
                        'Running a Course'=>'Running a Course',
                        'The Process of Training'=>'The Process of Training',
                        'Groupwork and Training'=>'Groupwork and Training',
                        'Learning Styles'=>'Learning Styles',
                        'The Resourceful Trainer'=>'The Resourceful Trainer',
                        'Evaluating Training'=>'Evaluating Training',
                        'Assertiveness'=>'Assertiveness',
                        'Change Management'=>'Change Management',
                        'Communications'=>'Communications',
                        'Counselling Skills'=>'Counselling Skills',
                        'Customer Care'=>'Customer Care',
                        'Delegation and Empowerment'=>'Delegation and Empowerment',
                        'Effective Discipline'=>'Effective Discipline',
                        'Enneagram Personality Types'=>'Enneagram Personality Types',
                        'Facilitation Skills'=>'Facilitation Skills',
                        'Influencing and Negotiating Skills'=>'Influencing and Negotiating Skills',
                        'Leadership Skills'=>'Leadership Skills',
                        'Maximising Your Potential'=>'Maximising Your Potential',
                        'Performance Management and Appraisal'=>'Performance Management and Appraisal',
                        'Presentation Skills'=>'Presentation Skills',
                        'Recruitment and Selection'=>'Recruitment and Selection',
                        'Stress Management'=>'Stress Management',
                        'Teambuilding'=>'Teambuilding',
                        'Thinking Skills'=>'Thinking Skills',
                        'Time Management'=>'Time Management',
                        'Training Skills'=>'Training Skills',
                               );              
                    $question_topic_either_or =  array (
                                'Performance Management and Appraisal' => 'Performance Management and Appraisal',
                                'Assertivenes' => 'Assertiveness',
                                'Change Management' => 'Change Management',
                                'Meeting Skills' => 'Meeting Skills',
                                'Asking Questions' => 'Asking Questions',
                                'Customer Complaints' => 'Customer Complaints',
                                'Customer Service' => 'Customer Service',
                                'Empowered Organisations'=> 'Empowered Organisations',
                                'Effective Discipline' => 'Effective Discipline',
                                'Enneagram Personality Types' => 'Enneagram Personality Types',
                                'Facilitation Skills' => 'Facilitation Skills',
                                'Influencing and Negotiating Skills' => 'Influencing and Negotiating Skills',
                                'Leadership Skills' => 'Leadership Skills',
                                'Know Yourself' => 'Know Yourself',
                                'Presentation Skills' => 'Presentation Skills',
                                'The Person Specification' => 'The Person Specification',
                                'Recruitment and Selection' => 'Recruitment and Selection',
                                'Recruitment Policy and Procedure' => 'Recruitment Policy and Procedure',
                                'Stress Management' => 'Stress Management',
                                'Teambuilding' => 'Teambuilding',
                                'Thinking Skills' => 'Thinking Skills',
                                'Time Management' => 'Time Management',
                                'Training Skills'=> 'Training Skills',
                    );
                    $question_topic_six_of_best = array (
                        'Appraisal Schemes' => 'Appraisal Schemes',
                         'The Appraisal Interview' => 'The Appraisal Interview',
                         'Constructive Feedback'=> 'Constructive Feedback',
                         'Outcomes of Appraisal' => 'Outcomes of Appraisal',
                         'The Assertive Manager' => 'The Assertive Manager',
                        'What is Change Management?' => 'What is Change Management?',
                         'Cores and Peripheries' => 'Cores and Peripheries',
                         'Smart Reading' => 'Smart Reading',
                         'The Counselling Approach' => 'The Counselling Approach',
                         'The Counselling Interview'=> 'The Counselling Interview',
                        'The Art of Listening' => 'The Art of Listening',
                         'Moving on from Counselling' => 'Moving on from Counselling',
                        'The Customer Promise' => 'The Customer Promise',
                         'Empowered Organisations' => 'Empowered Organisations',
                         'Delegating as a Manager' => 'Delegating as a Manager',
                         'Organisational Structures' => 'Organisational Structures',
                         'Empowered Organisations'=> 'Empowered Organisations',
                        'Empowering Leaders' => 'Empowering Leaders',
                         'Laws and Rules'=> 'Laws and Rules',
                         'Fair and Full Investigation' => 'Fair and Full Investigation',
                         'Alternatives to Discipline' => 'Alternatives to Discipline',
                         'Disciplinary Policy and Procedure' => 'Disciplinary Policy and Procedure',
                         'The Difficult Conversation'=> 'The Difficult Conversation',
                         'The Disciplinary Hearing'=> 'The Disciplinary Hearing',
                         'Managing Personality Types' => 'Managing Personality Types',
                        'What is Facilitation?' => 'What is Facilitation?',
                         'Empowering the Group' => 'Empowering the Group',
                       'Control and Power in Facilitation'=> 'Control and Power in Facilitation',
                         'Group Energy' => 'Group Energy',
                         'Influencing Skills' => 'Influencing Skills',
                        'Power and Negotiations'=> 'Power and Negotiations',
                        'Management and Leadership' => 'Management and Leadership',
                         'Mission, Vision, and Values' => 'Mission, Vision, and Values',
                       'Organisational Culture' => 'Organisational Culture',
                         'Leadership Styles' => 'Leadership Styles',
                         'People Builders' => 'People Builders',
                         'The Nature of Potential'=> 'The Nature of Potential',
                         'From Mastery to Mystery' => 'From Mastery to Mystery',
                        'Body Language in Presentations'=> 'Body Language in Presentations',
                         'Selection Interview Skills' => 'Selection Interview Skills',
                         'Putting Things into Perspective' => 'Putting Things into Perspective',
                         'Focused Relaxation'=> 'Focused Relaxation',
                         'Teamwork' => 'Teamwork',
                        'The Nature of Teams' => 'The Nature of Teams',
                         'Reasoned Thinking' => 'Reasoned Thinking',
                        'Working Time' => 'Working Time',
                         'Routine Time' => 'Routine Time',
                         'Time on Progress Work' => 'Time on Progress Work',
                        'Non-Doing Work' => 'Non-Doing Work',
                         'Time and Others'=> 'Time and Others',
                         'Designing Training' => 'Designing Training',
                       );  
                       $question_topic_sequence= array (
                        'Conflict Resolution' => 'Conflict Resolution',
                        'Alternative Conflict Resolution'=> 'Alternative Conflict Resolution',
                       'The Kubler-Ross Model of Change' => 'The Kubler-Ross Model of Change',
                       'Natural Change' => 'Natural Change',
                       'Persuasion' => 'Persuasion',
                       'The Communications Loop' => 'The Communications Loop',
                       'An Interpersonal Exchange' => 'An Interpersonal Exchange',
                        'A Counselling Session' => 'A Counselling Session',
                        'Resolving a Customer Complaint' => 'Resolving a Customer Complaint',
                       'Progressive Levels of Responsibility' => 'Progressive Levels of Responsibility',
                        'Levels of Freedom' => 'Levels of Freedom',
                        'What People Want from their Leaders' => 'What People Want from their Leaders',
                        'Disciplinary Procedure' => 'Disciplinary Procedure',
                        'Counselling' => 'Counselling',
                       'Disciplinary Hearing' => 'Disciplinary Hearing',
                         'The Business Cycle' => 'The Business Cycle',
                        'Group Workshops' => 'Group Workshops',
                       'Power Negotiations'=> 'Power Negotiations',
                        'Transformational Leadership' => 'Transformational Leadership',
                        'Stages of Change' => 'Stages of Change',
                       'Leadership Skills' => 'Leadership Skills',
                        'Goals and Goal-Setting' => 'Goals and Goal-Setting',
                        'Constructive Feedback' => 'Constructive Feedback',
                        'The Appraisal Interview' => 'The Appraisal Interview',
                       'Logorrophobia' => 'Logorrophobia',
                        'Top 10 Job Requirement Skills'=> 'Top 10 Job Requirement Skills',
                       'The Recruitment Cycle' => 'The Recruitment Cycle',
                        'Selection Techniques' => 'Selection Techniques',
                        'Shortlisting' => 'Shortlisting',
                        'Job Advertisement' => 'Job Advertisement',
                        'Recruitment Interview'=> 'Recruitment Interview',
                        'Stressful Life Events' => 'Stressful Life Events',
                        'Team Meetings' => 'Team Meetings',
                        'Team Meetings' => 'Team Meetings',
                        'Building a Team' => 'Building a Team',
                        'Tuckmans Team Development Model' => 'Tuckmans Team Development Model',
                        'Stages of Team Dependence' => 'Stages of Team Dependence',
                        'Visualisation' => 'Visualisation',
                         'Classic Problem-Solving'=> 'Classic Problem-Solving',
                        'Task Prioritisation' => 'Task Prioritisation',
                       'The Project Life Cycle' => 'The Project Life Cycle',
                       'The Conscious-Competence Ladder' => 'The Conscious-Competence Ladder',
                       'Giving Instructions' => 'Giving Instructions',
                        'Kolbs Experiential Learning Model'=> 'Kolbs Experiential Learning Model',
                       'John Whitmore Coaching Model'=> 'John Whitmore Coaching Model',
                       'GROW Coaching Model' => 'GROW Coaching Model',
                       
                      ); 
                      $question_topic_matching_item = array (
                        'What is Appraisal?' => 'What is Appraisal?',
                       'Assessment'=> 'Assessment',
                       'Managing the Under-Performer' => 'Managing the Under-Performer',
                        'Performance Management and Appraisal' => 'Performance Management and Appraisal',
                       'The Plateau-ed Performer' => 'The Plateau-ed Performer',
                        'Outcomes of Appraisal' => 'Outcomes of Appraisal',
                        'Facets of Assertiveness' => 'Facets of Assertiveness',
                         'Applications of Assertiveness' => 'Applications of Assertiveness',
                        'Techniques of Assertiveness' => 'Techniques of Assertiveness',
                        'The Assertive Manager'=> 'The Assertive Manager',
                        'The Process of Change' => 'The Process of Change',
                       'Organisational Change' => 'Organisational Change',
                        'Communication Strategies' => 'Communication Strategies',
                        'The Means of Communication' => 'The Means of Communication',
                         'Communication Barriers' => 'Communication Barriers',
                        'The Art of Conversation' => 'The Art of Conversation',
                         'Interpersonal Skills' => 'Interpersonal Skills',
                        'Non-Verbal Communication' => 'Non-Verbal Communication',
                        'The Counselling Approach' => 'The Counselling Approach',
                       'Awareness, Acceptance, and Change' => 'Awareness, Acceptance, and Change',
                        'Personal Growth'=> 'Personal Growth',
                         'The Counselling Interview' => 'The Counselling Interview',
                        'The Art of Listening' => 'The Art of Listening',
                        'Asking Questions' => 'Asking Questions',
                       'People Problems'=> 'People Problems',
                        'Customer Care' => 'Customer Care',
                        'Delegation and Empowerment' => 'Delegation and Empowerment',
                      'Effective Discipline'=> 'Effective Discipline',
                       'Enneagram Personality Types'=> 'Enneagram Personality Types',
                        'Facilitation Skills'=> 'Facilitation Skills',
                      'Influencing and Negotiating Skills' => 'Influencing and Negotiating Skills',
                       'Leadership Skills'=> 'Leadership Skills',
                        'Maximising Your Potential'=> 'Maximising Your Potential',
                        'Presentation Skills'=> 'Presentation Skills',
                        'Recruitment and Selection' => 'Recruitment and Selection',
                         'Stress Management' => 'Stress Management',
                       'Teambuilding' => 'Teambuilding',
                        'Thinking Skills' => 'Thinking Skills',
                        'Time Management' => 'Time Management',
                        'Training Skills' => 'Training Skills',
                        'Performance Management and Appraisal'=> 'Performance Management and Appraisal',
                        'Assertiveness' => 'Assertiveness',
                        'Change Management' => 'Change Management',
                        'Communications' => 'Communications',
                        'Counselling Skills'=> 'Counselling Skills',
                      );                                                                     
        //print_r($question_data); die;
        return view('backend.questions.edit',compact('question_data','options_arry','questiontype_array','questioncat_array','question_topics_multi_choice','question_topics_flash_card','question_topic_fill_in_the_blank','number_question_topic','question_topic_true_and_false','question_topic_either_or','question_topic_six_of_best','question_topic_sequence','question_topic_matching_item'));
    }

    public function updateQuestion(Request $request,$id){

        $validator = Validator::make($request->all(), [
            'question_title' => 'required',
            'question_topic'=> 'required',
            'question_instructions'=> 'required',
            'question_category'=> 'required',
             
        ]);
 
        if ($validator->fails()) {
            return  redirect()->back() ->withErrors($validator)
            ->withInput();
          
        }
           $data = array();
           $data['question_title'] = $request->question_title;
           $data['question_topic'] = $request->question_topic;
           $data['question_instructions'] = $request->question_instructions;
           $data['right_answer'] = $request->right_answer;
           $data['question_category'] = $request->question_category;
           Question::where('id',$id)->update($data);
           return  redirect('backend/questions/all')->with('success','Question data updated successfully');

        $question_data = Question::where('id',$id)->first();
        
        return view('backend.questions.update',compact('question_data'));

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id) {
        $question=Question::find($id);
         $question->delete($id);
            return  redirect('backend/questions/all')->with('success','Question has been deleted successfully');
               
    }
    
    
}
