<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\User;
#use App\Models\Game;
#use App\Models\Usergameinfo;
#use DataTables;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

use Auth;

class UsersController extends Controller {

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request) {
        $user_status_array = array('' => 'Please Select', 1 => 'Online', 2 => 'Offline');
        $userStatusList = array('' => __('messages.Please Select'), 1 => __('messages.Active'), 2 => __('messages.Blocked'));
        return view('backend.users.index', compact('user_status_array', 'userStatusList'));
    }
	
	/**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function onlineUsers(Request $request) {
        $user_status_array = array('' => 'Please Select', 1 => 'Online', 2 => 'Offline');
        $userStatusList = array('' => __('messages.Please Select'), 1 => __('messages.Active'), 2 => __('messages.Blocked'));
        return view('backend.users.onlineuser', compact('user_status_array', 'userStatusList'));
    }
	
	/**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function offlineUsers(Request $request) {
        $user_status_array = array('' => 'Please Select', 1 => 'Online', 2 => 'Offline');
        $userStatusList = array('' => __('messages.Please Select'), 1 => __('messages.Active'), 2 => __('messages.Blocked'));
        return view('backend.users.offlineuser', compact('user_status_array', 'userStatusList'));
    }

    /**
     * Display the specified resource by ajax request.
     *
     * @param  \App\Models\Configuration  $user
     * @return \Illuminate\Http\Response
     */
    public function getUser(Request $request) {
        $order_by = array();
        $length = $request->length;
        $start = $request->start;
        $columnData = array(
            '#',
            'firstName',
            'lastName',
            'email',
            'mobileNo',
            'isProfileUpdated',
            'created_at',
            'action'
        );
        $sortData = $request->order;
        $order_by[0] = $columnData[$sortData[0]['column']];
        $order_by[1] = $sortData[0]['dir'];
        $searchData = $request->searchBox;

        $totalData = User::count();

        $totalFiltered = $totalData;
        $jsonArray = array(
            'draw' => $request->draw,
            'recordsTotal' => $totalData,
            'recordsFiltered' => $totalData,
            'data' => array(),
        );

        $userQuery = User::select('id', 'firstName', 'lastName', 'email', 'mobileNo', 'created_at', 'isProfileUpdated')
		->Where('isAdmin', 0);
        
        if ($request->userIsOnline) {
            $userIsOnline = $request->userIsOnline;
            $userQuery->Where('userIsOnline', $userIsOnline);
        }
		
        if (!empty($request->searchBox)) {
            $search = $request->searchBox;
            $userQuery->where(function ($q) use ($search) {
                $q->Where('id', 'LIKE', "%{$search}%")
                        ->orWhere('firstName', 'LIKE', "%{$search}%")
                        ->orWhere('lastName', 'LIKE', "%{$search}%")
                        ->orWhere('email', 'LIKE', "%{$search}%")
                        ->orWhere('mobileNo', 'LIKE', "%{$search}%")
                        ->orWhere('created_at', 'LIKE', "%{$search}%");
            });
        }
        $totalFiltered = $userQuery->count();
        $users = $userQuery->offset($start)
                ->limit($length)
                ->orderBy($order_by[0], $order_by[1])
                ->get();

        $data = array();

        if (!empty($users)) {
            $btn = '';
            foreach ($users as $key => $user) {
                $btn = '<a href="' . url("/backend/users/" . $user->id . "/edit") . '" data-toggle="tooltip" data-id="' . $user->id . '" data-original-title="Edit" title="' . __('messages.Edit') . '" class="edit btn btn-primary btn-sm"><i class="fa fa-edit" title="' . __('messages.Edit') . '"></i></a>';
                $btn = ($user->id != \Illuminate\Support\Facades\Auth::user()->id) ? $btn . ' <a href="javascript:void(0);" data-token="' . csrf_token() . '" rel="' . $user->id . '" class="btn btn-danger btn-sm deleteRecord" title="' . __('messages.Delete') . '"><i class="fa fa-trash-o deleteRecord" rel="' . $user->id . '" title="' . __('messages.Delete') . '"></i></a>' : $btn . '';
                $btn = $btn.' <a href="'.url("/backend/users/referal/".$user->id).'" target="_blank" data-toggle="tooltip" data-id="'.$user->id.'" data-original-title="Referral" title="'.'Referral'.'" class="edit btn btn-primary btn-sm"><i class="fa fa-user" title="'.'Referral'.'"></i></a>';
				$nestedData['sr_no'] = $start + $key + 1;
                $nestedData['firstName'] = $user->firstName;
                $nestedData['lastName'] = $user->lastName;
                $nestedData['email'] = $user->email;
                $nestedData['mobileNo'] = $user->mobileNo;
                $nestedData['isProfileUpdated'] = ($user->isProfileUpdated == 1) ? 'Updated' : 'Not Updated';
                $nestedData['created_at'] = date('j M Y h:i a', strtotime($user->created_at));
                $nestedData['action'] = $btn;
                $data[] = $nestedData;
            }
        }

        $json_data = array(
            "draw" => intval($request->input('draw')),
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );

        echo json_encode($json_data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {
        return view('backend.users.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
        $this->validate($request, [
            'firstName' => 'required',
            'lastName' => 'required',
            'email' => 'required|email|unique:users',
            'mobileNo' => 'required',
            'password' => 'required|confirmed',
            'password_confirmation' => 'required',
            //'user_address' => 'required',
        ]);

        $posted_array['firstName'] = $request->firstName;
        $posted_array['lastName'] = $request->lastName;
        $posted_array['email'] = $request->email;
        $posted_array['mobileNo'] = $request->mobileNo;
        $posted_array['password'] = Hash::make($request->password);
        $posted_array['isProfileUpdated'] = $request->isProfileUpdated;
        $posted_array['user_address'] = $request->user_address;

        $userId = User::create($posted_array)->id;
        if ($userId) {
            //auto user verification on user creation by admin
            $userVarified = \Illuminate\Support\Facades\DB::table('users')->where('id', $userId)->update(['email_verified_at' => date('Y-m-d H:i:s')]);
        }
        if ($userId && $request->email) {
            /*-- send notification to user on account creation --*/
            $accountCreationLeadNotificationData['view'] = 'user_creation_lead';
            $accountCreationLeadNotificationData['subject'] = \App\Helpers\Helpers::projectName().' - '.' User account creation.';
            $accountCreationLeadNotificationData['to'] = $request->email;//'manojk.sharma@dotsquares.com';
            $accountCreationLeadNotificationData['params']['user_first_name'] = $request->firstName;
            $accountCreationLeadNotificationData['params']['login_user_name'] = $request->email;
            $accountCreationLeadNotificationData['params']['login_user_paaswd'] = $request->password;
            $emailSendStatus = \App\Helpers\Helpers::sendMail($accountCreationLeadNotificationData);
        }
        //flash()->overlay(__('messages.Record created successfully.'));
        flash(__('messages.Record created successfully.'), 'success');
        return redirect('/backend/users');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id) {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id) {
        
         $user_data = User::where('id',$id)->select('id','name','email')->first();
      
        return view('backend.users.edit', compact('user_data'));
        
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
  public function update(Request $request,$id){
     
         $validator = Validator::make($request->all(), [
            'name' => 'required',
            'email' => 'required|email',
            
        ]);
 
        if ($validator->fails()) {
            return  redirect()->back() ->withErrors($validator)
            ->withInput();
          
        }
           $data = array();
            $data['name'] = $request->name;
            $data['email'] = $request->email;
           
           User::where('id',$id)->update($data);
           return redirect('/backend/dashboard')->with('success','User details updated successfully');;
           
          
        
    }
    public function showChanegePasswordGet() {

        return view('backend.users.change-password');
       
    }
    public function changePasswordPost(Request $request) {
        
        if (!(Hash::check($request->get('current-password'), Auth::user()->password))) {
            // The passwords matches
            return redirect()->back()->with("error","Your current password does not matches with the password.");
        }

        if(strcmp($request->get('current-password'), $request->get('new-password')) == 0){
            // Current password and new password same
            return redirect()->back()->with("error","New Password cannot be same as your current password.");
        }

        $validatedData = $request->validate([
            'current-password' => 'required',
            'new-password' => 'required|string|min:8|confirmed',
        ]);

        //Change Password
        $user = Auth::user();
        $user->password = bcrypt($request->get('new-password'));
        $user->save();

        return redirect()->back()->with("success","Password successfully changed!");
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id) {
        if (auth()->user() == $user) {
            flash()->overlay("You can't delete yourself.");

            return redirect('/backend/users');
        }

        $user->delete();
        //flash()->overlay(__('messages.Record has been deleted.'),'success');
        flash(__('messages.Record has been deleted.'), 'success');

        return redirect('/backend/users');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Makemodel  $makemodel
     * @return \Illuminate\Http\Response
     */
    public function remove(Request $request) {
        $sID = $request->sID;
        $jsonArray = array('flag' => false);
        if (User::destroy($sID)) {
            $jsonArray['flag'] = true;
        }
        echo json_encode($jsonArray);
        exit;
    }
	
	
	public function userLeaderBoard(Request $request) {
        $gameListArray = Game::pluck('gameName', 'id')->all();
		$users = User::pluck('firstName', 'id')->all();
        $userListArray[0] = 'Please Select';
        if (!empty($users)) {
            foreach ($users as $key => $value) {
                $userListArray[$key] = $value;
            }
        }
		return view('backend.users.userleaderboard', compact('gameListArray', 'userListArray'));
    }

    /**
     * Display the specified resource by ajax request.
     *
     * @param  \App\Models\Configuration  $user
     * @return \Illuminate\Http\Response
     */
    public function getLeaderBoard(Request $request) {
        $order_by = array();
        $length = $request->length;
        $start = $request->start;
        $columnData = array(
            '#',
            'firstName',
            'gameName',
            'totalGames',
            'totalWins',
            'winStreak',
            'totalGamesFromComputer',
            'totalWinsFromComputer',
            'totalGamesFromFriend',
            'totalWinsFromFriend',
            'totalGamesFromIndian',
            'totalWinsFromIndian',
            'totalGamesFromClassic',
            'totalWinsFromClassic',
            'created_at'
        );
        $sortData = $request->order;
        $order_by[0] = $columnData[$sortData[0]['column']];
        $order_by[1] = $sortData[0]['dir'];
        $searchData = $request->searchBox;

        $totalData = Usergameinfo::count();

        $totalFiltered = $totalData;
        $jsonArray = array(
            'draw' => $request->draw,
            'recordsTotal' => $totalData,
            'recordsFiltered' => $totalData,
            'data' => array(),
        );

        $userGameInfosQuery = Usergameinfo::select('users.firstName', 'users.lastName', 'users.earnedCoins', 'users.bonusCoins', 'users.realMoney', 'users.mobileNo', 'usergameinfos.id', 'usergameinfos.gameId', 'usergameinfos.userId', 'usergameinfos.totalGames', 'usergameinfos.totalWins', 'usergameinfos.winStreak', 'usergameinfos.totalGamesFromComputer', 'usergameinfos.totalWinsFromComputer', 'usergameinfos.totalGamesFromFriend', 'usergameinfos.totalWinsFromFriend', 'usergameinfos.totalGamesFromIndian', 'usergameinfos.totalWinsFromIndian', 'usergameinfos.totalGamesFromClassic', 'usergameinfos.totalWinsFromClassic', 'games.gameName', 'usergameinfos.created_at')
		->leftJoin('users', 'users.id', '=', 'usergameinfos.userId')
		->leftJoin('games', 'games.id', '=', 'usergameinfos.gameId');
        
		if($request->gameId){
			$gameId = $request->gameId;
			$userGameInfosQuery->Where('usergameinfos.gameId', $gameId);
		}
		if($request->userId){
			$userId = $request->userId;
			$userGameInfosQuery->Where('usergameinfos.userId', $userId);
		}
        if (!empty($request->searchBox)) {
            $search = $request->searchBox;
            $userGameInfosQuery->where(function ($q) use ($search) {
                $q->Where('id', 'LIKE', "%{$search}%")
                        ->orWhere('users.firstName', 'LIKE', "%{$search}%")
                        ->orWhere('games.gameName', 'LIKE', "%{$search}%")
                        ->orWhere('users.lastName', 'LIKE', "%{$search}%")
                        ->orWhere('users.mobileNo', 'LIKE', "%{$search}%")
                        ->orWhere('usergameinfos.created_at', 'LIKE', "%{$search}%");
            });
        }
        $totalFiltered = $userGameInfosQuery->count();
        $usergameinfos = $userGameInfosQuery->offset($start)
                ->limit($length)
                ->orderBy($order_by[0], $order_by[1])
                ->get();

        $data = array();

        if (!empty($usergameinfos)) {
            $btn = '';
            foreach ($usergameinfos as $key => $user) {
                $nestedData['sr_no'] = $start + $key + 1;
                $nestedData['firstName'] = $user->firstName;
                $nestedData['earnedCoins'] = $user->earnedCoins;
                $nestedData['bonusCoins'] = $user->bonusCoins;
                $nestedData['realMoney'] = $user->realMoney;
                $nestedData['gameName'] = $user->gameName;
                $nestedData['totalGames'] = $user->totalGames;
                $nestedData['totalWins'] = $user->totalWins;
                $nestedData['winStreak'] = $user->winStreak;
                $nestedData['totalGamesFromComputer'] = $user->totalGamesFromComputer;
                $nestedData['totalWinsFromComputer'] = $user->totalWinsFromComputer;
                $nestedData['totalGamesFromFriend'] = $user->totalGamesFromFriend;
                $nestedData['totalWinsFromFriend'] = $user->totalWinsFromFriend;
                $nestedData['totalGamesFromIndian'] = $user->totalGamesFromIndian;
                $nestedData['totalWinsFromIndian'] = $user->totalWinsFromIndian;
                $nestedData['totalGamesFromClassic'] = $user->totalGamesFromClassic;
                $nestedData['totalWinsFromClassic'] = $user->totalWinsFromClassic;
                $nestedData['created_at'] = date('j M Y h:i a', strtotime($user->created_at));
                $data[] = $nestedData;
            }
        }

        $json_data = array(
            "draw" => intval($request->input('draw')),
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );

        echo json_encode($json_data);
    }
	
	public function referal(Request $request, $id){
		$users = User::where('id', $id)->get();
		#$allUsers = User::pluck('firstName','referedByCode')->all();
		return view('backend.referal.index',compact('users'));
    }
	
	public function referalUser($referalCode){
		$users = User::where('referedByCode', $referalCode)
		->limit(4,0)
		->get();
		return $users;
	}
}
