<?php

namespace App\Imports;

use App\Models\Question;
use Maatwebsite\Excel\Concerns\ToModel;
use App\Models\Option;

class MultipleChoiceImportsQuestion implements ToModel
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        if(isset($row[0]) && isset($row[1]) && isset($row[2]) && isset($row[3]) && isset($row[4]) && isset($row[5]) && isset($row[6]) && isset($row[7]) && isset($row[8]) && isset($row[9]) ){
			$posted_array['language_id'] = 1;
			$posted_array['question_category'] = trim($row[6]);
			$posted_array['question_topic'] = trim($row[7]);
            $posted_array['type_id'] = 9;
            $posted_array['question_instructions'] = trim($row[9]);
			$posted_array['question_title'] = trim($row[0]);
            $posted_array['right_answer'] = trim($row[5]);
			
			$question_id = Question::create($posted_array)->id;
			
			$option_array['optionOne'] = trim($row[1]);
			$option_array['optionTwo'] = trim($row[2]);
			$option_array['optionThree'] = trim($row[3]);
			$option_array['optionFour'] = trim($row[4]);
            
			$answer_option = trim($row[5]);
			
			foreach($option_array as $key => $value){
				$saveOption = array();
				$optionCorrectAnswer = 0;
				if($value == $answer_option){
					$optionCorrectAnswer = 1;
				}
				$saveOption = array(
					'question_id' => $question_id,
					'option_value' => $value,
					'correct_answer' => $optionCorrectAnswer
				);
				
				$questionoption = Option::create($saveOption);
			}
			
			return $questionoption;
		}
    }
}
