<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('questions', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('language_id')->default(1);
			$table->unsignedInteger('type_id')->nullable();
            $table->text('question_category')->nullable();
            $table->text('question_topic')->nullable();
            $table->longText('question_instructions')->nullable();
            $table->unsignedInteger('question_number')->nullable();
			$table->longText('question_title')->nullable();
			$table->longText('question_desc')->nullable();
			$table->longText('question_image')->nullable();
			$table->longText('image_caption')->nullable();
            $table->text('right_answer')->nullable();
            $table->integer('number_of_steps')->nullable();
			$table->tinyInteger('question_is_active')->default(1);
			$table->tinyInteger('question_is_deleted')->default(0);
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->nullable()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('questions');
    }
};
