<div class="form-group{{ $errors->has('config_key') ? ' has-error' : '' }}">
    {!! Form::label('config_key', 'Config Key', ['class' => 'control-label']) !!}
    @if(\Route::getCurrentRoute()->getActionMethod() == 'edit')
        {!! Form::text('config_key', null, ['class' => 'form-control', 'autofocus', 'disabled']) !!}
        {{ Form::hidden('config_key') }}
    @else
        {!! Form::text('config_key', null, ['class' => 'form-control', 'autofocus']) !!}
    @endif
    <span class="help-block">
        <strong>{{ $errors->first('config_key') }}</strong>
    </span>
</div>

<div class="form-group{{ $errors->has('config_value') ? ' has-error' : '' }}">
    {!! Form::label('config_value', 'Config Value', ['class' => 'control-label']) !!}
    @if(\Route::getCurrentRoute()->getActionMethod() == 'edit' && $configuration->config_key == "admin_email")
        {!! Form::email('config_value', null, ['class' => 'form-control', 'autofocus', 'oninvalid' => "this.setCustomValidity('".'Please enter the valid email'."')", 'oninput' => "setCustomValidity('')"]) !!}
        <p>{{'Note: Admin email address used to get the all email notifications generated by the system.'}}</p>
    @else
        {!! Form::text('config_value', null, ['class' => 'form-control', 'autofocus']) !!}
    @endif
    <span class="help-block">
        <strong>{{ $errors->first('config_value') }}</strong>
    </span>
</div>

<div class="form-group{{ $errors->has('config_label') ? ' has-error' : '' }}">
    {!! Form::label('config_label', 'Config Label', ['class' => 'control-label']) !!}
    {!! Form::text('config_label', null, ['class' => 'form-control', 'autofocus']) !!}
    <span class="help-block">
        <strong>{{ $errors->first('config_label') }}</strong>
    </span>
</div>
