@extends('layouts.backend.master')
@section('content')
<div class="content-wrapper">
    <section class="content-header">
        <h1><i class="fa fa-user"></i>Reply</h1>
    </section>
    <section class="content container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-header">
                        <h3 class="box-title">User Reply</h3>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                        <form method="POST" action="{{ url('/backend/contacts/user-reply') }}">
							<input type="hidden" name="_token" value="{{csrf_token()}}">
							<input type="hidden" name="contact_id" value="{{$user_id}}">
							<input type="hidden" name="contact_name" value="{{$user_name}}">
							<div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">
								{!! Form::label('email', 'Email', ['class' => 'control-label']) !!}
								
								<input type="text" name="email" value="{{$user_email}}" class="form-control" readonly>
								<span class="help-block">
									<strong>{{ $errors->first('email') }}</strong>
								</span>
							</div>
							<div class="form-group{{ $errors->has('reply_message') ? ' has-error' : '' }}">
								{!! Form::label('reply_message', 'Message', ['class' => 'control-label']) !!}
								{!! Form::textarea('reply_message', null, ['class' => 'form-control', 'autofocus']) !!}
								<span class="help-block">
									<strong>{{ $errors->first('reply_message') }}</strong>
								</span>
							</div>
							<div class="box-footer">
                            <button color="primary" type="submit" class="btn btn-info pull-left">{{ __('send')}}</button>
							</div>
						</form>
					</div>
            </div>
        </div>
    </section>
</div>

@endsection