@extends('layouts.backend.master')
@section('content')
<div class="content-wrapper">
    <section class="content-header">
        <h1><i class="fa fa-user"></i> Edit FAQ <small>
		Control Panel Manage FAQ</small></h1>
        <ol class="breadcrumb">
            <li><a href="{{ url('backend/faqs') }}"><i class="fa fa-dashboard"></i>{{ __('Go Back')}}</a></li>
            <li class="active">Edit FAQ</li>
        </ol>
    </section>
    <section class="content container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-header">
                        <h3 class="box-title">Edit FAQ</h3>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                        {!! Form::model($faq, ['method' => 'PUT', 'url' => "/backend/faqs/{$faq->id}", 'class' => '', 'role' => 'form', 'files' => true]) !!}

                        <div class="form-group{{ $errors->has('question') ? ' has-error' : '' }}">
                            {!! Form::label('question', 'Question', ['class' => 'control-label']) !!}
                            {!! Form::text('question', null, ['class' => 'form-control', 'required']) !!}
                            <span class="help-block">
                                <strong>{{ $errors->first('question') }}</strong>
                            </span>
                        </div>

                        <div class="form-group{{ $errors->has('answer') ? ' has-error' : '' }}">
                            {!! Form::label('answer', 'Answer', ['class' => 'control-label']) !!}
                            {!! Form::textarea('answer', null, ['class' => 'form-control', 'required', 'autofocus']) !!}
                            <span class="help-block">
                                <strong>{{ $errors->first('answear') }}</strong>
                            </span>
                        </div>
						  <div class="form-group{{ $errors->has('isActive') ? ' has-error' : '' }}">
                     				<select class="form-control" name="isActive">
                         @php $selectedRole = $faq->isActive; @endphp
            <option value="1" {{ $selectedRole == 1 ? 'selected="selected"' : '' }}>Active</option> 
			<option value="0" {{ $selectedRole == 0 ? 'selected="selected"' : '' }}>Inactive</option>			


</select>
						<span class="help-block">
                                <strong>{{ $errors->first('isActive') }}</strong>
                            </span>
						</div>
						
		
						
                        <div class="box-footer">
                            <button color="primary" type="submit" class="btn btn-info pull-left">Update</button>
                            <a href="{{ url('backend/users') }}" class="btn btn-default pull-right">Cancel</a>
                        </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

@endsection