@extends('layouts.backend.master')

@section('content')  
<div class="content-wrapper">
  <!-- Main content -->
  <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            <div class="card">
              <div class="card-header">
                <h3 class="card-title">Questions</h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                  @if(Session::has('success'))
            <div class="alert alert-success">
            <a href="#" class="close" data-dismiss="alert" aria-label="close" title="close">×</a>
                {{ Session::get('success') }}
                @php
                    Session::forget('success');
                @endphp
            </div>
            @endif
            @if ($errors->any())
                <div class="alert alert-danger">
                <a href="#" class="close" data-dismiss="alert" aria-label="close" title="close">×</a>
                @foreach ($errors->all() as $error)
                    {{ $error }}<br>
                @endforeach
                </div>
                @endif
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>QuestionNo</th>
                    <th>Question</th>
                    <th>Topic</th>
                    <th>Instructions</th>
                    <th>Right Answer </th>
                    <th>Action</th>
                  </tr>
                  </thead>
                  <tbody>
                  @forelse ($question_data as $question)
                  <tr>
                    <td>{{$question->id }} </td>
                    <td>{{$question->question_title}} </td>
                    <td>{{$question->question_topic}}</td>
                    <td> {{$question->question_instructions}} </td>
                    <td> {{$question->right_answer}} </td>
                    <td>
                        <a href="{{ url('backend/questions/edit/')}}/{{$question->id}}" data-toggle="tooltip" data-id="101" data-original-title="Edit" title="Edit" class="edit btn btn-primary btn-sm"><i class="fa fa-edit" title="Edit"></i></a>
                        <a href="{{ url('backend/questions/delete/')}}/{{$question->id}}" rel="101"  class="btn btn-danger btn-sm deleteRecord" title="Delete" onclick="return confirm('Are you sure you want to delete this item?');"><i class="fa fa-trash deleteRecord" rel="101" title="Delete"></i></a>
                    </td>
                  </tr>
                    @empty
                        <p>No Question Found.</p>
                    @endforelse
                  

                 
                  </tbody>
                  <tfoot>
                  <tr>
                  <th>QuestionNo</th>
                    <th>Question</th>
                    <th>Topic</th>
                    <th>Instructions</th>
                    <th>Right Answer </th>
                    <th>Action</th>
                    
                  </tr>
                  </tfoot>
                </table>
              </div>
              <!-- /.card-body -->
            
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    </div>
    <!-- /.content -->
    @endsection
