@extends('layouts.backend.master')
@section('content')
<div class="content-wrapper">
    <section class="content-header">
        <h1><i class="fa fa-picture-o"></i> Create Question <small>Control Panel Manage Questions</small></h1>
        <ol class="breadcrumb">
            <li><a href="{{ url('backend/questions') }}"><i class="fa fa-dashboard"></i>Go Back</a></li>
            <li class="active">Create</li>
        </ol>
    </section>
    <section class="content container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-header">
                        <h3 class="box-title">Create Question</h3>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                        {!! Form::open(['url' => '/backend/questions/save', 'class' => '', 'role' => 'form', 'files' => true]) !!}
                        <div class="hide form-group{{ $errors->has('typeId') ? ' has-error' : '' }}">
                            {!! Form::label('typeId', 'Question Type', ['class' => 'control-label']) !!}
                            {!! Form::select('typeId', $questiontype_array, null, ['class' => 'form-control', 'id'=> 'typeId', 'autofocus']) !!}
                            <span class="help-block text-danger">
                                <strong>{{ $errors->first('typeId') }}</strong>
                            </span>
                        </div>
                        <div id="form-body">
                            
                        @include('backend.questions.form_'.$question_type, ['questioncat_array' => $questioncat_array])

                        </div>
                        <div class="box-footer mb-3">
                            <button color="primary" type="submit" class="btn btn-info pull-left">Save</button>
                            <a href="{{ url('backend/questions/all') }}" class="btn btn-default pull-right">Cancel</a>
                        </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

@endsection
