@extends('layouts.backend.master')
@section('content')
<div class="content-wrapper">
    <section class="content-header">
        <h1><i class="fa fa-picture-o"></i> Edit Question <small>Control Panel Manage Questions</small></h1>
        <ol class="breadcrumb">
            <li><a href="{{ url('backend/questions') }}"><i class="fa fa-dashboard"></i>Go Back</a></li>
            <li class="active">Edit</li>
        </ol>
    </section>
    <section class="content container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    
                    <!-- /.box-header -->
                    <div class="box-body">
                    <form class="" action="{{ url('backend/questions/update',[$question_data->id]) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="position-relative form-group">
                            {!! Form::label('typeId', 'Question Type', ['class' => 'control-label']) !!}
                            {!! Form::select('typeId', $questiontype_array, $question_data->type_id, ['class' => 'form-control', 'disabled'=>true, 'id'=> 'typeId', 'autofocus']) !!}
                            
                        </div>

                        <div class="position-relative form-group">
                        <label for="question_category" class="">Question Category</label>
                        {!! Form::select('question_category', $questioncat_array, $question_data->question_category, ['class' => 'form-control', 'id'=> 'typequestion_categoryId', 'autofocus']) !!}
                        
                        </div>  

                        <div class="position-relative form-group">
                        <label for="question_topic" class="">Question Topic</label>
                        @if($question_data->type_id =='9')  
                        {!! Form::select('question_topic', $question_topics_multi_choice, $question_data->question_topic, ['class' => 'form-control', 'id'=> 'question_topic', 'autofocus']) !!}
                        @elseif($question_data->type_id =='10')
                        {!! Form::select('question_topic', $question_topics_flash_card, $question_data->question_topic, ['class' => 'form-control', 'id'=> 'question_topic', 'autofocus']) !!}
                        @elseif($question_data->type_id =='2')
                        {!! Form::select('question_topic', $question_topic_fill_in_the_blank, $question_data->question_topic, ['class' => 'form-control', 'id'=> 'question_topic', 'autofocus']) !!}
                        @elseif($question_data->type_id =='3')
                        {!! Form::select('question_topic', $number_question_topic, $question_data->question_topic, ['class' => 'form-control', 'id'=> 'question_topic', 'autofocus']) !!}
                        @elseif($question_data->type_id =='4')
                        {!! Form::select('question_topic', $question_topic_true_and_false, $question_data->question_topic, ['class' => 'form-control', 'id'=> 'question_topic', 'autofocus']) !!}
                        @elseif($question_data->type_id =='5')
                        {!! Form::select('question_topic', $question_topic_either_or, $question_data->question_topic, ['class' => 'form-control', 'id'=> 'question_topic', 'autofocus']) !!}
                        @elseif($question_data->type_id =='6')
                        {!! Form::select('question_topic', $question_topic_six_of_best, $question_data->question_topic, ['class' => 'form-control', 'id'=> 'question_topic', 'autofocus']) !!}
                        @elseif($question_data->type_id =='7')
                        {!! Form::select('question_topic', $question_topic_sequence, $question_data->question_topic, ['class' => 'form-control', 'id'=> 'question_topic', 'autofocus']) !!}
                        @elseif($question_data->type_id =='8')
                        {!! Form::select('question_topic', $question_topic_matching_item, $question_data->question_topic, ['class' => 'form-control', 'id'=> 'question_topic', 'autofocus']) !!}
                        
                        
                        @else
                        {!! Form::select('question_topic', $questioncat_array, $question_data->question_topic, ['class' => 'form-control', 'id'=> 'question_topic', 'autofocus']) !!}
                        @endif  
                       
                    </div>  

                        <div class="position-relative form-group">
                        <label for="question_instructions" class="">Question Instructions</label>
                        <textarea class="form-control" name="question_instructions" rows="4" placeholder="Question Instructions">{{ $question_data->question_instructions }}</textarea>
                        </div>
                        @if($question_data->type_id =='8') 
                      
                        <div class="row">
                        <div class="col-lg-6">
                        <div class="form-group{{ $errors->has('questionTitle') ? ' has-error' : '' }}">
                                {!! Form::label('question_title',' First Parts:', ['class' => 'control-label']) !!}
                                @if ($question_data->question_title != "")
                                  
                                <?php 
                                     $question1 =  str_replace('[', '', $question_data->question_title);
                                     $question2 =  str_replace(']', '', $question1);
                                      ?>
                                @foreach(explode(",",$question2)  as $question_title)
                                    <input class="form-control @if($loop->last) @else mb-2 @endif" type="text" name="question_title[]" value="{{str_replace('"','',$question_title)}}">
                                @endforeach

                                @endif
                                
                                <span class="help-block text-danger">
                                    <strong>{{ $errors->first('question_title') }}</strong>
                                </span>

                            </div>
                        </div>
                            <div class="col-lg-6">
                            <div class="form-group {{ $errors->has('right_answer') ? ' has-error' : '' }}">
                                {!! Form::label('correctMatches','Correct Matches:', ['class' => 'control-label']) !!}
                                @if ($question_data->right_answer != "")
                                <?php
                                     $ans1 =  str_replace('[', '', $question_data->right_answer);
                                     $ans2  =  str_replace(']', '', $ans1);
                                     ?>
                                
                                  
                                @foreach(explode(",",$ans2) as $right_answer)
                                    <input class="form-control  @if($loop->last) @else mb-2 @endif " type="text" name="right_answer[]" value="{{str_replace('"','',$right_answer)}}">
                                   
                                @endforeach
                                @endif
                                
                                    <span class="help-block text-danger">
                                        <strong>{{ $errors->first('right_answer') }}</strong>
                                    </span>
                            </div>
                        </div>
                    </div>


                        @elseif($question_data->type_id =='7' || $question_data->type_id =='6' )
                       
                       
                                <div class="position-relative form-group">
                                <label for="question_title" class="">Question</label>

                                <textarea class="form-control" name="question_title" rows="4" placeholder="Question Title">{{ $question_data->question_title }}</textarea>
                                </div>
                                <div class="row">
                                <div class="col-lg-6">
                                <div class="form-group">
                                    {!! Form::label('answeroptions',' Answer Options:', ['class' => 'control-label']) !!}
                                    <?php $x=1 ?>
                                
                                    @foreach ($options_arry as $options_data)
                                    @if($options_data->option_value != null)
                                    <?php $value = str_pad($x++, 2, "0", STR_PAD_LEFT);?>
                                    <input name="answer<?php print $value ?>" id="answer<?php print $value ?>"  type="text" class="form-control mb-2"  value="{{ $options_data->option_value }}">
                                     
                                    @endif

                                    @endforeach
                                    </div>
                                    </div>
                                    <div class="col-lg-6">
                            <div class="form-group {{ $errors->has('right_answer') ? ' has-error' : '' }}">
                                {!! Form::label('correctMatches','Correct Matches:', ['class' => 'control-label']) !!}
                                @if ($question_data->right_answer != "")
                                <?php
                                     $ans1 =  str_replace('[', '', $question_data->right_answer);
                                     $ans2  =  str_replace(']', '', $ans1);
                                     ?>
                                
                                  
                                @foreach(explode(",",$ans2) as $right_answer)
                                    <input class="form-control  @if($loop->last) @else mb-2 @endif " type="text" name="right_answer[]" value="{{str_replace('"','',$right_answer)}}">
                                   
                                @endforeach
                                @endif
                                
                                    <span class="help-block text-danger">
                                        <strong>{{ $errors->first('right_answer') }}</strong>
                                    </span>
                            </div>
                        </div>
                        </div>
                        @else
                       
                                <div class="position-relative form-group">
                                <label for="question_title" class="">Question</label>

                                <textarea class="form-control" name="question_title" rows="4" placeholder="Question Title">{{ $question_data->question_title }}</textarea>
                                </div>
                                <?php $x=1 ?>
                            
                                @foreach ($options_arry as $options_data)
                                @if($options_data->option_value != null)
                                <?php $value = str_pad($x++, 2, "0", STR_PAD_LEFT);?>
                                <div class="position-relative form-group">
                                <label for="question_topic" class="">Answer <?php print $value ?></label>
                                <input name="answer<?php print $value ?>" id="answer<?php print $value ?>"  type="text" class="form-control"  value="{{ $options_data->option_value }}">
                                </div>  
                                @endif
                                @endforeach
                                <div class="position-relative form-group">
                                <label for="right_answer" class="">Right Answer</label>
                                <input name="right_answer" id="right_answer" placeholder="Right Answer*" type="text" class="form-control"  value="{{old('right_answer',$question_data->right_answer)}}">
                                </div>
                        @endif 

                        <button class="mt-1 btn btn-primary mb-3" type="submit">Update</button>

                    </form>
                        

                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

@endsection