@extends('layouts.backend.master')
@section('content')
<div class="content-wrapper">
    <section class="content-header">
        <h1><i class="fa fa-picture-o"></i><small>Control Panel Manage Questions</small></h1>
        
        {{--<ol class="breadcrumb">
            <li><a href="{{ url('backend/questions') }}"><i class="fa fa-dashboard"></i>Go Back</a></li>
            <li class="active">Import</li>
        </ol>--}}
    </section>
    @if(Session::has('success'))
    <div class="alert alert-success">
        {{Session::get('success')}}
    </div>
    @endif
    
    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif
    <section class="content container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-header">
                        <h3 class="box-title">Import Question</h3>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
						 {!! Form::open(['url' => '/backend/questions/import', 'class' => '', 'role' => 'form', 'files' => true]) !!}
                        
							<div class="form-group mb-4">
                                <div class="custom-file text-left">
                                    <label for="question_type" >Question Type</label>
									<select name="question_type" id="question_type" required>
                                        <option value="">--select--</option>
                                        @foreach($types as $type)
                                            <option value="{{ $type->id }}">{{ $type->type_title }}</option>
                                        @endforeach
                                    </select>
								</div>

								<div class="custom-file text-left">
                                    <input type="file" name="file" class="custom-file-input" id="customFile" value="">
									<label class="custom-file-label" for="customFile">Choose file</label>
								</div>
							</div>
							<button class="btn btn-primary">Import Questions</button>
							<a class="btn btn-success" href="{{ url('backend/questions/export-questions') }}">Export Questions</a>
						{!! Form::close() !!}
                        
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

@endsection