@extends('layouts.backend.master')
@section('content')
<div class="content-wrapper">
    <section class="content-header">
        <h1><i class="fa fa-user"></i> Edit User <small>
		Control Panel Manage User</small></h1>
        <ol class="breadcrumb">
            <li><a href="{{ url('backend/users') }}"><i class="fa fa-dashboard"></i>{{ __('messages.Go Back')}}</a></li>
            <li class="active">Edit User</li>
        </ol>
    </section>
    <section class="content container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-header">
                        <h3 class="box-title">Edit User</h3>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                         @if ($errors->any())
                                <div class="alert alert-danger">
                                <a href="#" class="close" data-dismiss="alert" aria-label="close" title="close">×</a>
                                @foreach ($errors->all() as $error)
                                    {{ $error }}<br>
                                @endforeach
                                </div>
                            @endif
                            <form class="" action="{{ url('/backend/users/update',[$user_data->id]) }}" method="POST">
                            @csrf
                            @method('PUT')
                      
                        
                        <div class="form-group">
                            <label for="Name" class="control-label">Name</label>
                            <input class="form-control"  name="name" type="text" value="{{$user_data->name}}">
                            <span class="help-block">
                                <strong></strong>
                            </span>
                        </div>
                         <div class="form-group">
                            <label for="Email" class="control-label">Email</label>
                            <input class="form-control"  name="email" type="text" value="{{$user_data->email}}">
                            <span class="help-block">
                                <strong></strong>
                            </span>
                        </div> 

                        <div class="box-footer">
                            <button color="primary" type="submit" class="btn btn-info pull-left">Update</button>
                            <a href="{{ url('backend/users') }}" class="btn btn-default pull-right">Cancel</a>
                        </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

@endsection