<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/clear', function() {
    Artisan::call('cache:clear');
    Artisan::call('config:cache');
    Artisan::call('view:clear');
    return "Cleared!";
    });

Auth::routes(['register' => false]);
Route::get('/', [App\Http\Controllers\HomeController::class, 'index']);
Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
//Route::get('/', [App\Http\Controllers\TestController::class, 'index'])->name('test');

//Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');


Route::group(['prefix' => 'backend', 'as' => 'backend.', 'namespace' => 'Backend', 'middleware' => ['admin']], function () {
    
    Route::get('/dashboard', [App\Http\Controllers\Backend\DashboardController::class, 'index'])->name('dashboard');

    Route::get('/questions/file-import',[App\Http\Controllers\Backend\QuestionController::class, 'importView']);
    Route::post('/questions/import',[App\Http\Controllers\Backend\QuestionController::class, 'import'])->name('import');
	Route::get('/questions/export-questions',[App\Http\Controllers\Backend\QuestionController::class, 'exportQuestions'])->name('export-questions');
    Route::get('/questions/create/{id}', [App\Http\Controllers\Backend\QuestionController::class, 'add'])->name('add');
    Route::post('/questions/save', [App\Http\Controllers\Backend\QuestionController::class, 'store'])->name('save');
    
    Route::get('/questions/all',[App\Http\Controllers\Backend\QuestionController::class, 'allQuestion'])->name('all-questions');
    Route::get('/questions/edit/{id}',[App\Http\Controllers\Backend\QuestionController::class, 'editQuestion'])->name('edit-question');
    Route::put('/questions/update/{id}',[App\Http\Controllers\Backend\QuestionController::class, 'updateQuestion'])->name('question-update');
     Route::get('/questions/delete/{id}',[App\Http\Controllers\Backend\QuestionController::class, 'destroy'])->name('question-delete');
    Route::get('/users/edit/{id}', [App\Http\Controllers\Backend\UsersController::class, 'edit'])->middleware('admin');
	Route::put('/users/update/{id}', [App\Http\Controllers\Backend\UsersController::class, 'update'])->middleware('admin');
    Route::get('/update-password',[App\Http\Controllers\Backend\UsersController::class, 'showChanegePasswordGet'])->middleware('admin');
    Route::post('/change-password-post',[App\Http\Controllers\Backend\UsersController::class, 'changePasswordPost'])->middleware('admin');
    Route::get('/load-form/{id}',[App\Http\Controllers\Backend\QuestionController::class, 'loadForm'])->middleware('admin');
    


});